/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.mobile;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.net.URI;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import org.exoplatform.mobile.QRcodeUtil;
import org.exoplatform.services.rest.resource.ResourceContainer;

@Path(value="/mobile")
@Tag(name="/mobile", description="Providing mobile application link")
public class MobileRestService
implements ResourceContainer {
    @GET
    @Path(value="/app/download")
    @Operation(summary="redirect the user to the appropriate link to download the mobile application", method="GET", description="Use this method as an intermediate step when scanning the QR responseCode to download the mobile application. The method will parse the user agent provided in the header and will redirect the user to either google play or the app store.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled. user-agent pertaining to an android or an ios device"), @ApiResponse(responseCode="400", description="the device that requested the service is not an android or an ios")})
    public Response redirectToStore(@Parameter(description="the user-agent, ex: 'Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:47.0) Gecko/20100101 Firefox/47.0'", required=true) @HeaderParam(value="user-agent") String userAgent) {
        if (QRcodeUtil.isIphone(userAgent)) {
            return Response.temporaryRedirect((URI)URI.create(QRcodeUtil.appleDownloadUrl)).build();
        }
        if (QRcodeUtil.isAndroid(userAgent)) {
            return Response.temporaryRedirect((URI)URI.create(QRcodeUtil.androidDownloadUrl)).build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"please use an iphone or an android to scan the qr code").build();
    }
}

