/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.oauth.linkedin;

import com.github.scribejava.apis.LinkedInApi20;
import com.github.scribejava.core.builder.ServiceBuilder;
import com.github.scribejava.core.builder.api.DefaultApi20;
import com.github.scribejava.core.model.OAuth2AccessToken;
import com.github.scribejava.core.oauth.OAuth20Service;
import io.meeds.oauth.exception.OAuthException;
import io.meeds.oauth.exception.OAuthExceptionCode;
import io.meeds.oauth.linkedin.LinkedinAccessTokenContext;
import io.meeds.oauth.linkedin.LinkedinProcessor;
import io.meeds.oauth.spi.InteractionState;
import io.meeds.oauth.spi.OAuthCodec;
import io.meeds.oauth.utils.OAuthPersistenceUtils;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.web.security.security.SecureRandomService;

public class LinkedinProcessorImpl
implements LinkedinProcessor {
    private static Log log = ExoLogger.getLogger(LinkedinProcessorImpl.class);
    private final String redirectURL;
    private final String apiKey;
    private final String apiSecret;
    private String scope = "openid profile email";
    private final SecureRandomService secureRandomService;
    private final int chunkLength;
    public OAuth20Service oAuth20Service;

    public LinkedinProcessorImpl(ExoContainerContext context, SecureRandomService secureRandomService, InitParams params) {
        this.secureRandomService = secureRandomService;
        this.apiKey = params.getValueParam("apiKey").getValue();
        this.apiSecret = params.getValueParam("apiSecret").getValue();
        String redirectURLParam = params.getValueParam("redirectURL").getValue();
        if (this.apiKey == null || this.apiKey.length() == 0 || this.apiKey.trim().equals("<<to be replaced>>")) {
            throw new IllegalArgumentException("Property 'clientId' needs to be provided. The value should be clientId of your Twitter application");
        }
        if (this.apiSecret == null || this.apiSecret.length() == 0 || this.apiSecret.trim().equals("<<to be replaced>>")) {
            throw new IllegalArgumentException("Property 'clientSecret' needs to be provided. The value should be clientSecret of your Twitter application");
        }
        this.redirectURL = redirectURLParam == null || redirectURLParam.length() == 0 ? "http://localhost:8080/" + context.getName() + "/twitterAuth" : redirectURLParam.replaceAll("@@portal.container.name@@", context.getName());
        if (log.isDebugEnabled()) {
            log.debug((Object)("configuration: apiKey=" + this.apiKey + ", apiSecret=" + this.apiSecret + ", redirectURL=" + this.redirectURL));
        }
        this.chunkLength = OAuthPersistenceUtils.getChunkLength(params);
        this.oAuth20Service = new ServiceBuilder(this.apiKey).apiSecret(this.apiSecret).callback(this.redirectURL).build((DefaultApi20)LinkedInApi20.instance());
    }

    public LinkedinProcessorImpl(String apiKey, String apiSecret, String redirectURL, String scope, int chunkLength) {
        this.apiSecret = apiSecret;
        this.apiKey = apiKey;
        this.scope = scope;
        this.redirectURL = redirectURL;
        this.chunkLength = chunkLength;
        this.oAuth20Service = new ServiceBuilder(apiKey).apiSecret(apiSecret).defaultScope(scope).callback(redirectURL).build((DefaultApi20)LinkedInApi20.instance());
        this.secureRandomService = (SecureRandomService)PortalContainer.getInstance().getComponentInstanceOfType(SecureRandomService.class);
    }

    @Override
    public InteractionState<LinkedinAccessTokenContext> processOAuthInteraction(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException, OAuthException, ExecutionException, InterruptedException {
        this.oAuth20Service = new ServiceBuilder(this.apiKey).apiSecret(this.apiSecret).defaultScope(this.scope).callback(this.redirectURL).build((DefaultApi20)LinkedInApi20.instance());
        if (httpRequest.getParameter("code") == null) {
            String redirect = this.oAuth20Service.getAuthorizationUrl("secret" + this.secureRandomService.getSecureRandom().nextLong());
            httpResponse.sendRedirect(redirect);
            return new InteractionState<Object>(InteractionState.State.AUTH, null);
        }
        String verifierCode = httpRequest.getParameter("code");
        if (verifierCode != null) {
            OAuth2AccessToken accessToken = this.oAuth20Service.getAccessToken(verifierCode);
            LinkedinAccessTokenContext accessTokenContext = new LinkedinAccessTokenContext(accessToken, this.oAuth20Service);
            return new InteractionState<LinkedinAccessTokenContext>(InteractionState.State.FINISH, accessTokenContext);
        }
        String oauthProblem = httpRequest.getParameter("oauth_problem");
        if ("user_refused".equals(oauthProblem)) {
            throw new OAuthException(OAuthExceptionCode.USER_DENIED_SCOPE, "User denied scope on LinkedIn authorization page");
        }
        throw new OAuthException(OAuthExceptionCode.LINKEDIN_ERROR, "Can not get oauth verifier code from LinkedIn");
    }

    @Override
    public InteractionState<LinkedinAccessTokenContext> processOAuthInteraction(HttpServletRequest httpRequest, HttpServletResponse httpResponse, String scope) throws IOException, OAuthException, ExecutionException, InterruptedException {
        this.oAuth20Service = scope != null ? new ServiceBuilder(this.apiKey).apiSecret(this.apiSecret).defaultScope(scope).callback(this.redirectURL).build((DefaultApi20)LinkedInApi20.instance()) : new ServiceBuilder(this.apiKey).apiSecret(this.apiSecret).callback(this.redirectURL).build((DefaultApi20)LinkedInApi20.instance());
        return this.processOAuthInteraction(httpRequest, httpResponse);
    }

    @Override
    public void revokeToken(LinkedinAccessTokenContext accessToken) throws OAuthException {
    }

    @Override
    public LinkedinAccessTokenContext validateTokenAndUpdateScopes(LinkedinAccessTokenContext accessToken) throws OAuthException {
        return accessToken;
    }

    @Override
    public <C> C getAuthorizedSocialApiObject(LinkedinAccessTokenContext accessToken, Class<C> socialApiObjectType) {
        return null;
    }

    @Override
    public void saveAccessTokenAttributesToUserProfile(UserProfile userProfile, OAuthCodec codec, LinkedinAccessTokenContext accessToken) {
        String encodedAccessToken = codec.encodeString(accessToken.accessToken.getAccessToken());
        OAuthPersistenceUtils.saveLongAttribute(encodedAccessToken, userProfile, "user.social-info.linkedin.accessToken", false, this.chunkLength);
    }

    @Override
    public LinkedinAccessTokenContext getAccessTokenFromUserProfile(UserProfile userProfile, OAuthCodec codec) {
        String encodedAccessToken = OAuthPersistenceUtils.getLongAttribute(userProfile, "user.social-info.linkedin.accessToken", false);
        String encodedAccessTokenSecret = OAuthPersistenceUtils.getLongAttribute(userProfile, "user.social-info.linkedin.accessTokenSecret", false);
        String decodedAccessToken = codec.decodeString(encodedAccessToken);
        String decodedAccessTokenSecret = codec.decodeString(encodedAccessTokenSecret);
        if (decodedAccessToken == null || decodedAccessTokenSecret == null) {
            return null;
        }
        OAuth2AccessToken token = new OAuth2AccessToken(decodedAccessToken, decodedAccessTokenSecret);
        return new LinkedinAccessTokenContext(token, this.oAuth20Service);
    }

    @Override
    public void removeAccessTokenFromUserProfile(UserProfile userProfile) {
        OAuthPersistenceUtils.removeLongAttribute(userProfile, "user.social-info.linkedin.accessToken", false);
        OAuthPersistenceUtils.removeLongAttribute(userProfile, "user.social-info.linkedin.accessTokenSecret", false);
    }
}

