/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.application;

import java.util.concurrent.CompletableFuture;
import org.gatein.common.concurrent.AtomicPositiveLong;
import org.gatein.common.concurrent.LongSampler;

public class ApplicationStatistic {
    private static final int ONE_SECOND = 20000;
    private final String appId;
    private final LongSampler times = new LongSampler(1000);
    private final LongSampler throughput = new LongSampler(1000);
    private final AtomicPositiveLong maxTime = new AtomicPositiveLong();
    private final AtomicPositiveLong minTime = new AtomicPositiveLong();
    private volatile long countRequest = 0L;

    public ApplicationStatistic(String appId) {
        this.appId = appId;
    }

    public String getAppId() {
        return this.appId;
    }

    public void logTime(long timeMillis) {
        CompletableFuture.runAsync(() -> {
            this.times.add((Object)timeMillis);
            this.throughput.add((Object)System.currentTimeMillis());
            this.maxTime.setIfGreater(timeMillis);
            this.minTime.setIfLower(timeMillis);
            ++this.countRequest;
        });
    }

    public double getMaxTime() {
        long maxTime = this.maxTime.get();
        if (maxTime == -1L) {
            return -1.0;
        }
        return maxTime;
    }

    public double getMinTime() {
        long minTime = this.minTime.get();
        if (minTime == -1L) {
            return -1.0;
        }
        return minTime;
    }

    public double getAverageTime() {
        return this.times.average();
    }

    public double getThroughput() {
        return this.throughput.countAboveThreshold(System.currentTimeMillis() - 20000L);
    }

    public long executionCount() {
        return this.countRequest;
    }
}

