/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.navigation;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.exoplatform.portal.mop.user.UserNode;

public class TreeNode {
    private boolean isExpanded_;
    private UserNode node_;
    private List<TreeNode> children_ = Collections.emptyList();
    private Map<String, TreeNode> cachedTreeNodes_;
    private TreeNode rootNode;

    public TreeNode() {
        this.cachedTreeNodes_ = new HashMap<String, TreeNode>();
        this.rootNode = this;
    }

    private TreeNode(UserNode node, TreeNode rootNode) throws Exception {
        this.node_ = node;
        this.isExpanded_ = false;
        this.rootNode = rootNode;
        this.setChildren(node.getChildren());
    }

    public boolean isExpanded() {
        return this.isExpanded_;
    }

    public void setExpanded(boolean isExpanded) {
        this.isExpanded_ = isExpanded;
    }

    public UserNode getNode() {
        return this.node_;
    }

    public List<TreeNode> getChildren() {
        return this.children_;
    }

    public int getChildrenSize() {
        return this.children_.size();
    }

    public void setChildren(Collection<UserNode> children) throws Exception {
        if (children == null) {
            return;
        }
        this.children_ = new LinkedList<TreeNode>();
        for (UserNode child : children) {
            TreeNode node = new TreeNode(child, this.rootNode);
            this.children_.add(node);
            this.rootNode.cachedTreeNodes_.put(child.getId(), node);
        }
    }

    public boolean hasChild() {
        return this.node_.getChildrenCount() > 0;
    }

    public TreeNode findNodes(String nodeId) {
        return this.rootNode.cachedTreeNodes_.get(nodeId);
    }
}

