/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.rest;

import io.meeds.gamification.constant.IdentityType;
import io.meeds.gamification.constant.Period;
import io.meeds.gamification.model.PiechartLeaderboard;
import io.meeds.gamification.model.StandardLeaderboard;
import io.meeds.gamification.model.filter.LeaderboardFilter;
import io.meeds.gamification.rest.builder.LeaderboardBuilder;
import io.meeds.gamification.rest.model.LeaderboardInfo;
import io.meeds.gamification.service.ProgramService;
import io.meeds.gamification.service.RealizationService;
import io.meeds.gamification.utils.Utils;
import io.meeds.portal.security.service.SecuritySettingService;
import io.meeds.social.translation.service.TranslationService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.manager.RelationshipManager;
import org.exoplatform.social.core.space.spi.SpaceService;

@Path(value="/gamification/leaderboard")
@Produces(value={"application/json"})
public class LeaderboardRest
implements ResourceContainer {
    private static final int DEFAULT_LOAD_CAPACITY = 10;
    protected IdentityManager identityManager = null;
    protected RealizationService realizationService = null;
    protected RelationshipManager relationshipManager;
    protected SpaceService spaceService;
    protected ProgramService programService;
    protected TranslationService translationService;
    protected SecuritySettingService securitySettingService;

    public LeaderboardRest(IdentityManager identityManager, RealizationService realizationService, RelationshipManager relationshipManager, SpaceService spaceService, ProgramService programService, TranslationService translationService, SecuritySettingService securitySettingService) {
        this.identityManager = identityManager;
        this.realizationService = realizationService;
        this.relationshipManager = relationshipManager;
        this.spaceService = spaceService;
        this.programService = programService;
        this.translationService = translationService;
        this.securitySettingService = securitySettingService;
    }

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve the list leaderboard users/spaces including the selected identity to retrieve its rank", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="401", description="Unauthorized operation")})
    public Response getIdentityLeaderboard(@Parameter(description="Program technical identifier to filter") @QueryParam(value="programId") Long programId, @Parameter(description="Type of leaderboard, whether users or spaces") @DefaultValue(value="USER") @QueryParam(value="identityType") IdentityType identityType, @Parameter(description="Identity technical identifier to include in results") @QueryParam(value="identityId") Long identityId, @Parameter(description="Current period: WEEK, MONTH or ALL") @DefaultValue(value="WEEK") @QueryParam(value="period") String period, @Parameter(description="Results offset") @DefaultValue(value="0") @QueryParam(value="offset") int offset, @Parameter(description="Results limit") @DefaultValue(value="0") @QueryParam(value="limit") int limit) {
        if (!Utils.canAccessAnonymousResources(this.securitySettingService)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        String currentUser = Utils.getCurrentUser();
        boolean isAnonymous = StringUtils.isBlank((CharSequence)currentUser);
        LeaderboardFilter leaderboardFilter = new LeaderboardFilter();
        leaderboardFilter.setIdentityType(identityType);
        leaderboardFilter.setProgramId(programId);
        leaderboardFilter.setIdentityId(identityId);
        leaderboardFilter.setPeriod(StringUtils.isBlank((CharSequence)period) ? Period.WEEK.name() : period.toUpperCase());
        leaderboardFilter.setOffset(offset);
        leaderboardFilter.setLimit(limit < 0 ? 10 : limit);
        try {
            List<StandardLeaderboard> standardLeaderboards = limit == 0 ? Collections.emptyList() : this.realizationService.getLeaderboard(leaderboardFilter, currentUser);
            List<LeaderboardInfo> leaderboardList = LeaderboardBuilder.buildLeaderboardInfos(this.realizationService, this.identityManager, this.spaceService, offset, standardLeaderboards, identityType, identityId, programId, period, isAnonymous);
            return Response.ok(leaderboardList).build();
        }
        catch (IllegalAccessException e) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
    }

    @GET
    @Path(value="stats/{identityId}")
    @Produces(value={"application/json"})
    @Operation(summary="Retrieves identity gamification statistics classified by program, ready to be displayed in a pie chart", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="401", description="Unauthorized operation")})
    public Response getIdentityStats(@Context HttpServletRequest request, @Parameter(description="Identity technical identifier") @PathParam(value="identityId") String identityId, @Parameter(description="Current period to consider. Possible values: WEEK, MONTH or ALL") @DefaultValue(value="WEEK") @QueryParam(value="period") String period) {
        if (!Utils.canAccessAnonymousResources(this.securitySettingService)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        period = StringUtils.isBlank((CharSequence)period) ? Period.ALL.name() : period.toUpperCase();
        List<PiechartLeaderboard> userStats = this.realizationService.getLeaderboardStatsByIdentityId(identityId, LeaderboardBuilder.getCurrentPeriodStartDate(period), Calendar.getInstance().getTime());
        userStats = LeaderboardBuilder.buildPiechartLeaderboards(this.programService, this.translationService, userStats, Utils.getCurrentUser(), request == null ? Locale.ENGLISH : request.getLocale());
        return Response.ok(userStats).build();
    }
}

