/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.translation.service;

import io.meeds.social.translation.model.TranslationEvent;
import io.meeds.social.translation.model.TranslationField;
import io.meeds.social.translation.plugin.TranslationPlugin;
import io.meeds.social.translation.service.TranslationService;
import io.meeds.social.translation.storage.TranslationStorage;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class TranslationServiceImpl
implements TranslationService {
    private static final Log LOG = ExoLogger.getLogger(TranslationServiceImpl.class);
    private static final String NO_PERMISSION_TO_ACCESS_MESSAGE = "User %s doesn't have enough permissions to access translations of object of type %s identified by %s";
    private static final String NO_PERMISSION_TO_EDIT_MESSAGE = "User %s doesn't have enough permissions to write translations of object of type %s identified by %s";
    private static final String NO_PERMISSION_TO_DELETE_MESSAGE = "User %s doesn't have enough permissions to delete translations of object of type %s identified by %s";
    private ListenerService listenerService;
    private TranslationStorage translationStorage;
    private Map<String, TranslationPlugin> translationPlugins = new HashMap<String, TranslationPlugin>();

    public TranslationServiceImpl(TranslationStorage translationStorage, ListenerService listenerService) {
        this.translationStorage = translationStorage;
        this.listenerService = listenerService;
    }

    public void addPlugin(TranslationPlugin translationPlugin) {
        this.translationPlugins.put(translationPlugin.getObjectType(), translationPlugin);
    }

    public void removePlugin(String objectType) {
        this.translationPlugins.remove(objectType);
    }

    public TranslationField getTranslationField(String objectType, long objectId, String fieldName, String username) throws IllegalAccessException, ObjectNotFoundException {
        this.checkParameters(objectType, objectId, fieldName);
        this.checkAccessPermission(objectType, objectId, username);
        return this.getTranslationField(objectType, objectId, fieldName);
    }

    public TranslationField getTranslationField(String objectType, long objectId, String fieldName) {
        return this.translationStorage.getTranslationField(objectType, objectId, fieldName);
    }

    public String getTranslationLabel(String objectType, long objectId, String fieldName, Locale locale) {
        return this.translationStorage.getTranslationLabel(objectType, objectId, fieldName, locale);
    }

    public void saveTranslationLabels(String objectType, long objectId, String fieldName, Map<Locale, String> labels, String username) throws IllegalAccessException, ObjectNotFoundException {
        this.checkParameters(objectType, objectId, fieldName);
        this.checkEditPermission(objectType, objectId, username, NO_PERMISSION_TO_EDIT_MESSAGE);
        this.saveTranslationLabelsNoBroadcast(objectType, objectId, fieldName, labels);
        this.broadcastEvent("translation.saved", objectType, objectId, fieldName, null, username);
    }

    public void saveTranslationLabels(String objectType, long objectId, String fieldName, Map<Locale, String> labels) throws ObjectNotFoundException {
        this.checkParameters(objectType, objectId, fieldName);
        this.saveTranslationLabelsNoBroadcast(objectType, objectId, fieldName, labels);
        this.broadcastEvent("translation.saved", objectType, objectId, fieldName, null, null);
    }

    public void saveTranslationLabel(String objectType, long objectId, String fieldName, Locale locale, String label) throws ObjectNotFoundException {
        this.checkParameters(objectType, objectId, fieldName, locale);
        TranslationPlugin translationPlugin = this.translationPlugins.get(objectType);
        long audienceId = translationPlugin.getAudienceId(objectId);
        long spaceId = translationPlugin.getSpaceId(objectId);
        this.translationStorage.saveTranslationLabel(objectType, objectId, fieldName, locale, label, audienceId, spaceId);
        this.broadcastEvent("translation.saved", objectType, objectId, fieldName, locale, null);
    }

    public void deleteTranslationLabels(String objectType, long objectId, String username) throws IllegalAccessException, ObjectNotFoundException {
        this.checkParameters(objectType, objectId);
        this.checkEditPermission(objectType, objectId, username, NO_PERMISSION_TO_DELETE_MESSAGE);
        this.deleteTranslationLabelsNoBroadcast(objectType, objectId);
        this.broadcastEvent("translation.deleted", objectType, objectId, null, null, username);
    }

    public void deleteTranslationLabels(String objectType, long objectId) throws ObjectNotFoundException {
        this.checkParameters(objectType, objectId);
        this.deleteTranslationLabelsNoBroadcast(objectType, objectId);
        this.broadcastEvent("translation.deleted", objectType, objectId, null, null, null);
    }

    public void deleteTranslationLabel(String objectType, long objectId, String fieldName, Locale locale) throws ObjectNotFoundException {
        this.checkParameters(objectType, objectId, fieldName, locale);
        this.translationStorage.deleteTranslationLabel(objectType, objectId, fieldName, locale);
        this.broadcastEvent("translation.deleted", objectType, objectId, fieldName, locale, null);
    }

    private void saveTranslationLabelsNoBroadcast(String objectType, long objectId, String fieldName, Map<Locale, String> labels) throws ObjectNotFoundException {
        if (MapUtils.isEmpty(labels)) {
            throw new IllegalArgumentException("labels is empty");
        }
        TranslationPlugin translationPlugin = this.translationPlugins.get(objectType);
        long audienceId = translationPlugin.getAudienceId(objectId);
        long spaceId = translationPlugin.getSpaceId(objectId);
        this.translationStorage.saveTranslationLabels(objectType, objectId, fieldName, labels, audienceId, spaceId);
    }

    private void deleteTranslationLabelsNoBroadcast(String objectType, long objectId) {
        this.translationStorage.deleteTranslationLabels(objectType, objectId);
    }

    private void broadcastEvent(String eventName, String objectType, long objectId, String fieldName, Locale locale, String username) {
        try {
            this.listenerService.broadcast(eventName, (Object)new TranslationEvent(objectType, objectId, fieldName, locale), (Object)username);
        }
        catch (Exception e) {
            LOG.warn("An error occurred while broadcasting event {} for object type {} identified by {}", new Object[]{objectType, objectId, e});
        }
    }

    private void checkAccessPermission(String objectType, long objectId, String username) throws ObjectNotFoundException, IllegalAccessException {
        TranslationPlugin translationPlugin = this.translationPlugins.get(objectType);
        if (!translationPlugin.hasAccessPermission(objectId, username)) {
            throw new IllegalAccessException(String.format(NO_PERMISSION_TO_ACCESS_MESSAGE, username, objectType, objectId));
        }
    }

    private void checkEditPermission(String objectType, long objectId, String username, String message) throws ObjectNotFoundException, IllegalAccessException {
        TranslationPlugin translationPlugin = this.translationPlugins.get(objectType);
        if (!translationPlugin.hasEditPermission(objectId, username)) {
            throw new IllegalAccessException(String.format(message, username, objectType, objectId));
        }
    }

    private void checkParameters(String objectType, long objectId, String fieldName, Locale locale) {
        this.checkParameters(objectType, objectId, fieldName);
        if (StringUtils.isBlank((CharSequence)fieldName)) {
            throw new IllegalArgumentException("Field name is mandatory");
        }
        if (locale == null) {
            throw new IllegalArgumentException("locale is mandatory");
        }
    }

    private void checkParameters(String objectType, long objectId, String fieldName) {
        this.checkParameters(objectType, objectId);
        if (StringUtils.isBlank((CharSequence)fieldName)) {
            throw new IllegalArgumentException("Field name is mandatory");
        }
    }

    private void checkParameters(String objectType, long objectId) {
        if (StringUtils.isBlank((CharSequence)objectType)) {
            throw new IllegalArgumentException("Object type is mandatory");
        }
        if (objectId <= 0L) {
            throw new IllegalArgumentException("Object identifier is mandatory");
        }
        this.checkObjectTypePlugin(objectType);
    }

    private void checkObjectTypePlugin(String objectType) {
        if (!this.translationPlugins.containsKey(objectType)) {
            throw new IllegalStateException("TranslationPlugin associated to " + objectType + " wasn't found");
        }
    }
}

