/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.binding.listener;

import java.util.List;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.GroupEventListener;
import org.exoplatform.social.core.binding.model.GroupSpaceBinding;
import org.exoplatform.social.core.binding.spi.GroupSpaceBindingService;

public class SpaceBindingGroupEventListener
extends GroupEventListener {
    private static final Log LOG = ExoLogger.getLogger(SpaceBindingGroupEventListener.class);
    private GroupSpaceBindingService groupSpaceBindingService;

    public void postDelete(Group group) throws Exception {
        if (!group.getId().startsWith("/spaces")) {
            RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
            try {
                this.groupSpaceBindingService = (GroupSpaceBindingService)CommonsUtils.getService(GroupSpaceBindingService.class);
                List<GroupSpaceBinding> groupSpaceBindings = this.groupSpaceBindingService.findGroupSpaceBindingsByGroup(group.getId());
                groupSpaceBindings.stream().forEach(groupSpaceBinding -> this.groupSpaceBindingService.prepareDeleteGroupSpaceBinding((GroupSpaceBinding)groupSpaceBinding));
            }
            catch (Exception e) {
                LOG.warn("Problem occurred when removing all bindings for removed group ({}): ", new Object[]{group.getGroupName(), e});
            }
            finally {
                RequestLifeCycle.end();
            }
        }
    }
}

