/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.compat;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.StreamSupport;
import org.infinispan.Cache;
import org.infinispan.CacheSet;
import org.infinispan.CacheStream;
import org.infinispan.commands.MetadataAwareCommand;
import org.infinispan.commands.read.EntrySetCommand;
import org.infinispan.commands.read.GetAllCommand;
import org.infinispan.commands.read.GetCacheEntryCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.read.KeySetCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.commons.util.CloseableIteratorMapper;
import org.infinispan.commons.util.CloseableSpliterator;
import org.infinispan.compat.TypeConverter;
import org.infinispan.container.InternalEntryFactory;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.versioning.VersionGenerator;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.interceptors.compat.TypeConverterStream;
import org.infinispan.metadata.Metadata;
import org.infinispan.stream.impl.interceptor.AbstractDelegatingEntryCacheSet;
import org.infinispan.stream.impl.interceptor.AbstractDelegatingKeyCacheSet;
import org.infinispan.stream.impl.local.EntryStreamSupplier;
import org.infinispan.stream.impl.local.KeyStreamSupplier;
import org.infinispan.stream.impl.local.LocalCacheStream;
import org.infinispan.stream.impl.spliterators.IteratorAsSpliterator;

@Deprecated
public abstract class BaseTypeConverterInterceptor<K, V>
extends CommandInterceptor {
    private InternalEntryFactory entryFactory;
    private VersionGenerator versionGenerator;
    private Cache<K, V> cache;

    @Inject
    protected void init(InternalEntryFactory entryFactory, VersionGenerator versionGenerator, Cache<K, V> cache) {
        this.entryFactory = entryFactory;
        this.versionGenerator = versionGenerator;
        this.cache = cache;
    }

    protected abstract TypeConverter<Object, Object, Object, Object> determineTypeConverter(Set<Flag> var1);

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        Object key = command.getKey();
        TypeConverter<Object, Object, Object, Object> converter = this.determineTypeConverter(command.getFlags());
        if (ctx.isOriginLocal()) {
            command.setKey(converter.boxKey(key));
            command.setValue(converter.boxValue(command.getValue()));
        }
        Object ret = this.invokeNextInterceptor(ctx, command);
        return converter.unboxValue(ret);
    }

    @Override
    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        if (ctx.isOriginLocal()) {
            Map<Object, Object> map = command.getMap();
            TypeConverter<Object, Object, Object, Object> converter = this.determineTypeConverter(command.getFlags());
            HashMap<Object, Object> convertedMap = new HashMap<Object, Object>(map.size());
            for (Map.Entry<Object, Object> entry : map.entrySet()) {
                convertedMap.put(converter.boxKey(entry.getKey()), converter.boxValue(entry.getValue()));
            }
            command.setMap(convertedMap);
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    public Object visitGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) throws Throwable {
        Object ret;
        Object key = command.getKey();
        TypeConverter<Object, Object, Object, Object> converter = this.determineTypeConverter(command.getFlags());
        if (ctx.isOriginLocal()) {
            command.setKey(converter.boxKey(key));
        }
        if ((ret = this.invokeNextInterceptor(ctx, command)) != null) {
            if (this.needsUnboxing(ctx)) {
                return converter.unboxValue(ret);
            }
            return ret;
        }
        return null;
    }

    @Override
    public Object visitGetCacheEntryCommand(InvocationContext ctx, GetCacheEntryCommand command) throws Throwable {
        Object ret;
        Object key = command.getKey();
        TypeConverter<Object, Object, Object, Object> converter = this.determineTypeConverter(command.getFlags());
        if (ctx.isOriginLocal()) {
            command.setKey(converter.boxKey(key));
        }
        if ((ret = this.invokeNextInterceptor(ctx, command)) != null) {
            CacheEntry entry = (CacheEntry)ret;
            Object returnValue = entry.getValue();
            if (this.needsUnboxing(ctx)) {
                returnValue = converter.unboxValue(entry.getValue());
            }
            return this.entryFactory.create(entry.getKey(), returnValue, entry.getMetadata(), entry.getLifespan(), entry.getMaxIdle());
        }
        return null;
    }

    private boolean needsUnboxing(InvocationContext ctx) {
        return ctx.isOriginLocal();
    }

    @Override
    public Object visitGetAllCommand(InvocationContext ctx, GetAllCommand command) throws Throwable {
        Object ret;
        Collection<?> keys = command.getKeys();
        TypeConverter<Object, Object, Object, Object> converter = this.determineTypeConverter(command.getFlags());
        if (ctx.isOriginLocal()) {
            LinkedHashSet<Object> boxedKeys = new LinkedHashSet<Object>(keys.size());
            for (Object key : keys) {
                boxedKeys.add(converter.boxKey(key));
            }
            command.setKeys(boxedKeys);
        }
        if ((ret = this.invokeNextInterceptor(ctx, command)) != null && !this.needsUnboxing(ctx)) {
            return ret;
        }
        if (ret != null) {
            Map<Object, Object> unboxed;
            Map map;
            if (command.isReturnEntries()) {
                map = (Map)ret;
                unboxed = command.createMap();
                for (Map.Entry entry : map.entrySet()) {
                    CacheEntry cacheEntry = (CacheEntry)entry.getValue();
                    if (cacheEntry == null) {
                        unboxed.put(entry.getKey(), null);
                        continue;
                    }
                    if (command.getRemotelyFetched() == null || !command.getRemotelyFetched().containsKey(entry.getKey())) {
                        unboxed.put(converter.unboxKey(entry.getKey()), this.entryFactory.create(entry.getKey(), converter.unboxValue(cacheEntry.getValue()), cacheEntry.getMetadata(), cacheEntry.getLifespan(), cacheEntry.getMaxIdle()));
                        continue;
                    }
                    unboxed.put(converter.unboxKey(entry.getKey()), cacheEntry);
                }
                return unboxed;
            }
            map = (Map)ret;
            unboxed = command.createMap();
            for (Map.Entry entry : map.entrySet()) {
                Object value = entry == null ? null : (Object)entry.getValue();
                unboxed.put(converter.unboxKey(entry.getKey()), entry == null ? null : converter.unboxValue(value));
            }
            return unboxed;
        }
        return null;
    }

    @Override
    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        Object key = command.getKey();
        TypeConverter<Object, Object, Object, Object> converter = this.determineTypeConverter(command.getFlags());
        Object oldValue = command.getOldValue();
        if (ctx.isOriginLocal()) {
            command.setKey(converter.boxKey(key));
            command.setOldValue(converter.boxValue(oldValue));
            command.setNewValue(converter.boxValue(command.getNewValue()));
        }
        this.addVersionIfNeeded(command);
        Object ret = this.invokeNextInterceptor(ctx, command);
        if (oldValue != null && ret instanceof Boolean) {
            return ret;
        }
        return converter.unboxValue(ret);
    }

    private void addVersionIfNeeded(MetadataAwareCommand cmd) {
        Metadata metadata = cmd.getMetadata();
        if (metadata.version() == null) {
            Metadata newMetadata = metadata.builder().version(this.versionGenerator.generateNew()).build();
            cmd.setMetadata(newMetadata);
        }
    }

    @Override
    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        Object key = command.getKey();
        TypeConverter<Object, Object, Object, Object> converter = this.determineTypeConverter(command.getFlags());
        Object conditionalValue = command.getValue();
        if (ctx.isOriginLocal()) {
            command.setKey(converter.boxKey(key));
            command.setValue(converter.boxValue(conditionalValue));
        }
        Object ret = this.invokeNextInterceptor(ctx, command);
        if (conditionalValue != null && ret instanceof Boolean) {
            return ret;
        }
        return ctx.isOriginLocal() ? converter.unboxValue(ret) : ret;
    }

    @Override
    public CacheSet<K> visitKeySetCommand(InvocationContext ctx, KeySetCommand command) throws Throwable {
        if (ctx.isOriginLocal()) {
            final TypeConverter<Object, Object, Object, Object> converter = this.determineTypeConverter(command.getFlags());
            CacheSet set = (CacheSet)super.visitKeySetCommand(ctx, command);
            return new AbstractDelegatingKeyCacheSet<K, V>(this.getCacheWithFlags(this.cache, command), set){

                @Override
                public CloseableIterator<K> iterator() {
                    return new CloseableIteratorMapper(super.iterator(), k -> converter.unboxKey(k));
                }

                @Override
                public CloseableSpliterator<K> spliterator() {
                    return new IteratorAsSpliterator.Builder(this.iterator()).setEstimateRemaining(super.spliterator().estimateSize()).setCharacteristics(4353).get();
                }

                @Override
                protected CacheStream<K> getStream(boolean parallel) {
                    DistributionManager dm = BaseTypeConverterInterceptor.this.cache.getAdvancedCache().getDistributionManager();
                    CloseableSpliterator closeableSpliterator = super.spliterator();
                    LocalCacheStream stream = new LocalCacheStream(new KeyStreamSupplier(BaseTypeConverterInterceptor.this.cache, dm != null ? dm.getConsistentHash() : null, () -> StreamSupport.stream(closeableSpliterator, parallel)), parallel, BaseTypeConverterInterceptor.this.cache.getAdvancedCache().getComponentRegistry());
                    stream.onClose(() -> closeableSpliterator.close());
                    return new TypeConverterStream(stream, converter, BaseTypeConverterInterceptor.this.entryFactory);
                }
            };
        }
        return (CacheSet)this.invokeNextInterceptor(ctx, command);
    }

    @Override
    public CacheSet<CacheEntry<K, V>> visitEntrySetCommand(InvocationContext ctx, EntrySetCommand command) throws Throwable {
        if (ctx.isOriginLocal()) {
            final TypeConverter<Object, Object, Object, Object> converter = this.determineTypeConverter(command.getFlags());
            CacheSet set = (CacheSet)super.visitEntrySetCommand(ctx, command);
            return new AbstractDelegatingEntryCacheSet<K, V>(this.getCacheWithFlags(this.cache, command), set){

                @Override
                public CloseableIterator<CacheEntry<K, V>> iterator() {
                    return new TypeConverterIterator(super.iterator(), converter, BaseTypeConverterInterceptor.this.entryFactory);
                }

                @Override
                public CloseableSpliterator<CacheEntry<K, V>> spliterator() {
                    return new IteratorAsSpliterator.Builder(this.iterator()).setEstimateRemaining(super.spliterator().estimateSize()).setCharacteristics(4353).get();
                }

                @Override
                protected CacheStream<CacheEntry<K, V>> getStream(boolean parallel) {
                    DistributionManager dm = BaseTypeConverterInterceptor.this.cache.getAdvancedCache().getDistributionManager();
                    CloseableSpliterator closeableSpliterator = super.spliterator();
                    LocalCacheStream stream = new LocalCacheStream(new EntryStreamSupplier(BaseTypeConverterInterceptor.this.cache, dm != null ? dm.getConsistentHash() : null, () -> StreamSupport.stream(closeableSpliterator, parallel)), parallel, BaseTypeConverterInterceptor.this.cache.getAdvancedCache().getComponentRegistry());
                    stream.onClose(() -> closeableSpliterator.close());
                    return new TypeConverterStream(stream, converter, BaseTypeConverterInterceptor.this.entryFactory);
                }
            };
        }
        return (CacheSet)this.invokeNextInterceptor(ctx, command);
    }

    private static <K, V> CacheEntry<K, V> convert(CacheEntry<K, V> entry, TypeConverter<Object, Object, Object, Object> converter, InternalEntryFactory entryFactory) {
        Object newKey = converter.unboxKey(entry.getKey());
        Object newValue = converter.unboxValue(entry.getValue());
        if (newKey != entry.getKey() || newValue != entry.getValue()) {
            return entryFactory.create(newKey, newValue, entry.getMetadata());
        }
        return entry;
    }

    private static class TypeConverterIterator<K, V>
    implements CloseableIterator<CacheEntry<K, V>> {
        private final CloseableIterator<CacheEntry<K, V>> iterator;
        private final TypeConverter<Object, Object, Object, Object> converter;
        private final InternalEntryFactory entryFactory;

        private TypeConverterIterator(CloseableIterator<CacheEntry<K, V>> iterator, TypeConverter<Object, Object, Object, Object> converter, InternalEntryFactory entryFactory) {
            this.iterator = iterator;
            this.converter = converter;
            this.entryFactory = entryFactory;
        }

        public void close() {
            this.iterator.close();
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public CacheEntry<K, V> next() {
            CacheEntry entry = (CacheEntry)this.iterator.next();
            return BaseTypeConverterInterceptor.convert(entry, this.converter, this.entryFactory);
        }

        public void remove() {
            this.iterator.remove();
        }
    }
}

