/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.core;

import java.util.Calendar;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.version.VersionException;
import org.exoplatform.commons.utils.MimeTypeResolver;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.BaseComponentPlugin;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.wcm.core.WebSchemaHandler;
import org.exoplatform.services.wcm.portal.LivePortalManagerService;

public abstract class BaseWebSchemaHandler
extends BaseComponentPlugin
implements WebSchemaHandler {
    protected final String EXO_OWNABLE = "exo:owneable";
    protected final String NT_FOLDER = "nt:folder";
    protected final String NT_UNSTRUCTURED = "nt:unstructured";
    protected final String NT_FILE = "nt:file";

    @Override
    public boolean matchHandler(SessionProvider sessionProvider, Node node) throws Exception {
        String handlerNodeType = this.getHandlerNodeType();
        String parentNodeType = this.getParentNodeType();
        if (!node.getPrimaryNodeType().getName().equals(handlerNodeType)) {
            return false;
        }
        return node.getParent().isNodeType(parentNodeType);
    }

    @Override
    public void onCreateNode(SessionProvider sessionProvider, Node node) throws Exception {
    }

    @Override
    public void onModifyNode(SessionProvider sessionProvider, Node node) throws Exception {
    }

    @Override
    public void onRemoveNode(SessionProvider sessionProvider, Node node) throws Exception {
    }

    protected abstract String getHandlerNodeType();

    protected abstract String getParentNodeType();

    protected void addMixin(Node node, String mixin) throws NoSuchNodeTypeException, VersionException, ConstraintViolationException, LockException, RepositoryException {
        if (!node.isNodeType(mixin)) {
            node.addMixin(mixin);
        }
    }

    protected <T> T getService(Class<T> clazz) {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        return clazz.cast(container.getComponentInstanceOfType(clazz));
    }

    protected Node findPortalNode(SessionProvider sessionProvider, Node child) throws Exception {
        LivePortalManagerService livePortalManagerService = this.getService(LivePortalManagerService.class);
        String portalName = null;
        for (String portalPath : livePortalManagerService.getLivePortalsPath()) {
            if (!child.getPath().startsWith(portalPath)) continue;
            portalName = livePortalManagerService.getPortalNameByPath(portalPath);
            break;
        }
        if (portalName == null) {
            return null;
        }
        return livePortalManagerService.getLivePortal(sessionProvider, portalName);
    }

    protected String getFileMimeType(Node file) throws Exception {
        String mimeType = null;
        try {
            mimeType = file.getNode("jcr:content").getProperty("jcr:mimeType").getString();
        }
        catch (Exception e) {
            MimeTypeResolver resolver = new MimeTypeResolver();
            resolver.setDefaultMimeType("text/plain");
            mimeType = resolver.getMimeType(file.getName());
        }
        return mimeType;
    }

    protected void createDefautWebData(Node webContent) throws Exception {
        Node defaultCSS = this.addNodeAsNTFile(webContent.getNode("css"), "default.css", "text/css", "");
        this.addMixin(defaultCSS, "exo:cssFile");
        this.addMixin(defaultCSS, "exo:owneable");
        Node defaultJS = this.addNodeAsNTFile(webContent.getNode("js"), "default.js", "application/x-javascript", "");
        this.addMixin(defaultJS, "exo:jsFile");
        this.addMixin(defaultJS, "exo:owneable");
        if (!webContent.hasNode("default.html")) {
            Node defaultHTML = this.addNodeAsNTFile(webContent, "default.html", "text/html", "");
            this.addMixin(defaultHTML, "exo:htmlFile");
            this.addMixin(defaultHTML, "exo:owneable");
        }
        Node illustration = this.addNodeAsNTFile(webContent.getNode("medias/images"), "illustration", "", "");
        this.addMixin(illustration, "exo:owneable");
    }

    private Node addNodeAsNTFile(Node home, String fileName, String mimeType, String data) throws Exception {
        Node file = home.addNode(fileName, "nt:file");
        Node jcrContent = file.addNode("jcr:content", "nt:resource");
        jcrContent.addMixin("dc:elementSet");
        jcrContent.setProperty("jcr:encoding", "UTF-8");
        jcrContent.setProperty("jcr:lastModified", Calendar.getInstance());
        jcrContent.setProperty("jcr:mimeType", mimeType);
        jcrContent.setProperty("jcr:data", data);
        return file;
    }
}

