/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.fastcontentcreator.config.action;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.ListAccessImpl;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.services.cms.actions.ActionServiceContainer;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.wcm.webui.fastcontentcreator.UIFCCPortlet;
import org.exoplatform.wcm.webui.fastcontentcreator.UIFCCUtils;
import org.exoplatform.wcm.webui.fastcontentcreator.config.UIFCCConfig;
import org.exoplatform.wcm.webui.fastcontentcreator.config.action.UIFCCActionContainer;
import org.exoplatform.wcm.webui.fastcontentcreator.config.action.UIFCCActionTypeForm;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIGrid;
import org.exoplatform.webui.core.UIPageIterator;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.Lifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(lifecycle=Lifecycle.class, template="system:/groovy/FastContentCreatorPortlet/UIFCCActionList.gtmpl", events={@EventConfig(listeners={AddActionListener.class}), @EventConfig(listeners={EditActionListener.class}), @EventConfig(listeners={DeleteActionListener.class}, confirm="UIFCCActionList.msg.confirm-delete-action")})
public class UIFCCActionList
extends UIContainer {
    private static final String[] HEADERS = new String[]{"name", "description", "instanceOf"};
    private String[] ACTIONS = new String[]{"Edit", "Delete"};
    private String mode = null;

    public void init(String mode) throws Exception {
        this.mode = mode;
        UIGrid grid = (UIGrid)this.addChild(UIGrid.class, null, null);
        if ("basic".equals(mode)) {
            this.ACTIONS = new String[]{"Edit"};
        }
        grid.configure("UIFCCActionGrid", HEADERS, this.ACTIONS);
    }

    public void updateGrid(Node node, int currentPage) throws Exception {
        UIPageIterator uiIterator = ((UIGrid)this.getChild(UIGrid.class)).getUIPageIterator();
        ListAccessImpl actionNodeList = new ListAccessImpl(Object.class, NodeLocation.getLocationsByNodeList(this.getAllActions(node)));
        LazyPageList dataPageList = new LazyPageList((ListAccess)actionNodeList, 10);
        uiIterator.setPageList((PageList)dataPageList);
        if (currentPage > uiIterator.getAvailablePage()) {
            uiIterator.setCurrentPage(uiIterator.getAvailablePage());
        } else {
            uiIterator.setCurrentPage(currentPage);
        }
    }

    public String[] getActions() {
        return this.ACTIONS;
    }

    public boolean hasActions() {
        UIFCCConfig fastContentCreatorConfig = (UIFCCConfig)this.getAncestorOfType(UIFCCConfig.class);
        ActionServiceContainer actionService = (ActionServiceContainer)this.getApplicationComponent(ActionServiceContainer.class);
        try {
            return actionService.hasActions(fastContentCreatorConfig.getSavedLocationNode());
        }
        catch (Exception e) {
            return false;
        }
    }

    public List<Node> getAllActions(Node node) {
        ActionServiceContainer actionService = (ActionServiceContainer)this.getApplicationComponent(ActionServiceContainer.class);
        try {
            return actionService.getActions(node);
        }
        catch (Exception e) {
            return new ArrayList<Node>();
        }
    }

    public List getListActions() throws Exception {
        UIPageIterator uiIterator = ((UIGrid)this.getChild(UIGrid.class)).getUIPageIterator();
        return NodeLocation.getNodeListByLocationList((List)uiIterator.getCurrentPageData());
    }

    public String getMode() {
        return this.mode;
    }

    public static class DeleteActionListener
    extends EventListener<UIFCCActionList> {
        public void execute(Event<UIFCCActionList> event) throws Exception {
            UIFCCActionList fastContentCreatorActionList = (UIFCCActionList)((Object)event.getSource());
            UIFCCConfig fastContentCreatorConfig = (UIFCCConfig)fastContentCreatorActionList.getAncestorOfType(UIFCCConfig.class);
            ActionServiceContainer actionService = (ActionServiceContainer)fastContentCreatorActionList.getApplicationComponent(ActionServiceContainer.class);
            String actionName = event.getRequestContext().getRequestParameter("objectId");
            UIPopupContainer popupContainer = (UIPopupContainer)((UIFCCPortlet)fastContentCreatorActionList.getAncestorOfType(UIFCCPortlet.class)).getChild(UIPopupContainer.class);
            UIPopupWindow uiPopup = (UIPopupWindow)popupContainer.getChildById("UIFCCActionPopupWindow");
            UIApplication uiApp = (UIApplication)fastContentCreatorActionList.getAncestorOfType(UIApplication.class);
            if (uiPopup != null && uiPopup.isShow()) {
                uiPopup.setShowMask(true);
                uiApp.addMessage(new ApplicationMessage("UIActionList.msg.remove-popup-first", null, 1));
                return;
            }
            if (uiPopup != null && uiPopup.isRendered()) {
                popupContainer.removeChildById("UIFCCActionPopupWindow");
            }
            try {
                actionService.removeAction(fastContentCreatorConfig.getSavedLocationNode(), actionName, UIFCCUtils.getPreferenceRepository());
            }
            catch (AccessDeniedException ace) {
                uiApp.addMessage(new ApplicationMessage("UIActionList.msg.access-denied", null, 1));
                return;
            }
            fastContentCreatorActionList.updateGrid(fastContentCreatorConfig.getSavedLocationNode(), ((UIGrid)fastContentCreatorActionList.getChild(UIGrid.class)).getUIPageIterator().getCurrentPage());
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)fastContentCreatorConfig);
        }
    }

    public static class EditActionListener
    extends EventListener<UIFCCActionList> {
        public void execute(Event<UIFCCActionList> event) throws Exception {
            UIFCCActionList fastContentCreatorActionList = (UIFCCActionList)((Object)event.getSource());
            String actionName = event.getRequestContext().getRequestParameter("objectId");
            UIFCCActionContainer fccActionContainer = (UIFCCActionContainer)fastContentCreatorActionList.createUIComponent(UIFCCActionContainer.class, null, null);
            Utils.createPopupWindow((UIContainer)fastContentCreatorActionList, (UIComponent)fccActionContainer, (String)"UIFCCActionPopupWindow", (int)550);
            UIFCCActionTypeForm fccActionTypeForm = (UIFCCActionTypeForm)fccActionContainer.getChild(UIFCCActionTypeForm.class);
            ActionServiceContainer actionService = (ActionServiceContainer)fastContentCreatorActionList.getApplicationComponent(ActionServiceContainer.class);
            UIFCCConfig fastContentCreatorConfig = (UIFCCConfig)fastContentCreatorActionList.getAncestorOfType(UIFCCConfig.class);
            Node parentNode = fastContentCreatorConfig.getSavedLocationNode();
            Node actionNode = actionService.getAction(parentNode, actionName);
            fccActionTypeForm.init(actionNode.getPath(), actionNode.getPrimaryNodeType().getName());
            fccActionTypeForm.update();
        }
    }

    public static class AddActionListener
    extends EventListener<UIFCCActionList> {
        public void execute(Event<UIFCCActionList> event) throws Exception {
            UIFCCActionList fastContentCreatorActionList = (UIFCCActionList)((Object)event.getSource());
            UIFCCActionContainer fastContentCreatorActionContainer = (UIFCCActionContainer)fastContentCreatorActionList.createUIComponent(UIFCCActionContainer.class, null, null);
            Utils.createPopupWindow((UIContainer)fastContentCreatorActionList, (UIComponent)fastContentCreatorActionContainer, (String)"UIFCCActionPopupWindow", (int)550);
            ((UIFCCActionTypeForm)fastContentCreatorActionContainer.getChild(UIFCCActionTypeForm.class)).update();
        }
    }
}

