/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.rest;

import io.meeds.gamification.model.EventDTO;
import io.meeds.gamification.model.filter.EventFilter;
import io.meeds.gamification.rest.model.EntityList;
import io.meeds.gamification.service.EventService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.exoplatform.services.rest.resource.ResourceContainer;

@Path(value="/gamification/events")
public class EventRest
implements ResourceContainer {
    private final EventService eventService;

    public EventRest(EventService eventService) {
        this.eventService = eventService;
    }

    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Retrieves the list of gamification events", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled")})
    public Response getEvents(@Parameter(description="Used to filter events by Connector type") @QueryParam(value="type") String type, @Parameter(description="Used to filter events by trigger") @QueryParam(value="trigger") List<String> triggers, @Parameter(description="Offset of results to retrieve") @QueryParam(value="offset") @DefaultValue(value="0") int offset, @Parameter(description="Limit of results to retrieve") @QueryParam(value="limit") @DefaultValue(value="0") int limit, @Parameter(description="Returning the total count of filtered events or not.") @QueryParam(value="returnSize") @DefaultValue(value="false") boolean returnSize) {
        EventFilter eventFilter = new EventFilter();
        eventFilter.setType(type);
        eventFilter.setTriggers(triggers);
        List<EventDTO> eventDTOList = this.eventService.getEvents(eventFilter, offset, limit);
        EntityList<EventDTO> eventDTOEntityList = new EntityList<EventDTO>();
        eventDTOEntityList.setEntities(eventDTOList);
        eventDTOEntityList.setOffset(offset);
        eventDTOEntityList.setLimit(limit);
        if (returnSize) {
            eventDTOEntityList.setSize(this.eventService.countEvents(eventFilter));
        }
        return Response.ok(eventDTOEntityList).build();
    }
}

