/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.sidebar.action;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.UIWorkingArea;
import org.exoplatform.ecm.webui.component.explorer.sidebar.UISideBar;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.exception.MessageException;
import org.exoplatform.webui.ext.UIExtensionEventListener;

public abstract class UISideBarActionListener<T extends UIComponent>
extends UIExtensionEventListener<T> {
    private static final Log LOG = ExoLogger.getLogger((String)UISideBarActionListener.class.getName());

    protected Map<String, Object> createContext(Event<T> event) throws Exception {
        HashMap<String, Object> context;
        block6: {
            context = new HashMap<String, Object>();
            UISideBar uiSideBar = (UISideBar)((UIComponent)event.getSource()).getAncestorOfType(UISideBar.class);
            UIJCRExplorer uiExplorer = (UIJCRExplorer)((UIComponent)event.getSource()).getAncestorOfType(UIJCRExplorer.class);
            String nodePath = event.getRequestContext().getRequestParameter("objectId");
            try {
                Node currentNode;
                if (nodePath != null && nodePath.length() != 0 && !nodePath.contains(";")) {
                    Matcher matcher = UIWorkingArea.FILE_EXPLORER_URL_SYNTAX.matcher(nodePath);
                    String wsName = null;
                    if (!matcher.find()) {
                        throw new IllegalArgumentException("The ObjectId is invalid '" + nodePath + "'");
                    }
                    wsName = matcher.group(1);
                    nodePath = matcher.group(2);
                    Session session = uiExplorer.getSessionByWorkspace(wsName);
                    currentNode = uiExplorer.getNodeByPath(nodePath, session);
                } else {
                    currentNode = uiExplorer.getCurrentNode();
                }
                WebuiRequestContext requestContext = event.getRequestContext();
                UIApplication uiApp = requestContext.getUIApplication();
                context.put(UISideBar.class.getName(), (Object)uiSideBar);
                context.put(UIJCRExplorer.class.getName(), (Object)uiExplorer);
                context.put(UIApplication.class.getName(), uiApp);
                context.put(Node.class.getName(), currentNode);
                context.put(WebuiRequestContext.class.getName(), requestContext);
            }
            catch (PathNotFoundException pne) {
                throw new MessageException(new ApplicationMessage("UIPopupMenu.msg.path-not-found", null, 1));
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block6;
                LOG.error((Object)"Unexpected problem occurs", (Throwable)e);
            }
        }
        return context;
    }

    protected String getExtensionType() {
        return "org.exoplatform.ecm.dms.UISideBar";
    }
}

