/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.clouddrives.webui.document;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.exoplatform.services.cms.clouddrives.CloudDrive;
import org.exoplatform.services.cms.clouddrives.CloudDriveException;
import org.exoplatform.services.cms.clouddrives.CloudDriveSecurity;
import org.exoplatform.services.cms.clouddrives.CloudDriveService;
import org.exoplatform.services.cms.clouddrives.CloudDriveStorage;
import org.exoplatform.services.cms.clouddrives.DriveRemovedException;
import org.exoplatform.services.cms.clouddrives.NotCloudDriveException;
import org.exoplatform.services.cms.clouddrives.webui.action.CloudFileActionService;
import org.exoplatform.services.cms.link.LinkManager;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.wcm.ext.component.document.service.ShareDocumentService;

public class CloudDriveShareDocumentService
extends ShareDocumentService {
    protected static final Log LOG = ExoLogger.getLogger(CloudDriveShareDocumentService.class);
    protected static final String SHARE_PERMISSION_MODIFY = "modify";
    protected final ActivityManager activityManager;
    protected final LinkManager linkManager;
    protected final IdentityManager identityManager;
    protected final CloudDriveService cloudDrives;
    protected final NodeHierarchyCreator hierarchyCreator;
    protected final CloudFileActionService cloudFileActions;
    protected final String groupsPath;
    protected final String usersPath;

    public CloudDriveShareDocumentService(RepositoryService repoService, LinkManager linkManager, SessionProviderService sessionProviderService, ActivityManager activityManager, NodeHierarchyCreator hierarchyCreator, IdentityManager identityManager, CloudDriveService cloudDrives, CloudFileActionService cloudFileActions, SpaceService spaceService) {
        super(repoService, linkManager, identityManager, activityManager, spaceService, sessionProviderService);
        this.activityManager = activityManager;
        this.linkManager = linkManager;
        this.hierarchyCreator = hierarchyCreator;
        this.identityManager = identityManager;
        this.cloudDrives = cloudDrives;
        this.cloudFileActions = cloudFileActions;
        this.groupsPath = hierarchyCreator.getJcrPath("groupsPath");
        this.usersPath = hierarchyCreator.getJcrPath("usersPath");
    }

    public String publishDocumentToSpace(final String groupId, final Node node, final String comment, final String perm) {
        final CloudDrive localDrive = this.findCloudDrive(node);
        if (localDrive != null) {
            return this.applyInDrive(localDrive, new CloudDriveStorage.Change<String>(){

                public String apply() throws RepositoryException {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Sharing Cloud File " + node.getPath() + " of " + localDrive + " to  " + groupId + " " + perm));
                    }
                    String activityId = CloudDriveShareDocumentService.super.publishDocumentToSpace(groupId, node, comment, perm);
                    CloudDriveShareDocumentService.this.cloudFileActions.shareToGroup(node, groupId, CloudDriveShareDocumentService.SHARE_PERMISSION_MODIFY.equalsIgnoreCase(perm));
                    ExoSocialActivity activity = CloudDriveShareDocumentService.this.activityManager.getActivity(activityId);
                    if (activity != null && !"sharecloudfiles:spaces".equals(activity.getType())) {
                        activity.setType("sharecloudfiles:spaces");
                        CloudDriveShareDocumentService.this.activityManager.updateActivity(activity);
                        CloudDriveShareDocumentService.this.activityManager.saveActivityNoReturn(CloudDriveShareDocumentService.this.identityManager.getOrCreateIdentity("space", activity.getActivityStream().getPrettyId(), true), activity);
                    }
                    CloudDriveShareDocumentService.this.shareInDrive(node, localDrive, groupId);
                    return activityId;
                }
            });
        }
        return super.publishDocumentToSpace(groupId, node, comment, perm);
    }

    public void publishDocumentToUser(final String userId, final Node node, final String comment, final String perm) {
        final CloudDrive localDrive = this.findCloudDrive(node);
        if (localDrive != null) {
            this.applyInDrive(localDrive, new CloudDriveStorage.Change<Void>(){

                public Void apply() throws RepositoryException {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Sharing Cloud File " + node.getPath() + " of " + localDrive + " to " + userId + " " + perm));
                    }
                    CloudDriveShareDocumentService.super.publishDocumentToUser(userId, node, comment, perm);
                    CloudDriveShareDocumentService.this.cloudFileActions.shareToUser(node, userId, CloudDriveShareDocumentService.SHARE_PERMISSION_MODIFY.equalsIgnoreCase(perm));
                    CloudDriveShareDocumentService.this.shareInDrive(node, localDrive, userId);
                    return null;
                }
            });
            return;
        }
        super.publishDocumentToUser(userId, node, comment, perm);
    }

    public void unpublishDocumentToUser(final String userId, final ExtendedNode node) {
        final CloudDrive localDrive = this.findCloudDrive((Node)node);
        if (localDrive != null) {
            this.applyInDrive(localDrive, new CloudDriveStorage.Change<Void>(){

                public Void apply() throws RepositoryException, CloudDriveException {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Unsharing Cloud File " + node.getPath() + " of " + localDrive));
                    }
                    CloudDriveShareDocumentService.super.unpublishDocumentToUser(userId, node);
                    node.refresh(false);
                    CloudDriveShareDocumentService.this.cloudFileActions.unshareToUser((Node)node, userId);
                    CloudDriveShareDocumentService.this.unshareInDrive((Node)node, localDrive, userId);
                    return null;
                }
            });
            return;
        }
        super.unpublishDocumentToUser(userId, node);
    }

    public void unpublishDocumentToSpace(final String groupId, final ExtendedNode node) {
        final CloudDrive localDrive = this.findCloudDrive((Node)node);
        if (localDrive != null) {
            this.applyInDrive(localDrive, new CloudDriveStorage.Change<Void>(){

                public Void apply() throws RepositoryException {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Unsharing Cloud File " + node.getPath() + " of " + localDrive));
                    }
                    CloudDriveShareDocumentService.super.unpublishDocumentToSpace(groupId, node);
                    node.refresh(false);
                    CloudDriveShareDocumentService.this.cloudFileActions.unshareToSpace((Node)node, groupId);
                    CloudDriveShareDocumentService.this.unshareInDrive((Node)node, localDrive, groupId);
                    return null;
                }
            });
            return;
        }
        super.unpublishDocumentToSpace(groupId, node);
    }

    protected CloudDrive findCloudDrive(Node node) {
        try {
            if (node.isNodeType("ecd:cloudFile")) {
                CloudDrive localDrive = this.cloudDrives.findDrive(node);
                if (localDrive != null) {
                    return localDrive;
                }
                LOG.warn((Object)("Cloud File node not be found in any of registered drives: " + node.getPath()));
            }
        }
        catch (RepositoryException e) {
            LOG.warn((Object)("Error reading node of shared document " + node), (Throwable)e);
        }
        return null;
    }

    protected <R> R applyInDrive(CloudDrive cloudDrive, CloudDriveStorage.Change<R> change) {
        try {
            CloudDriveStorage cdStorage = (CloudDriveStorage)cloudDrive;
            return (R)cdStorage.localChange(change);
        }
        catch (RepositoryException e) {
            LOG.error((Object)("Error applying cloud drive changes in " + cloudDrive), (Throwable)e);
        }
        catch (NotCloudDriveException e) {
            LOG.warn((Object)("Cannot apply changes to not connected cloud drive: " + cloudDrive), (Throwable)e);
        }
        catch (DriveRemovedException e) {
            LOG.warn((Object)("Cannot apply changes to removed cloud drive: " + cloudDrive), (Throwable)e);
        }
        catch (CloudDriveException e) {
            LOG.error((Object)("Error applying cloud drive changes: " + cloudDrive), (Throwable)e);
        }
        return null;
    }

    protected void shareInDrive(Node node, CloudDrive localDrive, String identity) {
        CloudDriveSecurity srcSecurity = (CloudDriveSecurity)localDrive;
        if (srcSecurity.isSharingSupported()) {
            try {
                srcSecurity.shareFile(node, new String[]{identity});
            }
            catch (RepositoryException e) {
                LOG.error((Object)("Error sharing cloud file: " + node), (Throwable)e);
            }
            catch (CloudDriveException e) {
                LOG.error((Object)("Error sharing cloud file: " + node), (Throwable)e);
            }
        }
    }

    protected void unshareInDrive(Node node, CloudDrive localDrive, String identity) {
        CloudDriveSecurity srcSecurity = (CloudDriveSecurity)localDrive;
        if (srcSecurity.isSharingSupported()) {
            try {
                srcSecurity.unshareFile(node, new String[]{identity});
            }
            catch (RepositoryException e) {
                LOG.error((Object)("Error unsharing cloud file: " + node), (Throwable)e);
            }
            catch (CloudDriveException e) {
                LOG.error((Object)("Error unsharing cloud file: " + node), (Throwable)e);
            }
        }
    }
}

