/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.permission.info;

import org.exoplatform.ecm.webui.form.UIFormInputSetWithAction;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.input.UICheckBoxInput;

@ComponentConfig(template="classpath:groovy/ecm/webui/form/UIPermissionInputSet.gtmpl")
public class UIPermissionInputSet
extends UIFormInputSetWithAction {
    public static final String FIELD_USERORGROUP = "userOrGroup";
    private String[] buttonActions_ = new String[]{"Save", "Reset"};
    private String primaryBtn_ = "Save";

    public UIPermissionInputSet(String name) throws Exception {
        super(name);
        this.initComponent(true);
    }

    private void initComponent(boolean hasPermissionCheckbox) throws Exception {
        this.setComponentConfig(((Object)((Object)this)).getClass(), null);
        UIFormStringInput userGroup = new UIFormStringInput(FIELD_USERORGROUP, FIELD_USERORGROUP, null);
        userGroup.setReadOnly(true);
        this.addUIFormInput((UIFormInput)userGroup);
        if (hasPermissionCheckbox) {
            for (String perm : new String[]{"read", "add_node", "remove"}) {
                UICheckBoxInput checkBoxInput = new UICheckBoxInput(perm, perm, Boolean.valueOf(false));
                this.addUIFormInput((UIFormInput)checkBoxInput);
                checkBoxInput.setOnChange("OnChange");
            }
        }
        this.setActionInfo(FIELD_USERORGROUP, new String[]{"SelectUser", "SelectMember", "AddAny"});
    }

    public UIPermissionInputSet(String name, boolean hasPermissionCheckbox) throws Exception {
        super(name);
        this.initComponent(hasPermissionCheckbox);
    }

    public String[] getButtonActions() {
        return this.buttonActions_;
    }

    public void setButtonActions(String[] actions) {
        this.buttonActions_ = actions;
    }

    public String getPrimaryButtonAction() {
        return this.primaryBtn_;
    }

    public void setPrimaryButtonAction(String primaryBtn) {
        this.primaryBtn_ = primaryBtn;
    }

    public static class OnChangeActionListener
    extends EventListener<UIForm> {
        public void execute(Event<UIForm> event) throws Exception {
            UIForm permissionForm = (UIForm)event.getSource();
            UICheckBoxInput readCheckBox = permissionForm.getUICheckBoxInput("read");
            boolean isAddNodeCheckBoxChecked = permissionForm.getUICheckBoxInput("add_node").isChecked();
            boolean isRemoveCheckBoxChecked = permissionForm.getUICheckBoxInput("remove").isChecked();
            if (isAddNodeCheckBoxChecked || isRemoveCheckBoxChecked) {
                readCheckBox.setChecked(true);
            }
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)permissionForm);
        }
    }
}

