/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.identification;

import java.util.Collection;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.CollapsedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.sis.internal.jaxb.FilterByVersion;
import org.apache.sis.internal.jaxb.gco.GO_GenericName;
import org.apache.sis.internal.jaxb.metadata.SV_OperationMetadata;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.apache.sis.metadata.iso.identification.DefaultOperationMetadata;
import org.apache.sis.metadata.iso.identification.OperationName;
import org.apache.sis.util.iso.Names;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.identification.DataIdentification;
import org.opengis.util.ScopedName;

@XmlType(name="SV_CoupledResource_Type", namespace="http://standards.iso.org/iso/19115/-3/srv/2.0", propOrder={"scopedName", "resourceReference", "resource", "operation", "operationName", "id", "legacyName"})
@XmlRootElement(name="SV_CoupledResource", namespace="http://standards.iso.org/iso/19115/-3/srv/2.0")
@UML(identifier="SV_CoupledResource", specification=Specification.ISO_19115)
public class DefaultCoupledResource
extends ISOMetadata {
    private static final long serialVersionUID = 154704781596732747L;
    private ScopedName scopedName;
    private Collection<Citation> resourceReferences;
    private Collection<DataIdentification> resources;
    private DefaultOperationMetadata operation;

    public DefaultCoupledResource() {
    }

    public DefaultCoupledResource(ScopedName scopedName, Citation citation, DataIdentification dataIdentification, DefaultOperationMetadata defaultOperationMetadata) {
        this.scopedName = scopedName;
        this.resourceReferences = this.singleton(citation, Citation.class);
        this.resources = this.singleton(dataIdentification, DataIdentification.class);
        this.operation = defaultOperationMetadata;
    }

    public DefaultCoupledResource(DefaultCoupledResource defaultCoupledResource) {
        super(defaultCoupledResource);
        if (defaultCoupledResource != null) {
            this.scopedName = defaultCoupledResource.getScopedName();
            this.resourceReferences = this.copyCollection(defaultCoupledResource.getResourceReferences(), Citation.class);
            this.resources = this.copyCollection(defaultCoupledResource.getResources(), DataIdentification.class);
            this.operation = defaultCoupledResource.getOperation();
        }
    }

    @XmlElement(name="scopedName")
    @XmlJavaTypeAdapter(value=GO_GenericName.Since2014.class)
    @UML(identifier="scopedName", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public ScopedName getScopedName() {
        return this.scopedName;
    }

    public void setScopedName(ScopedName scopedName) {
        this.checkWritePermission(this.scopedName);
        this.scopedName = scopedName;
    }

    @UML(identifier="resourceReference", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<Citation> getResourceReferences() {
        this.resourceReferences = this.nonNullCollection(this.resourceReferences, Citation.class);
        return this.resourceReferences;
    }

    public void setResourceReferences(Collection<? extends Citation> collection) {
        this.resourceReferences = this.writeCollection(collection, this.resourceReferences, Citation.class);
    }

    @UML(identifier="resource", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<DataIdentification> getResources() {
        this.resources = this.nonNullCollection(this.resources, DataIdentification.class);
        return this.resources;
    }

    public void setResources(Collection<? extends DataIdentification> collection) {
        this.resources = this.writeCollection(collection, this.resources, DataIdentification.class);
    }

    @XmlElement(name="operation")
    @XmlJavaTypeAdapter(value=SV_OperationMetadata.Since2014.class)
    @UML(identifier="operation", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public DefaultOperationMetadata getOperation() {
        return this.operation;
    }

    public void setOperation(DefaultOperationMetadata defaultOperationMetadata) {
        this.checkWritePermission(this.operation);
        this.operation = defaultOperationMetadata;
    }

    @XmlElement(name="operationName", namespace="http://www.isotc211.org/2005/srv")
    private String getOperationName() {
        DefaultOperationMetadata defaultOperationMetadata;
        if (FilterByVersion.LEGACY_METADATA.accept() && (defaultOperationMetadata = this.getOperation()) != null) {
            return defaultOperationMetadata.getOperationName();
        }
        return null;
    }

    private void setOperationName(String string) {
        if (this.operation == null) {
            this.operation = new OperationName(string);
        }
    }

    @XmlElement(name="identifier", namespace="http://www.isotc211.org/2005/srv")
    private String getId() {
        ScopedName scopedName;
        if (FilterByVersion.LEGACY_METADATA.accept() && (scopedName = this.getScopedName()) != null) {
            return scopedName.tip().toString();
        }
        return null;
    }

    @XmlElement(name="ScopedName", namespace="http://standards.iso.org/iso/19115/-3/gco/1.0")
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    private String getLegacyName() {
        ScopedName scopedName;
        if (FilterByVersion.LEGACY_METADATA.accept() && (scopedName = this.getScopedName()) != null) {
            return scopedName.toString();
        }
        return null;
    }

    private void setLegacyName(String string) {
        if (string != null && !string.isEmpty()) {
            if (string.indexOf(58) < 0) {
                string = "global:" + string;
            }
            this.setScopedName((ScopedName)Names.parseGenericName(null, null, string));
        }
    }

    @XmlElement(name="resourceReference")
    private Collection<Citation> getResourceReference() {
        return FilterByVersion.CURRENT_METADATA.accept() ? this.getResourceReferences() : null;
    }

    @XmlElement(name="resource")
    private Collection<DataIdentification> getResource() {
        return FilterByVersion.CURRENT_METADATA.accept() ? this.getResources() : null;
    }
}

