/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.portletcache;

import java.io.Serializable;
import java.util.Locale;
import java.util.Map;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;
import org.exoplatform.services.portletcache.Util;

class WindowKey
implements Serializable {
    private static final long serialVersionUID = 924996837199587159L;
    private final String windowId;
    private final String windowState;
    private final String portletMode;
    private final Locale locale;
    private final Map<String, String[]> parameters;
    private final Map<String, String[]> query;
    private final int hashCode;

    WindowKey(String windowId, WindowState windowState, PortletMode portletMode, Locale locale, Map<String, String[]> parameters, Map<String, String[]> query) {
        parameters = Util.clone(parameters);
        query = Util.clone(query);
        int hashCode = windowId.hashCode() ^ windowState.hashCode() ^ portletMode.hashCode() ^ locale.hashCode() ^ Util.hashCode(parameters) ^ Util.hashCode(query);
        this.windowId = windowId;
        this.windowState = windowState.toString();
        this.portletMode = portletMode.toString();
        this.parameters = parameters;
        this.locale = locale;
        this.hashCode = hashCode;
        this.query = query;
    }

    public String getWindowId() {
        return this.windowId;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof WindowKey) {
            WindowKey that = (WindowKey)obj;
            return this.windowId.equals(that.windowId) && this.windowState.equals(that.windowState) && this.portletMode.equals(that.portletMode) && this.locale.equals(that.locale) && Util.equals(this.parameters, that.parameters) && Util.equals(this.query, that.query);
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("WindowKey[");
        sb.append("windowId").append('=').append(this.windowId).append(',');
        sb.append("windowState").append('=').append(this.windowState).append(',');
        sb.append("portletMode").append('=').append(this.portletMode).append(',');
        sb.append("locale").append('=').append(this.locale).append(',');
        sb.append("parameters").append('=');
        Util.toString(this.parameters, sb);
        sb.append(',');
        sb.append("query").append('=');
        Util.toString(this.query, sb);
        sb.append(']');
        return sb.toString();
    }
}

