/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.security.security;

import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class AutoReseedRandom
extends SecureRandom
implements Runnable {
    private static final long serialVersionUID = 8754191896768407628L;
    public static final long DEFAULT_RESEEDING_PERIOD = 86400000L;
    public static final String DEFAULT_RANDOM_ALGORITHM = "SHA1PRNG";
    public static final String DEFAULT_RANDOM_ALGORITHM_PROVIDER = null;
    public static final int DEFAULT_SEED_LENGTH = 32;
    private static final String RESEEDING_THREAD_NAME = AutoReseedRandom.class.getSimpleName() + " reseeding";
    private volatile SecureRandom delegate;
    private volatile long nextReseed = 0L;
    private final long reseedingPeriod;
    private final Log log = ExoLogger.getLogger(AutoReseedRandom.class);
    private final String algorithm;
    private final String algorithmProvider;
    private final int seedLength;

    public AutoReseedRandom() {
        this(DEFAULT_RANDOM_ALGORITHM, DEFAULT_RANDOM_ALGORITHM_PROVIDER, 32, 86400000L);
    }

    public AutoReseedRandom(String algorithm, String algorithmProvider, int seedLength, long reseedingPeriod) {
        this.algorithm = algorithm;
        this.algorithmProvider = algorithmProvider;
        this.seedLength = seedLength;
        this.reseedingPeriod = reseedingPeriod;
        this.nextReseed = System.currentTimeMillis() + reseedingPeriod;
        this.resetRandom();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkReseed() {
        boolean reseed = false;
        AutoReseedRandom autoReseedRandom = this;
        synchronized (autoReseedRandom) {
            if (System.currentTimeMillis() > this.nextReseed) {
                this.nextReseed = System.currentTimeMillis() + this.reseedingPeriod;
                reseed = true;
            }
        }
        if (reseed) {
            new Thread((Runnable)this, RESEEDING_THREAD_NAME).start();
        }
    }

    private void resetRandom() {
        SecureRandom newRandom = null;
        try {
            newRandom = this.algorithmProvider == null ? SecureRandom.getInstance(this.algorithm) : SecureRandom.getInstance(this.algorithm, this.algorithmProvider);
            long before = this.log.isDebugEnabled() ? 0L : System.currentTimeMillis();
            newRandom.setSeed(newRandom.generateSeed(this.seedLength));
            if (this.log.isDebugEnabled()) {
                long now = System.currentTimeMillis();
                this.log.debug((Object)("secureRandom.setSeed took " + (double)(now - before) / 1000.0 + " seconds."));
            }
            this.delegate = newRandom;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchProviderException e) {
            this.log.info((Object)("Falling back to default random algorithm provider because '" + this.algorithmProvider + "' is not available."), (Throwable)e);
            try {
                newRandom = SecureRandom.getInstance(this.algorithm);
                newRandom.setSeed(newRandom.generateSeed(this.seedLength));
                this.delegate = newRandom;
            }
            catch (NoSuchAlgorithmException e1) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void run() {
        try {
            this.resetRandom();
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public String getAlgorithm() {
        return this.delegate.getAlgorithm();
    }

    @Override
    public synchronized void setSeed(byte[] seed) {
        this.delegate.setSeed(seed);
    }

    @Override
    public void setSeed(long seed) {
        if (this.delegate != null) {
            this.delegate.setSeed(seed);
        }
    }

    @Override
    public synchronized void nextBytes(byte[] bytes) {
        this.delegate.nextBytes(bytes);
        this.checkReseed();
    }

    @Override
    public byte[] generateSeed(int numBytes) {
        return this.delegate.generateSeed(numBytes);
    }

    @Override
    public int nextInt() {
        int result = this.delegate.nextInt();
        this.checkReseed();
        return result;
    }

    @Override
    public int nextInt(int n) {
        int result = this.delegate.nextInt(n);
        this.checkReseed();
        return result;
    }

    @Override
    public long nextLong() {
        long result = this.delegate.nextLong();
        this.checkReseed();
        return result;
    }

    @Override
    public boolean nextBoolean() {
        boolean result = this.delegate.nextBoolean();
        this.checkReseed();
        return result;
    }

    @Override
    public float nextFloat() {
        float result = this.delegate.nextFloat();
        this.checkReseed();
        return result;
    }

    @Override
    public double nextDouble() {
        double result = this.delegate.nextDouble();
        this.checkReseed();
        return result;
    }

    @Override
    public synchronized double nextGaussian() {
        double result = this.delegate.nextGaussian();
        this.checkReseed();
        return result;
    }
}

