/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.permlink.plugin;

import io.meeds.portal.permlink.model.PermanentLinkObject;
import io.meeds.portal.permlink.plugin.PermanentLinkPlugin;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;

public class UserProfilePermanentLinkPlugin
implements PermanentLinkPlugin {
    public static final String OBJECT_TYPE = "user";
    public static final String URL_FORMAT = "/portal/%s/profile/%s";
    private IdentityManager identityManager;
    private UserPortalConfigService portalConfigService;

    public UserProfilePermanentLinkPlugin(IdentityManager identityManager, UserPortalConfigService portalConfigService) {
        this.identityManager = identityManager;
        this.portalConfigService = portalConfigService;
    }

    public String getObjectType() {
        return OBJECT_TYPE;
    }

    public boolean canAccess(PermanentLinkObject object, org.exoplatform.services.security.Identity identity) throws ObjectNotFoundException {
        return identity != null && identity.getUserId() != null;
    }

    public String getDirectAccessUrl(PermanentLinkObject object) throws ObjectNotFoundException {
        String userId = object.getObjectId();
        if (StringUtils.isNumeric((CharSequence)userId)) {
            Identity identity = this.identityManager.getIdentity(userId);
            if (identity == null) {
                throw new ObjectNotFoundException(String.format("User profile with id %s doesn't exists", userId));
            }
            if (!identity.isUser()) {
                throw new ObjectNotFoundException(String.format("Identity with id %s isn't of type user", userId));
            }
            userId = identity.getRemoteId();
        }
        return String.format(URL_FORMAT, this.portalConfigService.getMetaPortal(), userId);
    }
}

