/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.rest.impl.favorite;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.common.ObjectAlreadyExistsException;
import org.exoplatform.social.metadata.favorite.FavoriteService;
import org.exoplatform.social.metadata.favorite.model.Favorite;
import org.exoplatform.social.rest.api.RestUtils;
import org.exoplatform.social.rest.impl.favorite.FavoriteEntity;

@Path(value="v1/social/favorites")
@Tag(name="v1/social/favorites", description="Managing favorites for any type of data")
public class FavoriteRest
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(FavoriteRest.class);
    private FavoriteService favoriteService;

    public FavoriteRest(FavoriteService favoriteService) {
        this.favoriteService = favoriteService;
    }

    @POST
    @Path(value="{objectType}/{objectId}")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Creates a favorite object", description="Creates a favorite object", method="POST")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="409", description="Conflict")})
    public Response createFavorite(@Parameter(description="Object type: activity, comment, notes ...", required=true) @PathParam(value="objectType") String objectType, @Parameter(description="Object identifier: technical id to identify object as favorite", required=true) @PathParam(value="objectId") String objectId, @Parameter(description="Object parent identifier: technical id to identify the parent of an object like the activity Id for a comment entity", required=false) @QueryParam(value="parentObjectId") String parentObjectId, @Parameter(description="Space technical identitifier of the bookmarked object", required=false) @QueryParam(value="spaceId") long spaceId, @Parameter(description="Whether ignore favorite when already exists or return a HTTP 409 code", required=false) @Schema(defaultValue="false") @QueryParam(value="ignoreWhenExisting") boolean ignoreWhenExisting) {
        if (StringUtils.isBlank((CharSequence)objectType)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"FavoriteObjectTypeRequired").build();
        }
        if (StringUtils.isBlank((CharSequence)objectId)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"FavoriteObjectIdRequired").build();
        }
        Identity authenticatedUserIdentity = ConversationState.getCurrent().getIdentity();
        if (!this.favoriteService.canCreateFavorite(authenticatedUserIdentity, objectType, objectId)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        long userIdentityId = RestUtils.getCurrentUserIdentityId();
        try {
            Favorite favorite = new Favorite(objectType, objectId, parentObjectId, userIdentityId, spaceId);
            this.favoriteService.createFavorite(favorite);
            return Response.noContent().build();
        }
        catch (ObjectAlreadyExistsException e) {
            if (ignoreWhenExisting) {
                return Response.noContent().build();
            }
            return Response.status((Response.Status)Response.Status.CONFLICT).build();
        }
        catch (Exception e) {
            LOG.warn((Object)"Error creating a favorite", (Throwable)e);
            return Response.serverError().build();
        }
    }

    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Retrieves all favorites object of the current user", description="Retrieves all favorites object of the current user", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getFavoritesList(@Parameter(description="Query Offset", required=true) @QueryParam(value="offset") int offset, @Parameter(description="Query results limit", required=true) @QueryParam(value="limit") int limit, @Parameter(description="Fovorites total size") @Schema(defaultValue="false") @QueryParam(value="returnSize") boolean returnSize) {
        long userIdentityId = RestUtils.getCurrentUserIdentityId();
        try {
            FavoriteEntity favoriteEntity = new FavoriteEntity();
            List myFavorites = this.favoriteService.getFavoriteItemsByCreator(userIdentityId, (long)offset, (long)limit);
            favoriteEntity.setFavoritesItem(myFavorites);
            favoriteEntity.setLimit(limit);
            favoriteEntity.setOffset(offset);
            if (returnSize) {
                favoriteEntity.setSize(this.favoriteService.getFavoriteItemsSize(userIdentityId));
            }
            return Response.ok((Object)favoriteEntity).build();
        }
        catch (Exception e) {
            LOG.error((Object)"Unknown error occurred while getting favorites list", (Throwable)e);
            return Response.serverError().build();
        }
    }

    @DELETE
    @Path(value="{objectType}/{objectId}")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Deletes a metadata item identified by its id", description="Deletes a metadata item identified by its id", method="DELETE")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="404", description="Not found"), @ApiResponse(responseCode="401", description="Unauthorized")})
    public Response deleteFavorite(@Parameter(description="Object type: activity, comment, notes ...", required=true) @PathParam(value="objectType") String objectType, @Parameter(description="Object identifier: technical id to identify object as favorite", required=true) @PathParam(value="objectId") String objectId, @Parameter(description="Whether ignore when not existing Metadata item or not.If true, it will return a HTTP code 204 when not existing else a 404.", required=false) @Schema(defaultValue="false") @QueryParam(value="ignoreNotExisting") boolean ignoreNotExisting) {
        if (StringUtils.isBlank((CharSequence)objectType)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"FavoriteObjectTypeRequired").build();
        }
        if (StringUtils.isBlank((CharSequence)objectId)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"FavoriteObjectIdRequired").build();
        }
        long userIdentityId = RestUtils.getCurrentUserIdentityId();
        try {
            Favorite favorite = new Favorite(objectType, objectId, null, userIdentityId, 0L);
            this.favoriteService.deleteFavorite(favorite);
            return Response.noContent().build();
        }
        catch (ObjectNotFoundException e) {
            if (ignoreNotExisting) {
                return Response.noContent().build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception e) {
            LOG.warn((Object)"Error deleting a favorite", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }
}

