/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.types;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.hsqldb.error.Error;

public class NumberFormat {
    final String pattern;
    int patternSigDigitCount;
    int patternFracCount;
    boolean hasPeriod;
    boolean blankMode;
    boolean fillMode;
    boolean signStart;
    boolean signEnd;
    boolean signEndMinus;
    boolean signBrackets;

    public NumberFormat(String string) {
        this.pattern = string;
        int n = string.length();
        block10: for (int i = 0; i < n; ++i) {
            switch (string.charAt(i)) {
                case 'B': {
                    if (i == 0) {
                        this.blankMode = true;
                        continue block10;
                    }
                    throw Error.error(3475);
                }
                case 'F': {
                    if (i == 0 && n > 1 && string.charAt(1) == 'M') {
                        this.fillMode = true;
                        ++i;
                        continue block10;
                    }
                    throw Error.error(3475);
                }
                case 'M': {
                    if (!this.signStart && i == n - 2 && string.charAt(i + 1) == 'I') {
                        this.signEnd = true;
                        this.signEndMinus = true;
                        ++i;
                        continue block10;
                    }
                    throw Error.error(3475);
                }
                case 'P': {
                    if (!this.signStart && i == n - 2 && string.charAt(i + 1) == 'R') {
                        this.signBrackets = true;
                        ++i;
                        continue block10;
                    }
                    throw Error.error(3475);
                }
                case '.': {
                    if (this.hasPeriod) {
                        throw Error.error(3475);
                    }
                    this.hasPeriod = true;
                    continue block10;
                }
                case ',': {
                    if (!this.hasPeriod) continue block10;
                    throw Error.error(3475);
                }
                case 'S': {
                    if (i == 0) {
                        this.signStart = true;
                        continue block10;
                    }
                    if (!this.signStart && i == n - 1) {
                        this.signEnd = true;
                        continue block10;
                    }
                    throw Error.error(3475);
                }
                case '0': 
                case '9': {
                    if (this.hasPeriod) {
                        ++this.patternFracCount;
                        continue block10;
                    }
                    ++this.patternSigDigitCount;
                }
            }
        }
    }

    public String format(Number number) {
        int n;
        BigDecimal bigDecimal = number instanceof BigDecimal ? (BigDecimal)number : (number instanceof Double ? BigDecimal.valueOf(number.doubleValue()) : BigDecimal.valueOf(number.longValue()));
        boolean bl = bigDecimal.signum() < 0;
        bigDecimal = bigDecimal.setScale(this.patternFracCount, RoundingMode.HALF_EVEN);
        String string = (bigDecimal = bigDecimal.abs()).toPlainString();
        int n2 = string.length() - this.patternFracCount - (this.patternFracCount == 0 ? 0 : 1);
        if (this.patternSigDigitCount < n2) {
            return "#";
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (this.blankMode && bigDecimal.signum() == 0) {
            int n3 = this.patternSigDigitCount + this.patternFracCount + (this.patternFracCount == 0 ? 0 : 1);
            for (int i = 0; i < n3; ++i) {
                stringBuilder.append(' ');
            }
            return stringBuilder.toString();
        }
        int n4 = 0;
        int n5 = this.patternSigDigitCount - n2;
        boolean bl2 = false;
        boolean bl3 = false;
        block7: for (n = 0; n < this.pattern.length(); ++n) {
            switch (this.pattern.charAt(n)) {
                case '9': {
                    int n6;
                    if (n4 < n5) {
                        if (!this.fillMode) {
                            if (bl2) {
                                stringBuilder.append('0');
                            } else {
                                stringBuilder.append(' ');
                            }
                        }
                    } else if (n4 == n5) {
                        if (bl && !bl3) {
                            this.appendSignStart(stringBuilder, bl);
                            bl3 = true;
                        }
                        n6 = string.charAt(n4 - n5);
                        if (this.hasPeriod && n6 == 48) {
                            n6 = 32;
                        }
                        stringBuilder.append((char)n6);
                    } else {
                        n6 = string.charAt(n4 - n5);
                        stringBuilder.append((char)n6);
                    }
                    ++n4;
                    continue block7;
                }
                case '0': {
                    int n6;
                    if (bl && !bl3) {
                        this.appendSignStart(stringBuilder, bl);
                        bl3 = true;
                    }
                    if (n4 < n5) {
                        bl2 = true;
                        stringBuilder.append('0');
                    } else {
                        n6 = string.charAt(n4 - n5);
                        stringBuilder.append((char)n6);
                    }
                    ++n4;
                    continue block7;
                }
                case '.': {
                    stringBuilder.append('.');
                    ++n4;
                    continue block7;
                }
                case ',': {
                    if (n4 <= n5) continue block7;
                    stringBuilder.append(',');
                }
            }
        }
        if (this.fillMode && this.hasPeriod) {
            for (n = stringBuilder.length() - 1; n >= 0 && stringBuilder.charAt(n) == '0'; --n) {
                stringBuilder.setLength(n);
            }
        }
        this.appendSignEnd(stringBuilder, bl);
        return stringBuilder.toString();
    }

    void appendSignStart(StringBuilder stringBuilder, boolean bl) {
        if (this.signBrackets) {
            if (bl) {
                stringBuilder.append('<');
            } else {
                stringBuilder.append(' ');
            }
        } else if (this.signStart) {
            if (bl) {
                stringBuilder.append('-');
            } else {
                stringBuilder.append('+');
            }
        } else if (!this.signEnd) {
            if (bl) {
                stringBuilder.append('-');
            } else if (!this.fillMode) {
                stringBuilder.append(' ');
            }
        }
    }

    void appendSignEnd(StringBuilder stringBuilder, boolean bl) {
        if (this.signEnd) {
            if (bl) {
                stringBuilder.append('-');
            } else if (this.signEndMinus) {
                stringBuilder.append(' ');
            } else {
                stringBuilder.append('+');
            }
        } else if (this.signBrackets) {
            if (bl) {
                stringBuilder.append('>');
            } else {
                stringBuilder.append(' ');
            }
        }
    }
}

