/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.tenant.metamask.listener;

import io.meeds.wallet.model.Wallet;
import io.meeds.wallet.model.WalletProvider;
import io.meeds.wallet.service.WalletAccountService;
import jakarta.annotation.PostConstruct;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserEventListener;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.web3j.crypto.WalletUtils;

@Component
public class NewMetamaskCreatedUserListener
extends UserEventListener {
    private static final Log LOG = ExoLogger.getLogger(NewMetamaskCreatedUserListener.class);
    @Autowired
    private OrganizationService organizationService;
    @Autowired
    private WalletAccountService walletAccountService;
    @Autowired
    private IdentityManager identityManager;

    @PostConstruct
    public void init() {
        if (this.organizationService.getUserHandler() != null) {
            this.organizationService.getUserHandler().addUserEventListener((UserEventListener)this);
        }
    }

    public void postSave(User user, boolean isNew) throws Exception {
        String address = user.getUserName();
        if (isNew && user.isEnabled() && WalletUtils.isValidAddress((String)address)) {
            try {
                this.createUserWalletByAddress(address);
            }
            catch (Exception e) {
                LOG.warn("Error while associating Metamask wallet for user {}", new Object[]{address, e});
            }
        }
    }

    public Wallet createUserWalletByAddress(String address) {
        if (!WalletUtils.isValidAddress((String)address)) {
            return null;
        }
        Wallet wallet = this.walletAccountService.getWalletByAddress(address);
        if (wallet != null) {
            LOG.warn("Wallet with address {} is already associated to identity id {}.The used Metamask address will not be associated to current user account.", new Object[]{address, wallet.getTechnicalId()});
            return null;
        }
        Identity identity = this.identityManager.getOrCreateUserIdentity(address);
        Wallet userWallet = this.walletAccountService.createWalletInstance(WalletProvider.METAMASK, address, Long.valueOf(identity.getId()).longValue());
        return this.walletAccountService.saveWallet(userWallet, true);
    }
}

