/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.ext.management.invocation;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import org.exoplatform.services.rest.ext.management.invocation.MethodInvoker;

public abstract class SimpleMethodInvoker
implements MethodInvoker {
    private final Method method;

    public SimpleMethodInvoker(Method method) {
        if (method == null) {
            throw new IllegalArgumentException("The method cannot be null");
        }
        this.method = method;
    }

    @Override
    public Object invoke(Object o, Map<String, List<String>> argMap) throws IllegalAccessException, InvocationTargetException {
        Class<?>[] paramTypes = this.method.getParameterTypes();
        Object[] args = new Object[paramTypes.length];
        for (int i = 0; i < paramTypes.length; ++i) {
            String argName = this.getArgumentName(i);
            List<String> argValues = argMap.get(argName);
            Class<?> paramType = paramTypes[i];
            if (paramType.isPrimitive()) {
                throw new UnsupportedOperationException("Todo " + String.valueOf(paramType));
            }
            if (paramType.isArray()) {
                throw new UnsupportedOperationException("Todo " + String.valueOf(paramType));
            }
            if (paramType != String.class) {
                throw new UnsupportedOperationException("Todo " + String.valueOf(paramType));
            }
            String arg = argValues != null && argValues.size() > 0 ? argValues.get(0) : null;
            args[i] = arg;
        }
        return this.method.invoke(o, args);
    }

    protected abstract String getArgumentName(int var1);
}

