/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.appcenter.dao;

import io.meeds.appcenter.entity.ApplicationEntity;
import io.meeds.appcenter.entity.FavoriteApplicationEntity;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Component;

@Component
public interface ApplicationDAO
extends JpaRepository<ApplicationEntity, Long> {
    public List<ApplicationEntity> findBySystemIsTrueAndUrl(String var1);

    @Query(value="SELECT app.id FROM ApplicationEntity app\n")
    public List<Long> getApplicationIds(Sort var1);

    default public List<Long> getApplicationIds() {
        return this.getApplicationIds(Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.asc((String)"title").ignoreCase()}));
    }

    @Query(value="SELECT app.id FROM ApplicationEntity app\nWHERE LOWER(app.title) LIKE %?1%\nOR LOWER(app.description) like %?1%\nOR LOWER(app.url) LIKE %?1%\nORDER BY LOWER(app.title)\n")
    public List<Long> getApplicationIds(String var1, Sort var2);

    default public List<Long> getApplicationIds(String keyword) {
        return this.getApplicationIds(keyword, Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.asc((String)"title").ignoreCase()}));
    }

    @Query(value="SELECT app.id FROM ApplicationEntity app\nWHERE app.system = TRUE\n")
    public List<Long> getSystemApplicationIds();

    @Query(value="SELECT new FavoriteApplicationEntity(favoriteApp.id, app, favoriteApp.userName, favoriteApp.order, favoriteApp.favorite)\nFROM ApplicationEntity app\nLEFT JOIN FavoriteApplicationEntity favoriteApp\nON app.id = favoriteApp.application.id AND favoriteApp.userName = :userName\nWHERE app.active = TRUE\nAND (\n  app.isMandatory = TRUE\n  OR (favoriteApp.id IS NOT NULL AND favoriteApp.favorite = TRUE)\n  OR (favoriteApp.id IS NULL AND app.isDefault = TRUE)\n)\nORDER BY favoriteApp.order NULLS LAST, app.order NULLS LAST, app.isMandatory DESC\n")
    public Page<FavoriteApplicationEntity> findFavoriteAndMandatoryApplications(@Param(value="userName") String var1, Pageable var2);
}

