/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.lang.reflect.Type;
import java.sql.Array;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Struct;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.dialect.StructAttributeValues;
import org.hibernate.dialect.StructHelper;
import org.hibernate.metamodel.mapping.BasicValuedMapping;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.mapping.EmbeddableValuedModelPart;
import org.hibernate.metamodel.mapping.ForeignKeyDescriptor;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.MappingType;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.mapping.ValuedModelPart;
import org.hibernate.metamodel.mapping.internal.DiscriminatedAssociationAttributeMapping;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.type.BasicPluralType;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.spi.UnknownBasicJavaType;
import org.hibernate.type.descriptor.jdbc.AggregateJdbcType;
import org.hibernate.type.descriptor.jdbc.BasicBinder;
import org.hibernate.type.descriptor.jdbc.BasicExtractor;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.spi.TypeConfiguration;

public class StructJdbcType
implements org.hibernate.type.descriptor.jdbc.StructJdbcType {
    public static final AggregateJdbcType INSTANCE = new StructJdbcType();
    private final String typeName;
    private final int[] orderMapping;
    private final int[] inverseOrderMapping;
    private final EmbeddableMappingType embeddableMappingType;
    private final ValueExtractor<Object[]> objectArrayExtractor;

    private StructJdbcType() {
        this(null, null, null);
    }

    public StructJdbcType(EmbeddableMappingType embeddableMappingType, String typeName, int[] orderMapping) {
        this.embeddableMappingType = embeddableMappingType;
        this.typeName = typeName;
        this.orderMapping = orderMapping;
        if (orderMapping == null) {
            this.inverseOrderMapping = null;
        } else {
            int[] inverseOrderMapping = new int[orderMapping.length];
            for (int i = 0; i < orderMapping.length; ++i) {
                inverseOrderMapping[orderMapping[i]] = i;
            }
            this.inverseOrderMapping = inverseOrderMapping;
        }
        this.objectArrayExtractor = this.createBasicExtractor(new UnknownBasicJavaType<Object[]>(Object[].class));
    }

    @Override
    public int getJdbcTypeCode() {
        return 2002;
    }

    @Override
    public String getStructTypeName() {
        return this.typeName;
    }

    @Override
    public AggregateJdbcType resolveAggregateJdbcType(EmbeddableMappingType mappingType, String sqlType, RuntimeModelCreationContext creationContext) {
        return new StructJdbcType(mappingType, sqlType, creationContext.getBootModel().getDatabase().getDefaultNamespace().locateUserDefinedType(Identifier.toIdentifier(sqlType)).getOrderMapping());
    }

    @Override
    public EmbeddableMappingType getEmbeddableMappingType() {
        return this.embeddableMappingType;
    }

    @Override
    public <T> JavaType<T> getJdbcRecommendedJavaTypeMapping(Integer precision, Integer scale, TypeConfiguration typeConfiguration) {
        if (this.embeddableMappingType == null) {
            return typeConfiguration.getJavaTypeRegistry().getDescriptor((Type)((Object)Object[].class));
        }
        return this.embeddableMappingType.getMappedJavaType();
    }

    @Override
    public void registerOutParameter(CallableStatement callableStatement, String name) throws SQLException {
        callableStatement.registerOutParameter(name, this.getJdbcTypeCode(), this.typeName);
    }

    @Override
    public void registerOutParameter(CallableStatement callableStatement, int index) throws SQLException {
        callableStatement.registerOutParameter(index, this.getJdbcTypeCode(), this.typeName);
    }

    @Override
    public Object createJdbcValue(Object domainValue, WrapperOptions options) throws SQLException {
        Object[] jdbcValues = StructHelper.getJdbcValues(this.embeddableMappingType, this.orderMapping, domainValue, options);
        return jdbcValues == null ? null : options.getSession().getJdbcCoordinator().getLogicalConnection().getPhysicalConnection().createStruct(this.typeName, jdbcValues);
    }

    @Override
    public Object[] extractJdbcValues(Object rawJdbcValue, WrapperOptions options) throws SQLException {
        Object[] jdbcValues = ((Struct)rawJdbcValue).getAttributes();
        if (this.orderMapping != null) {
            StructHelper.orderJdbcValues(this.embeddableMappingType, this.inverseOrderMapping, (Object[])jdbcValues.clone(), jdbcValues);
        }
        this.wrapRawJdbcValues(this.embeddableMappingType, jdbcValues, 0, options);
        return jdbcValues;
    }

    @Override
    public <X> ValueBinder<X> getBinder(JavaType<X> javaType) {
        return new BasicBinder<X>(javaType, this){

            @Override
            protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                st.setObject(index, StructJdbcType.this.createJdbcValue(value, options));
            }

            @Override
            protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                st.setObject(name, StructJdbcType.this.createJdbcValue(value, options));
            }
        };
    }

    @Override
    public <X> ValueExtractor<X> getExtractor(JavaType<X> javaType) {
        if (javaType.getJavaTypeClass() == Object[].class) {
            return this.objectArrayExtractor;
        }
        return this.createBasicExtractor(javaType);
    }

    private <X> BasicExtractor<X> createBasicExtractor(JavaType<X> javaType) {
        return new BasicExtractor<X>(javaType, this){

            @Override
            protected X doExtract(ResultSet rs, int paramIndex, WrapperOptions options) throws SQLException {
                return this.getValue(rs.getObject(paramIndex), options);
            }

            @Override
            protected X doExtract(CallableStatement statement, int index, WrapperOptions options) throws SQLException {
                return this.getValue(statement.getObject(index), options);
            }

            @Override
            protected X doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
                return this.getValue(statement.getObject(name), options);
            }

            private X getValue(Object object, WrapperOptions options) throws SQLException {
                boolean jdbcRepresentation;
                if (object == null) {
                    return null;
                }
                Struct struct = (Struct)object;
                Object[] jdbcValues = struct.getAttributes();
                boolean bl = jdbcRepresentation = this.getJavaType().getJavaTypeClass() == Object[].class;
                if (jdbcRepresentation) {
                    if (StructJdbcType.this.orderMapping != null) {
                        StructHelper.orderJdbcValues(StructJdbcType.this.embeddableMappingType, StructJdbcType.this.inverseOrderMapping, (Object[])jdbcValues.clone(), jdbcValues);
                    }
                    StructJdbcType.this.wrapRawJdbcValues(StructJdbcType.this.embeddableMappingType, jdbcValues, 0, options);
                    return jdbcValues;
                }
                assert (StructJdbcType.this.embeddableMappingType != null && StructJdbcType.this.embeddableMappingType.getJavaType() == this.getJavaType());
                StructAttributeValues attributeValues = StructJdbcType.this.getAttributeValues(StructJdbcType.this.embeddableMappingType, StructJdbcType.this.orderMapping, jdbcValues, options);
                return StructHelper.instantiate(StructJdbcType.this.embeddableMappingType, attributeValues, options.getSessionFactory());
            }
        };
    }

    private StructAttributeValues getAttributeValues(EmbeddableMappingType embeddableMappingType, int[] orderMapping, Object[] rawJdbcValues, WrapperOptions options) throws SQLException {
        int numberOfAttributeMappings = embeddableMappingType.getNumberOfAttributeMappings();
        int size = numberOfAttributeMappings + (embeddableMappingType.isPolymorphic() ? 1 : 0);
        StructAttributeValues attributeValues = new StructAttributeValues(numberOfAttributeMappings, orderMapping != null ? null : rawJdbcValues);
        int jdbcIndex = 0;
        for (int i = 0; i < size; ++i) {
            int attributeIndex = orderMapping == null ? i : orderMapping[i];
            jdbcIndex += this.injectAttributeValue(StructHelper.getEmbeddedPart(embeddableMappingType, attributeIndex), attributeValues, attributeIndex, rawJdbcValues, jdbcIndex, options);
        }
        return attributeValues;
    }

    private int injectAttributeValue(ValuedModelPart modelPart, StructAttributeValues attributeValues, int attributeIndex, Object[] rawJdbcValues, int jdbcIndex, WrapperOptions options) throws SQLException {
        int jdbcValueCount;
        MappingType mappedType = modelPart.getMappedType();
        Object rawJdbcValue = rawJdbcValues[jdbcIndex];
        if (mappedType instanceof EmbeddableMappingType) {
            EmbeddableMappingType embeddableMappingType = (EmbeddableMappingType)mappedType;
            if (embeddableMappingType.getAggregateMapping() != null) {
                jdbcValueCount = 1;
                if (rawJdbcValue == null) {
                    attributeValues.setAttributeValue(attributeIndex, null);
                } else {
                    AggregateJdbcType aggregateJdbcType = (AggregateJdbcType)embeddableMappingType.getAggregateMapping().getJdbcMapping().getJdbcType();
                    StructAttributeValues subValues = aggregateJdbcType instanceof StructJdbcType ? this.getAttributeValues(embeddableMappingType, ((StructJdbcType)aggregateJdbcType).orderMapping, ((Struct)rawJdbcValue).getAttributes(), options) : StructHelper.getAttributeValues(embeddableMappingType, aggregateJdbcType.extractJdbcValues(rawJdbcValue, options), options);
                    attributeValues.setAttributeValue(attributeIndex, StructHelper.instantiate(embeddableMappingType, subValues, options.getSessionFactory()));
                }
            } else {
                jdbcValueCount = embeddableMappingType.getJdbcValueCount();
                Object[] jdbcValues = new Object[jdbcValueCount];
                System.arraycopy(rawJdbcValues, jdbcIndex, jdbcValues, 0, jdbcValues.length);
                StructAttributeValues subValues = this.getAttributeValues(embeddableMappingType, null, jdbcValues, options);
                attributeValues.setAttributeValue(attributeIndex, StructHelper.instantiate(embeddableMappingType, subValues, options.getSessionFactory()));
            }
        } else {
            Object jdbcValue;
            assert (modelPart.getJdbcTypeCount() == 1);
            jdbcValueCount = 1;
            JdbcMapping jdbcMapping = modelPart.getSingleJdbcMapping();
            if (rawJdbcValue == null) {
                jdbcValue = null;
            } else {
                block0 : switch (jdbcMapping.getJdbcType().getDefaultSqlTypeCode()) {
                    case 2014: 
                    case 3003: {
                        jdbcValue = jdbcMapping.getJdbcJavaType().wrap(this.transformRawJdbcValue(rawJdbcValue, options), options);
                        break;
                    }
                    case 2003: {
                        BasicType elementType = ((BasicPluralType)jdbcMapping).getElementType();
                        JdbcType elementJdbcType = elementType.getJdbcType();
                        switch (elementJdbcType.getDefaultSqlTypeCode()) {
                            case 2013: 
                            case 2014: 
                            case 3003: 
                            case 3007: {
                                Object[] array = (Object[])((Array)rawJdbcValue).getArray();
                                Object[] newArray = new Object[array.length];
                                for (int j = 0; j < array.length; ++j) {
                                    newArray[j] = elementType.getJdbcJavaType().wrap(this.transformRawJdbcValue(array[j], options), options);
                                }
                                jdbcValue = jdbcMapping.getJdbcJavaType().wrap(newArray, options);
                                break block0;
                            }
                            case 2002: 
                            case 2009: 
                            case 3001: {
                                Object[] array = (Object[])((Array)rawJdbcValue).getArray();
                                Object[] newArray = new Object[array.length];
                                AggregateJdbcType aggregateJdbcType = (AggregateJdbcType)elementJdbcType;
                                EmbeddableMappingType subEmbeddableMappingType = aggregateJdbcType.getEmbeddableMappingType();
                                for (int j = 0; j < array.length; ++j) {
                                    StructAttributeValues subValues = StructHelper.getAttributeValues(subEmbeddableMappingType, aggregateJdbcType.extractJdbcValues(array[j], options), options);
                                    newArray[j] = StructHelper.instantiate(subEmbeddableMappingType, subValues, options.getSessionFactory());
                                }
                                jdbcValue = jdbcMapping.getJdbcJavaType().wrap(newArray, options);
                                break block0;
                            }
                        }
                        jdbcValue = jdbcMapping.getJdbcJavaType().wrap(rawJdbcValue, options);
                        break;
                    }
                    default: {
                        jdbcValue = jdbcMapping.getJdbcJavaType().wrap(rawJdbcValue, options);
                    }
                }
            }
            attributeValues.setAttributeValue(attributeIndex, jdbcMapping.convertToDomainValue(jdbcValue));
        }
        return jdbcValueCount;
    }

    private int wrapRawJdbcValues(EmbeddableMappingType embeddableMappingType, Object[] jdbcValues, int jdbcIndex, WrapperOptions options) throws SQLException {
        int numberOfAttributeMappings = embeddableMappingType.getNumberOfAttributeMappings();
        for (int i = 0; i < numberOfAttributeMappings + (embeddableMappingType.isPolymorphic() ? 1 : 0); ++i) {
            ValuedModelPart attributeMapping = StructHelper.getEmbeddedPart(embeddableMappingType, i);
            if (attributeMapping instanceof ToOneAttributeMapping) {
                ToOneAttributeMapping toOneAttributeMapping = (ToOneAttributeMapping)attributeMapping;
                if (toOneAttributeMapping.getSideNature() == ForeignKeyDescriptor.Nature.TARGET) continue;
                ForeignKeyDescriptor foreignKeyDescriptor = toOneAttributeMapping.getForeignKeyDescriptor();
                ValuedModelPart keyPart = foreignKeyDescriptor.getKeyPart();
                if (keyPart instanceof BasicValuedMapping) {
                    this.wrapRawJdbcValue(keyPart.getSingleJdbcMapping(), jdbcValues, jdbcIndex, options);
                    ++jdbcIndex;
                    continue;
                }
                if (keyPart instanceof EmbeddableValuedModelPart) {
                    EmbeddableMappingType mappingType = ((EmbeddableValuedModelPart)keyPart).getEmbeddableTypeDescriptor();
                    jdbcIndex = this.wrapRawJdbcValues(mappingType, jdbcValues, jdbcIndex, options);
                    continue;
                }
                throw new UnsupportedOperationException("Unsupported foreign key part: " + String.valueOf(keyPart));
            }
            if (attributeMapping instanceof PluralAttributeMapping) continue;
            if (attributeMapping instanceof DiscriminatedAssociationAttributeMapping) {
                DiscriminatedAssociationAttributeMapping discriminatedAssociationAttributeMapping = (DiscriminatedAssociationAttributeMapping)attributeMapping;
                this.wrapRawJdbcValue(discriminatedAssociationAttributeMapping.getDiscriminatorPart().getSingleJdbcMapping(), jdbcValues, jdbcIndex, options);
                this.wrapRawJdbcValue(discriminatedAssociationAttributeMapping.getKeyPart().getSingleJdbcMapping(), jdbcValues, ++jdbcIndex, options);
                ++jdbcIndex;
                continue;
            }
            if (attributeMapping instanceof EmbeddableValuedModelPart) {
                EmbeddableValuedModelPart embeddableValuedModelPart = (EmbeddableValuedModelPart)attributeMapping;
                EmbeddableMappingType embeddableType = embeddableValuedModelPart.getMappedType();
                if (embeddableType.getAggregateMapping() != null) {
                    AggregateJdbcType aggregateJdbcType = (AggregateJdbcType)embeddableType.getAggregateMapping().getJdbcMapping().getJdbcType();
                    Object rawJdbcValue = jdbcValues[jdbcIndex];
                    jdbcValues[jdbcIndex] = aggregateJdbcType.extractJdbcValues(rawJdbcValue, options);
                    ++jdbcIndex;
                    continue;
                }
                jdbcIndex = this.wrapRawJdbcValues(embeddableType, jdbcValues, jdbcIndex, options);
                continue;
            }
            assert (attributeMapping.getJdbcTypeCount() == 1);
            this.wrapRawJdbcValue(attributeMapping.getSingleJdbcMapping(), jdbcValues, jdbcIndex, options);
            ++jdbcIndex;
        }
        return jdbcIndex;
    }

    private void wrapRawJdbcValue(JdbcMapping jdbcMapping, Object[] jdbcValues, int jdbcIndex, WrapperOptions options) throws SQLException {
        Object rawJdbcValue = jdbcValues[jdbcIndex];
        if (rawJdbcValue == null) {
            return;
        }
        block0 : switch (jdbcMapping.getJdbcType().getDefaultSqlTypeCode()) {
            case 2013: 
            case 2014: 
            case 3003: 
            case 3007: {
                jdbcValues[jdbcIndex] = jdbcMapping.getJdbcJavaType().wrap(this.transformRawJdbcValue(rawJdbcValue, options), options);
                break;
            }
            case 2003: {
                BasicType elementType = ((BasicPluralType)jdbcMapping).getElementType();
                JdbcType elementJdbcType = elementType.getJdbcType();
                switch (elementJdbcType.getDefaultSqlTypeCode()) {
                    case 2013: 
                    case 2014: 
                    case 3003: 
                    case 3007: {
                        Object[] array = (Object[])((Array)rawJdbcValue).getArray();
                        Object[] newArray = new Object[array.length];
                        for (int j = 0; j < array.length; ++j) {
                            newArray[j] = elementType.getJdbcJavaType().wrap(this.transformRawJdbcValue(array[j], options), options);
                        }
                        jdbcValues[jdbcIndex] = jdbcMapping.getJdbcJavaType().wrap(newArray, options);
                        break block0;
                    }
                    case 2002: 
                    case 2009: 
                    case 3001: {
                        Object[] array = (Object[])((Array)rawJdbcValue).getArray();
                        Object[] newArray = new Object[array.length];
                        AggregateJdbcType aggregateJdbcType = (AggregateJdbcType)elementJdbcType;
                        EmbeddableMappingType subEmbeddableMappingType = aggregateJdbcType.getEmbeddableMappingType();
                        for (int j = 0; j < array.length; ++j) {
                            StructAttributeValues subValues = StructHelper.getAttributeValues(subEmbeddableMappingType, aggregateJdbcType.extractJdbcValues(array[j], options), options);
                            newArray[j] = StructHelper.instantiate(subEmbeddableMappingType, subValues, options.getSessionFactory());
                        }
                        jdbcValues[jdbcIndex] = jdbcMapping.getJdbcJavaType().wrap(newArray, options);
                        break block0;
                    }
                }
                jdbcValues[jdbcIndex] = jdbcMapping.getJdbcJavaType().wrap(rawJdbcValue, options);
                break;
            }
            default: {
                jdbcValues[jdbcIndex] = jdbcMapping.getJdbcJavaType().wrap(rawJdbcValue, options);
            }
        }
    }

    protected Object transformRawJdbcValue(Object rawJdbcValue, WrapperOptions options) {
        return rawJdbcValue;
    }
}

