/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function.array;

import java.util.Collections;
import java.util.List;
import org.hibernate.dialect.function.array.DdlTypeHelper;
import org.hibernate.dialect.function.array.JsonArrayViaElementArgumentReturnTypeResolver;
import org.hibernate.query.ReturnableType;
import org.hibernate.query.SemanticException;
import org.hibernate.query.sqm.function.AbstractSqmSelfRenderingFunctionDescriptor;
import org.hibernate.query.sqm.function.FunctionKind;
import org.hibernate.query.sqm.produce.function.StandardArgumentsValidators;
import org.hibernate.query.sqm.produce.function.StandardFunctionArgumentTypeResolvers;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.Distinct;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.ast.tree.select.SortSpecification;
import org.hibernate.type.BasicPluralType;

public class OracleArrayAggEmulation
extends AbstractSqmSelfRenderingFunctionDescriptor {
    public static final String FUNCTION_NAME = "array_agg";

    public OracleArrayAggEmulation() {
        super(FUNCTION_NAME, FunctionKind.ORDERED_SET_AGGREGATE, StandardArgumentsValidators.exactly(1), JsonArrayViaElementArgumentReturnTypeResolver.INSTANCE, StandardFunctionArgumentTypeResolvers.NULL);
    }

    @Override
    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> sqlAstArguments, ReturnableType<?> returnType, SqlAstTranslator<?> walker) {
        this.render(sqlAppender, sqlAstArguments, null, Collections.emptyList(), returnType, walker);
    }

    @Override
    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> sqlAstArguments, Predicate filter, ReturnableType<?> returnType, SqlAstTranslator<?> walker) {
        this.render(sqlAppender, sqlAstArguments, filter, Collections.emptyList(), returnType, walker);
    }

    @Override
    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> sqlAstArguments, Predicate filter, List<SortSpecification> withinGroup, ReturnableType<?> returnType, SqlAstTranslator<?> translator) {
        Expression arg;
        boolean returnJson;
        if (!(returnType instanceof BasicPluralType)) {
            throw new SemanticException("Oracle array_agg emulation requires a basic plural return type, but resolved return type was: " + String.valueOf(returnType));
        }
        BasicPluralType pluralType = (BasicPluralType)returnType;
        boolean bl = returnJson = pluralType.getJdbcType().getDefaultSqlTypeCode() == 3001;
        if (returnJson) {
            sqlAppender.append("json_arrayagg(");
        } else {
            String arrayTypeName = DdlTypeHelper.getTypeName(returnType, translator.getSessionFactory().getTypeConfiguration());
            sqlAppender.append(arrayTypeName);
            sqlAppender.append("_from_json(json_arrayagg(");
        }
        SqlAstNode firstArg = sqlAstArguments.get(0);
        if (firstArg instanceof Distinct) {
            sqlAppender.appendSql("distinct ");
            arg = ((Distinct)firstArg).getExpression();
        } else {
            arg = (Expression)firstArg;
        }
        arg.accept(translator);
        if (withinGroup != null && !withinGroup.isEmpty()) {
            translator.getCurrentClauseStack().push(Clause.WITHIN_GROUP);
            sqlAppender.appendSql(" order by ");
            withinGroup.get(0).accept(translator);
            for (int i = 1; i < withinGroup.size(); ++i) {
                sqlAppender.appendSql(',');
                withinGroup.get(i).accept(translator);
            }
            translator.getCurrentClauseStack().pop();
        }
        sqlAppender.appendSql(" null on null returning ");
        sqlAppender.appendSql(translator.getSessionFactory().getTypeConfiguration().getDdlTypeRegistry().getTypeName(3001, translator.getSessionFactory().getJdbcServices().getDialect()));
        sqlAppender.appendSql(')');
        if (filter != null) {
            translator.getCurrentClauseStack().push(Clause.WHERE);
            sqlAppender.appendSql(" filter (where ");
            filter.accept(translator);
            sqlAppender.appendSql(')');
            translator.getCurrentClauseStack().pop();
        }
        if (!returnJson) {
            sqlAppender.appendSql(')');
        }
    }
}

