/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.hibernate.query.internal.QueryParameterNamedImpl;
import org.hibernate.query.internal.QueryParameterPositionalImpl;
import org.hibernate.query.spi.QueryParameterImplementor;
import org.hibernate.query.sqm.SqmTreeTransformationLogger;
import org.hibernate.query.sqm.tree.SqmStatement;
import org.hibernate.query.sqm.tree.expression.JpaCriteriaParameter;
import org.hibernate.query.sqm.tree.expression.SqmJpaCriteriaParameterWrapper;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.type.BasicCollectionType;

public class DomainParameterXref {
    public static final DomainParameterXref EMPTY = new DomainParameterXref(new LinkedHashMap(0), new IdentityHashMap(0), SqmStatement.ParameterResolutions.empty());
    private final SqmStatement.ParameterResolutions parameterResolutions;
    private final LinkedHashMap<QueryParameterImplementor<?>, List<SqmParameter<?>>> sqmParamsByQueryParam;
    private final IdentityHashMap<SqmParameter<?>, QueryParameterImplementor<?>> queryParamBySqmParam;
    private Map<SqmParameter<?>, List<SqmParameter<?>>> expansions;

    public static DomainParameterXref from(SqmStatement<?> sqmStatement) {
        TreeMap<SqmParameter, QueryParameterImplementor> xrefMap = new TreeMap<SqmParameter, QueryParameterImplementor>();
        SqmStatement.ParameterResolutions parameterResolutions = sqmStatement.resolveParameters();
        if (parameterResolutions.getSqmParameters().isEmpty()) {
            return EMPTY;
        }
        int sqmParamCount = parameterResolutions.getSqmParameters().size();
        LinkedHashMap sqmParamsByQueryParam = new LinkedHashMap(sqmParamCount);
        IdentityHashMap queryParamBySqmParam = new IdentityHashMap(sqmParamCount);
        for (SqmParameter<?> sqmParameter : parameterResolutions.getSqmParameters()) {
            if (sqmParameter instanceof JpaCriteriaParameter) {
                throw new UnsupportedOperationException("Unexpected JpaCriteriaParameter in SqmStatement#getSqmParameters.  Criteria parameters should be represented as SqmJpaCriteriaParameterWrapper references in this collection");
            }
            QueryParameterImplementor queryParameter = xrefMap.computeIfAbsent(sqmParameter, p -> {
                if (sqmParameter instanceof SqmJpaCriteriaParameterWrapper) {
                    return ((SqmJpaCriteriaParameterWrapper)sqmParameter).getJpaCriteriaParameter();
                }
                if (sqmParameter.getName() != null) {
                    return QueryParameterNamedImpl.fromSqm(sqmParameter);
                }
                if (sqmParameter.getPosition() != null) {
                    return QueryParameterPositionalImpl.fromSqm(sqmParameter);
                }
                throw new UnsupportedOperationException("Unexpected SqmParameter type : " + String.valueOf(sqmParameter));
            });
            if (!sqmParameter.allowMultiValuedBinding()) {
                if (queryParameter.allowsMultiValuedBinding()) {
                    SqmTreeTransformationLogger.LOGGER.debugf("SqmParameter [%s] does not allow multi-valued binding, but mapped to existing QueryParameter [%s] that does - disallowing multi-valued binding", sqmParameter, (Object)queryParameter);
                    queryParameter.disallowMultiValuedBinding();
                }
            } else if (sqmParameter.getExpressible() != null && sqmParameter.getExpressible().getSqmType() instanceof BasicCollectionType) {
                queryParameter.disallowMultiValuedBinding();
            }
            sqmParamsByQueryParam.computeIfAbsent(queryParameter, qp -> new ArrayList()).add(sqmParameter);
            queryParamBySqmParam.put(sqmParameter, queryParameter);
        }
        return new DomainParameterXref(sqmParamsByQueryParam, queryParamBySqmParam, parameterResolutions);
    }

    private DomainParameterXref(LinkedHashMap<QueryParameterImplementor<?>, List<SqmParameter<?>>> sqmParamsByQueryParam, IdentityHashMap<SqmParameter<?>, QueryParameterImplementor<?>> queryParamBySqmParam, SqmStatement.ParameterResolutions parameterResolutions) {
        this.sqmParamsByQueryParam = sqmParamsByQueryParam;
        this.queryParamBySqmParam = queryParamBySqmParam;
        this.parameterResolutions = parameterResolutions;
    }

    public DomainParameterXref copy() {
        return new DomainParameterXref(this.sqmParamsByQueryParam, (IdentityHashMap)this.queryParamBySqmParam.clone(), this.parameterResolutions);
    }

    public boolean hasParameters() {
        return this.sqmParamsByQueryParam != null && !this.sqmParamsByQueryParam.isEmpty();
    }

    public Map<QueryParameterImplementor<?>, List<SqmParameter<?>>> getQueryParameters() {
        return this.sqmParamsByQueryParam;
    }

    public int getQueryParameterCount() {
        return this.sqmParamsByQueryParam.size();
    }

    public int getSqmParameterCount() {
        return this.queryParamBySqmParam.size();
    }

    public int getNumberOfSqmParameters(QueryParameterImplementor<?> queryParameter) {
        List<SqmParameter<?>> sqmParameters = this.sqmParamsByQueryParam.get(queryParameter);
        if (sqmParameters == null) {
            return 0;
        }
        return sqmParameters.size();
    }

    public SqmStatement.ParameterResolutions getParameterResolutions() {
        return this.parameterResolutions;
    }

    public List<SqmParameter<?>> getSqmParameters(QueryParameterImplementor<?> queryParameter) {
        return this.sqmParamsByQueryParam.get(queryParameter);
    }

    public QueryParameterImplementor<?> getQueryParameter(SqmParameter<?> sqmParameter) {
        if (sqmParameter instanceof SqmJpaCriteriaParameterWrapper) {
            return ((SqmJpaCriteriaParameterWrapper)sqmParameter).getJpaCriteriaParameter();
        }
        if (sqmParameter instanceof QueryParameterImplementor) {
            return (QueryParameterImplementor)((Object)sqmParameter);
        }
        return this.queryParamBySqmParam.get(sqmParameter);
    }

    public void addExpansion(QueryParameterImplementor<?> domainParam, SqmParameter originalSqmParameter, SqmParameter expansion) {
        assert (!this.queryParamBySqmParam.isEmpty());
        this.queryParamBySqmParam.put(expansion, domainParam);
        if (this.expansions == null) {
            this.expansions = new IdentityHashMap();
        }
        this.expansions.computeIfAbsent(originalSqmParameter, p -> new ArrayList()).add(expansion);
    }

    public List<SqmParameter<?>> getExpansions(SqmParameter<?> sqmParameter) {
        if (this.expansions == null) {
            return Collections.emptyList();
        }
        List<SqmParameter<?>> sqmParameters = this.expansions.get(sqmParameter);
        return sqmParameters == null ? Collections.emptyList() : sqmParameters;
    }

    public void clearExpansions() {
        if (this.expansions == null) {
            return;
        }
        for (List<SqmParameter<?>> expansionList : this.expansions.values()) {
            for (SqmParameter<?> expansion : expansionList) {
                this.queryParamBySqmParam.remove(expansion);
            }
        }
        this.expansions.clear();
    }
}

