/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.predicate;

import jakarta.persistence.criteria.Expression;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.predicate.AbstractNegatableSqmPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmNegatablePredicate;

public class SqmBooleanExpressionPredicate
extends AbstractNegatableSqmPredicate {
    private final SqmExpression<Boolean> booleanExpression;

    public SqmBooleanExpressionPredicate(SqmExpression<Boolean> booleanExpression, NodeBuilder nodeBuilder) {
        this(booleanExpression, false, nodeBuilder);
    }

    public SqmBooleanExpressionPredicate(SqmExpression<Boolean> booleanExpression, boolean negated, NodeBuilder nodeBuilder) {
        super(booleanExpression.getExpressible(), negated, nodeBuilder);
        assert (booleanExpression.getNodeType() != null);
        Class<Boolean> expressionJavaType = booleanExpression.getNodeType().getExpressibleJavaType().getJavaTypeClass();
        assert (Boolean.TYPE.equals(expressionJavaType) || Boolean.class.equals(expressionJavaType));
        this.booleanExpression = booleanExpression;
    }

    @Override
    public SqmBooleanExpressionPredicate copy(SqmCopyContext context) {
        SqmBooleanExpressionPredicate existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        SqmBooleanExpressionPredicate predicate = context.registerCopy(this, new SqmBooleanExpressionPredicate((SqmExpression<Boolean>)this.booleanExpression.copy(context), this.isNegated(), (NodeBuilder)this.nodeBuilder()));
        this.copyTo(predicate, context);
        return predicate;
    }

    public SqmExpression<Boolean> getBooleanExpression() {
        return this.booleanExpression;
    }

    public <T> T accept(SemanticQueryWalker<T> walker) {
        return walker.visitBooleanExpressionPredicate(this);
    }

    @Override
    public List<Expression<Boolean>> getExpressions() {
        ArrayList<Expression<Boolean>> expressions = new ArrayList<Expression<Boolean>>(1);
        expressions.add(this.booleanExpression);
        return expressions;
    }

    @Override
    public void appendHqlString(StringBuilder sb) {
        this.booleanExpression.appendHqlString(sb);
    }

    @Override
    protected SqmNegatablePredicate createNegatedNode() {
        return new SqmBooleanExpressionPredicate(this.booleanExpression, !this.isNegated(), (NodeBuilder)this.nodeBuilder());
    }

    public String toString() {
        if (this.isNegated()) {
            return "SqmBooleanExpressionPredicate( (not) " + String.valueOf(this.booleanExpression) + " )";
        }
        return "SqmBooleanExpressionPredicate( " + String.valueOf(this.booleanExpression) + " )";
    }
}

