/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.mediatype.collectionjson;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Objects;
import org.springframework.hateoas.Links;
import org.springframework.hateoas.mediatype.collectionjson.CollectionJson;
import org.springframework.hateoas.mediatype.collectionjson.CollectionJsonError;
import org.springframework.hateoas.mediatype.collectionjson.CollectionJsonItem;
import org.springframework.hateoas.mediatype.collectionjson.CollectionJsonQuery;
import org.springframework.hateoas.mediatype.collectionjson.CollectionJsonTemplate;

final class CollectionJsonDocument<T> {
    private final CollectionJson<T> collection;

    @JsonCreator
    CollectionJsonDocument(@JsonProperty(value="version") String version, @JsonProperty(value="href") String href, @JsonProperty(value="links") Links links, @JsonProperty(value="items") List<CollectionJsonItem<T>> items, @JsonProperty(value="queries") List<CollectionJsonQuery> queries, @JsonProperty(value="template") CollectionJsonTemplate template, @JsonProperty(value="error") CollectionJsonError error) {
        this.collection = new CollectionJson<T>(version, href, links, items, queries, template, error);
    }

    CollectionJsonDocument(CollectionJson<T> collection) {
        this.collection = collection;
    }

    CollectionJsonDocument<T> withCollection(CollectionJson<T> collection) {
        return this.collection == collection ? this : new CollectionJsonDocument<T>(this.collection);
    }

    @JsonProperty
    public CollectionJson<T> getCollection() {
        return this.collection;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CollectionJsonDocument that = (CollectionJsonDocument)o;
        return Objects.equals(this.collection, that.collection);
    }

    public int hashCode() {
        return Objects.hash(this.collection);
    }

    public String toString() {
        return "CollectionJsonDocument(collection=" + String.valueOf(this.collection) + ")";
    }
}

