/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.perkstore.notification.builder;

import groovy.text.GStringTemplateEngine;
import groovy.text.Template;
import java.io.Writer;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.channel.template.AbstractTemplateBuilder;
import org.exoplatform.commons.api.notification.channel.template.TemplateProvider;
import org.exoplatform.commons.api.notification.model.MessageInfo;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.notification.service.template.TemplateContext;
import org.exoplatform.commons.notification.template.TemplateUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.perkstore.model.Product;
import org.exoplatform.perkstore.model.ProductOrder;
import org.exoplatform.perkstore.service.PerkStoreService;
import org.exoplatform.perkstore.service.utils.NotificationUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class PerkStoreTemplateBuilder
extends AbstractTemplateBuilder {
    private static final Log LOG = ExoLogger.getLogger(PerkStoreTemplateBuilder.class);
    private PerkStoreService perkStoreService;
    private TemplateProvider templateProvider;
    private ExoContainer container;
    private boolean isPushNotification;
    private boolean isOrderNotification;
    private PluginKey key;
    private boolean development;

    public PerkStoreTemplateBuilder(TemplateProvider templateProvider, ExoContainer container, PluginKey key, boolean pushNotification) {
        this(templateProvider, container, key, false, pushNotification);
    }

    public PerkStoreTemplateBuilder(TemplateProvider templateProvider, ExoContainer container, PluginKey key, boolean orderNotification, boolean pushNotification) {
        this.templateProvider = templateProvider;
        this.container = container;
        this.isPushNotification = pushNotification;
        this.isOrderNotification = orderNotification;
        this.key = key;
        String developmentString = System.getProperty("exo.perkstore.development");
        this.development = !StringUtils.isBlank((CharSequence)developmentString) && Boolean.parseBoolean(developmentString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MessageInfo makeMessage(NotificationContext ctx) {
        NotificationInfo notification = ctx.getNotificationInfo();
        RequestLifeCycle.begin((ExoContainer)this.container);
        try {
            Product product = this.getProduct(notification);
            ProductOrder order = this.getProductOrder(notification, this.isOrderNotification);
            String notificationURL = NotificationUtils.getNotificationURL(product, order);
            String pushNotificationURL = this.isPushNotification ? notificationURL : null;
            TemplateContext templateContext = NotificationUtils.buildTemplateParameters(this.templateProvider, notification, notificationURL);
            MessageInfo messageInfo = NotificationUtils.buildMessageSubjectAndBody(templateContext, notification, pushNotificationURL);
            Throwable exception = templateContext.getException();
            this.logException(notification, exception);
            ctx.setException(exception);
            MessageInfo messageInfo2 = messageInfo;
            return messageInfo2;
        }
        catch (Throwable e) {
            ctx.setException(e);
            this.logException(notification, e);
            MessageInfo messageInfo = null;
            return messageInfo;
        }
        finally {
            RequestLifeCycle.end();
        }
    }

    private void logException(NotificationInfo notification, Throwable e) {
        if (e != null) {
            if (LOG.isDebugEnabled()) {
                LOG.warn("Error building notification content: {}", new Object[]{notification, e});
            } else {
                LOG.warn("Error building notification content: {}, error: {}", new Object[]{notification, e.getMessage()});
            }
        }
    }

    protected boolean makeDigest(NotificationContext ctx, Writer writer) {
        return false;
    }

    private final Product getProduct(NotificationInfo notification) {
        String productIdString = notification.getValueOwnerParameter("PRODUCT_ID");
        if (StringUtils.isBlank((CharSequence)productIdString)) {
            throw new IllegalStateException("Product id is missing in notification");
        }
        long productId = Long.parseLong(productIdString);
        return this.getPerkStoreService().getProductById(productId);
    }

    private final ProductOrder getProductOrder(NotificationInfo notification, boolean mandatory) {
        String orderIdString = notification.getValueOwnerParameter("ORDER_ID");
        if (StringUtils.isBlank((CharSequence)orderIdString)) {
            if (mandatory) {
                throw new IllegalStateException("Order is mandatory");
            }
            return null;
        }
        long orderId = Long.parseLong(orderIdString);
        if (orderId == 0L) {
            throw new IllegalStateException("Order id is equal to 0 in notification");
        }
        return this.getPerkStoreService().getOrderById(orderId);
    }

    public PerkStoreService getPerkStoreService() {
        if (this.perkStoreService == null) {
            this.perkStoreService = (PerkStoreService)CommonsUtils.getService(PerkStoreService.class);
        }
        return this.perkStoreService;
    }

    public Template getTemplateEngine() {
        if (this.development) {
            String templatePath = null;
            try {
                templatePath = (String)this.templateProvider.getTemplateFilePathConfigs().get(this.key);
                String template = TemplateUtils.loadGroovyTemplate((String)templatePath);
                if (StringUtils.isBlank((CharSequence)template)) {
                    throw new IllegalStateException("Template with path " + templatePath + " wasn't found");
                }
                return new GStringTemplateEngine().createTemplate(template);
            }
            catch (Exception e) {
                LOG.warn("Error while compiling template {}", new Object[]{templatePath, e});
                try {
                    return new GStringTemplateEngine().createTemplate("");
                }
                catch (Exception e1) {
                    return null;
                }
            }
        }
        return super.getTemplateEngine();
    }

    public TemplateProvider getTemplateProvider() {
        return this.templateProvider;
    }
}

