/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.perkstore.notification.plugin;

import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.plugin.BaseNotificationPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.perkstore.model.GlobalSettings;
import org.exoplatform.perkstore.model.Product;
import org.exoplatform.perkstore.model.ProductOrder;
import org.exoplatform.perkstore.model.Profile;
import org.exoplatform.perkstore.model.constant.ProductOrderModificationType;
import org.exoplatform.perkstore.service.utils.NotificationUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class PerkStoreNotificationPlugin
extends BaseNotificationPlugin {
    private static final Log LOG = ExoLogger.getLogger(PerkStoreNotificationPlugin.class);
    private String notificationId;
    private boolean newProduct;
    private boolean newOrder;
    private boolean mandatoryOrder;

    public PerkStoreNotificationPlugin(InitParams initParams) {
        super(initParams);
        ValueParam newOrderParam;
        ValueParam mandatoryOrderParam;
        ValueParam notificationIdParam = initParams.getValueParam("notification.id");
        if (notificationIdParam == null || StringUtils.isBlank((CharSequence)notificationIdParam.getValue())) {
            throw new IllegalStateException("'notification.id' parameter is mandatory");
        }
        this.notificationId = notificationIdParam.getValue();
        ValueParam newProductParam = initParams.getValueParam("product.new");
        if (newProductParam != null && StringUtils.isNotBlank((CharSequence)newProductParam.getValue())) {
            this.newProduct = Boolean.parseBoolean(newProductParam.getValue());
        }
        if ((mandatoryOrderParam = initParams.getValueParam("order.mandatory")) != null && StringUtils.isNotBlank((CharSequence)mandatoryOrderParam.getValue())) {
            this.mandatoryOrder = Boolean.parseBoolean(mandatoryOrderParam.getValue());
        }
        if ((newOrderParam = initParams.getValueParam("order.new")) != null && StringUtils.isNotBlank((CharSequence)newOrderParam.getValue())) {
            this.newOrder = Boolean.parseBoolean(newOrderParam.getValue());
        }
        if (this.newProduct && this.newOrder) {
            throw new IllegalStateException("The notification couldn't be of type newly added product and about a order that was paid");
        }
        if (this.newProduct && this.mandatoryOrder) {
            throw new IllegalStateException("The notification couldn't be of type newly added product and with a mandatory order");
        }
        if (this.newOrder && !this.mandatoryOrder) {
            throw new IllegalStateException("The notification couldn't be of type order payment without a mandatory order");
        }
    }

    public String getId() {
        return this.notificationId;
    }

    public boolean isValid(NotificationContext ctx) {
        if (NotificationUtils.getProductParameter(ctx) == null) {
            LOG.warn("Notification type '{}' isn't valid because the product wasn't found", new Object[]{this.getId()});
            return false;
        }
        if (this.newProduct != NotificationUtils.isNewProductParameter(ctx)) {
            LOG.warn("Notification type '{}' isn't valid because the product should be ", new Object[]{this.getId(), this.newProduct ? "'a new product'" : "'an existing product'"});
            return false;
        }
        if (this.mandatoryOrder && NotificationUtils.getUpdatedOrderParameter(ctx) == null) {
            LOG.warn("Notification type '{}' isn't valid because the order wasn't found ", new Object[]{this.getId()});
            return false;
        }
        if (this.newOrder != NotificationUtils.isNewOrderParameter(ctx)) {
            LOG.warn("Notification type '{}' isn't valid because the order should be ", new Object[]{this.getId(), this.newOrder ? "'a new order'" : "'an existing order'"});
            return false;
        }
        return true;
    }

    public NotificationInfo makeNotification(NotificationContext ctx) {
        GlobalSettings globalSettings = NotificationUtils.getSettingsParameter(ctx);
        Product product = NotificationUtils.getProductParameter(ctx);
        ProductOrder updatedOrder = NotificationUtils.getUpdatedOrderParameter(ctx);
        ProductOrder oldOrder = NotificationUtils.getOldOrderParameter(ctx);
        Profile modifier = NotificationUtils.getModifierParameter(ctx);
        ProductOrderModificationType orderModificationType = NotificationUtils.getOrderModificationTypeParameter(ctx);
        NotificationInfo notification = NotificationInfo.instance();
        notification.key(this.getId());
        NotificationUtils.setNotificationRecipients(notification, globalSettings, product, updatedOrder, this.newProduct, this.newOrder, modifier);
        if (!notification.isSendAll() && (notification.getSendToUserIds() == null || notification.getSendToUserIds().isEmpty())) {
            LOG.debug("Notification type '{}' doesn't have a recipient", new Object[]{this.getId()});
            return null;
        }
        NotificationUtils.storeSettingsParameters(globalSettings, notification);
        boolean isNew = this.newProduct || updatedOrder != null && product.getLastModifier() == null;
        NotificationUtils.storeProductParameters(notification, product, isNew);
        if (updatedOrder != null) {
            NotificationUtils.storeOrderParameters(notification, oldOrder, updatedOrder, orderModificationType, this.newOrder, modifier);
        }
        return notification.end();
    }
}

