/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.chain.web.jakarta;

import jakarta.servlet.ServletContext;
import java.net.URL;
import java.util.ArrayList;
import org.apache.commons.chain.web.CheckedConsumer;
import org.apache.commons.chain.web.CheckedFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ChainResources {
    private ChainResources() {
    }

    static <E extends Exception> void parseClassResources(String resources, CheckedConsumer<URL, E> parse) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = ChainResources.class.getClassLoader();
        }
        ChainResources.parseResources(loader::getResource, resources, parse);
    }

    static <E extends Exception> void parseWebResources(ServletContext context, String resources, CheckedConsumer<URL, E> parse) {
        ChainResources.parseResources(arg_0 -> ((ServletContext)context).getResource(arg_0), resources, parse);
    }

    private static <ER extends Exception, EP extends Exception> void parseResources(CheckedFunction<String, URL, ER> resourceFunction, String resources, CheckedConsumer<URL, EP> parse) {
        if (resources == null) {
            return;
        }
        Logger logger = LoggerFactory.getLogger(ChainResources.class);
        String[] paths = ChainResources.getResourcePaths(resources);
        String path = null;
        try {
            for (String path2 : paths) {
                path = path2;
                URL url = (URL)resourceFunction.apply((Object)path);
                if (url == null) {
                    throw new IllegalStateException("Missing chain config resource '" + path + "'");
                }
                logger.debug("Loading chain config resource '{}'", (Object)path);
                parse.accept((Object)url);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Exception parsing chain config resource '" + path + "': " + e.getMessage());
        }
    }

    static String[] getResourcePaths(String resources) {
        ArrayList<String> paths = new ArrayList<String>();
        if (resources != null) {
            String path;
            int comma;
            int lastComma = 0;
            while ((comma = resources.indexOf(44, lastComma)) >= 0) {
                path = resources.substring(lastComma, comma).trim();
                if (path.length() > 0) {
                    paths.add(path);
                }
                lastComma = comma + 1;
            }
            path = resources.substring(lastComma).trim();
            if (path.length() > 0) {
                paths.add(path);
            }
        }
        return paths.toArray(new String[0]);
    }
}

