/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.NamespaceRegistry;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.query.QueryManager;
import org.exoplatform.commons.utils.ClassLoading;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.jmx.annotations.NameTemplate;
import org.exoplatform.management.jmx.annotations.NamingContext;
import org.exoplatform.management.jmx.annotations.Property;
import org.exoplatform.services.jcr.config.ExtendedMappedParametrizedObjectEntry;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.config.SystemParametersPersistenceConfigurator;
import org.exoplatform.services.jcr.config.ValueStorageEntry;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeTypeManager;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeDataManager;
import org.exoplatform.services.jcr.impl.RepositoryCreationSynchronizer;
import org.exoplatform.services.jcr.impl.RepositorySuspendController;
import org.exoplatform.services.jcr.impl.WorkspaceContainer;
import org.exoplatform.services.jcr.impl.WorkspaceResumer;
import org.exoplatform.services.jcr.impl.checker.RepositoryCheckController;
import org.exoplatform.services.jcr.impl.core.AddNamespacePluginHolder;
import org.exoplatform.services.jcr.impl.core.LocationFactory;
import org.exoplatform.services.jcr.impl.core.NamespaceDataPersister;
import org.exoplatform.services.jcr.impl.core.NamespaceRegistryImpl;
import org.exoplatform.services.jcr.impl.core.RepositoryImpl;
import org.exoplatform.services.jcr.impl.core.ScratchWorkspaceInitializer;
import org.exoplatform.services.jcr.impl.core.SessionFactory;
import org.exoplatform.services.jcr.impl.core.SessionRegistry;
import org.exoplatform.services.jcr.impl.core.WorkspaceInitializer;
import org.exoplatform.services.jcr.impl.core.access.DefaultAccessManagerImpl;
import org.exoplatform.services.jcr.impl.core.lock.LockRemoverHolder;
import org.exoplatform.services.jcr.impl.core.nodetype.NodeTypeDataManagerImpl;
import org.exoplatform.services.jcr.impl.core.nodetype.NodeTypeManagerImpl;
import org.exoplatform.services.jcr.impl.core.nodetype.registration.JCRNodeTypeDataPersister;
import org.exoplatform.services.jcr.impl.core.observation.ObservationManagerRegistry;
import org.exoplatform.services.jcr.impl.core.query.QueryManagerFactory;
import org.exoplatform.services.jcr.impl.core.query.RepositoryIndexSearcherHolder;
import org.exoplatform.services.jcr.impl.core.query.SearchManager;
import org.exoplatform.services.jcr.impl.core.query.SystemSearchManager;
import org.exoplatform.services.jcr.impl.core.query.SystemSearchManagerHolder;
import org.exoplatform.services.jcr.impl.core.value.ValueFactoryImpl;
import org.exoplatform.services.jcr.impl.dataflow.persistent.CacheableWorkspaceDataManager;
import org.exoplatform.services.jcr.impl.dataflow.persistent.LinkedWorkspaceStorageCacheImpl;
import org.exoplatform.services.jcr.impl.dataflow.persistent.LocalWorkspaceDataManagerStub;
import org.exoplatform.services.jcr.impl.dataflow.session.TransactionableResourceManager;
import org.exoplatform.services.jcr.impl.quota.QuotaManager;
import org.exoplatform.services.jcr.impl.quota.RepositoryQuotaManager;
import org.exoplatform.services.jcr.impl.quota.WorkspaceQuotaManager;
import org.exoplatform.services.jcr.impl.storage.SystemDataContainerHolder;
import org.exoplatform.services.jcr.impl.storage.value.StandaloneStoragePluginProvider;
import org.exoplatform.services.jcr.impl.util.io.FileCleanerHolder;
import org.exoplatform.services.jcr.storage.WorkspaceDataContainer;
import org.exoplatform.services.jcr.util.IdGenerator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rpc.RPCService;

@Managed
@NameTemplate(value={@Property(key="repository", value="{Name}")})
@NamingContext(value={@Property(key="repository", value="{Name}")})
public class RepositoryContainer
extends ExoContainer {
    private static final long serialVersionUID = -8441933562276408877L;
    private final RepositoryEntry config;
    private final String name;
    private LocalWorkspaceDataManagerStub systemDataManager = null;
    private final Log log = ExoLogger.getLogger((String)"exo.jcr.component.core.RepositoryContainer");
    private List<ComponentPlugin> addNamespacePlugins;

    public RepositoryContainer(ExoContainer parent, RepositoryEntry config, List<ComponentPlugin> addNamespacePlugins) throws RepositoryException, RepositoryConfigurationException {
        super(parent);
        if (config.getAccessControl() == null) {
            config.setAccessControl("optional");
        }
        this.config = config;
        this.addNamespacePlugins = addNamespacePlugins;
        this.name = config.getName();
        this.context.setName(parent.getContext().getName() + "-" + this.name);
        try {
            parent.registerComponentInstance((Object)this.name, (Object)this);
            this.initAllWorkspaceComponentEntries(parent);
            this.registerComponents();
        }
        catch (Throwable t) {
            this.unregisterAllComponents();
            parent.unregisterComponent((Object)this.name);
            throw new RepositoryConfigurationException("Can not register repository container " + this.name + " in parent container.", t);
        }
    }

    private void initAllWorkspaceComponentEntries(ExoContainer parent) {
        SystemParametersPersistenceConfigurator sppc = (SystemParametersPersistenceConfigurator)parent.getComponentInstanceOfType(SystemParametersPersistenceConfigurator.class);
        for (WorkspaceEntry workspaceEntry : this.config.getWorkspaceEntries()) {
            this.initWorkspaceComponentEntries(sppc, workspaceEntry);
        }
    }

    public void initWorkspaceComponentEntries(SystemParametersPersistenceConfigurator sppc, WorkspaceEntry workspaceEntry) {
        workspaceEntry.setUniqueName(this.getName() + "_" + workspaceEntry.getName());
        if (sppc != null) {
            for (ExtendedMappedParametrizedObjectEntry entry : this.getWorkspaceComponentEntries(workspaceEntry)) {
                entry.initSystemParameterUpdater(workspaceEntry, sppc);
            }
        }
    }

    private List<ExtendedMappedParametrizedObjectEntry> getWorkspaceComponentEntries(WorkspaceEntry workspaceEntry) {
        ArrayList<ExtendedMappedParametrizedObjectEntry> entries = new ArrayList<ExtendedMappedParametrizedObjectEntry>();
        if (workspaceEntry.getAccessManager() != null) {
            entries.add(workspaceEntry.getAccessManager());
        }
        if (workspaceEntry.getCache() != null) {
            entries.add(workspaceEntry.getCache());
        }
        if (workspaceEntry.getInitializer() != null) {
            entries.add(workspaceEntry.getInitializer());
        }
        if (workspaceEntry.getLockManager() != null) {
            entries.add(workspaceEntry.getLockManager());
        }
        if (workspaceEntry.getQueryHandler() != null) {
            entries.add(workspaceEntry.getQueryHandler());
        }
        if (workspaceEntry.getContainer() != null) {
            entries.add(workspaceEntry.getContainer());
            if (workspaceEntry.getContainer().getValueStorages() != null) {
                for (ValueStorageEntry valueStorageEntry : workspaceEntry.getContainer().getValueStorages()) {
                    entries.add(valueStorageEntry);
                }
            }
        }
        return entries;
    }

    public RepositoryContainer(ExoContainer parent, RepositoryEntry config) throws RepositoryException, RepositoryConfigurationException {
        this(parent, config, new ArrayList<ComponentPlugin>());
    }

    public LocationFactory getLocationFactory() {
        return (LocationFactory)this.getComponentInstanceOfType(LocationFactory.class);
    }

    @Managed
    @ManagedDescription(value="The repository container name")
    public String getName() {
        return this.name;
    }

    public NamespaceRegistry getNamespaceRegistry() {
        return (NamespaceRegistry)this.getComponentInstanceOfType(NamespaceRegistry.class);
    }

    public ExtendedNodeTypeManager getNodeTypeManager() {
        return (ExtendedNodeTypeManager)this.getComponentInstanceOfType(NodeTypeManager.class);
    }

    public WorkspaceContainer getWorkspaceContainer(String workspaceName) {
        Object comp = this.getComponentInstance(workspaceName);
        return comp != null && comp instanceof WorkspaceContainer ? (WorkspaceContainer)((Object)comp) : null;
    }

    public WorkspaceEntry getWorkspaceEntry(String wsName) {
        for (WorkspaceEntry entry : this.config.getWorkspaceEntries()) {
            if (!entry.getName().equals(wsName)) continue;
            return entry;
        }
        return null;
    }

    public void registerWorkspace(WorkspaceEntry wsConfig) throws RepositoryException, RepositoryConfigurationException {
        Class initilizerType;
        boolean isSystem = this.config.getSystemWorkspaceName().equals(wsConfig.getName());
        if (this.getWorkspaceContainer(wsConfig.getName()) != null) {
            throw new RepositoryException("Workspace " + wsConfig.getName() + " already registered");
        }
        WorkspaceContainer workspaceContainer = new WorkspaceContainer(this, wsConfig);
        this.registerComponentInstance(wsConfig.getName(), (Object)workspaceContainer);
        workspaceContainer.registerComponentInstance(wsConfig);
        workspaceContainer.registerComponentImplementation(StandaloneStoragePluginProvider.class);
        try {
            Class containerType = ClassLoading.forName((String)wsConfig.getContainer().getType(), RepositoryContainer.class);
            workspaceContainer.registerComponentImplementation(containerType);
            if (isSystem) {
                this.registerComponentInstance(new SystemDataContainerHolder((WorkspaceDataContainer)workspaceContainer.getComponentInstanceOfType(WorkspaceDataContainer.class)));
            }
        }
        catch (ClassNotFoundException e) {
            throw new RepositoryConfigurationException("Class not found for workspace data container " + wsConfig.getUniqueName() + " : " + String.valueOf(e), e);
        }
        try {
            String className = wsConfig.getCache().getType();
            if (className != null && className.length() > 0) {
                workspaceContainer.registerComponentImplementation(ClassLoading.forName((String)className, RepositoryContainer.class));
            } else {
                workspaceContainer.registerComponentImplementation(LinkedWorkspaceStorageCacheImpl.class);
            }
        }
        catch (ClassNotFoundException e) {
            this.log.warn((Object)("Workspace cache class not found " + wsConfig.getCache().getType() + ", will use default. Error : " + e.getMessage()));
            workspaceContainer.registerComponentImplementation(LinkedWorkspaceStorageCacheImpl.class);
        }
        if (workspaceContainer.getComponentInstanceOfType(RPCService.class) != null) {
            workspaceContainer.registerComponentImplementation(WorkspaceResumer.class);
        }
        if (workspaceContainer.getComponentInstanceOfType(QuotaManager.class) != null) {
            workspaceContainer.registerComponentImplementation(WorkspaceQuotaManager.class);
        }
        workspaceContainer.registerComponentImplementation(CacheableWorkspaceDataManager.class);
        workspaceContainer.registerComponentImplementation(LocalWorkspaceDataManagerStub.class);
        workspaceContainer.registerComponentImplementation(ObservationManagerRegistry.class);
        if (wsConfig.getLockManager() != null && wsConfig.getLockManager().getType() != null) {
            try {
                Class lockManagerType = ClassLoading.forName((String)wsConfig.getLockManager().getType(), RepositoryContainer.class);
                workspaceContainer.registerComponentImplementation(lockManagerType);
            }
            catch (ClassNotFoundException e) {
                throw new RepositoryConfigurationException("Class not found for workspace lock manager " + wsConfig.getLockManager().getType() + ", container " + wsConfig.getUniqueName() + " : " + String.valueOf(e), e);
            }
        } else {
            throw new RepositoryConfigurationException("The configuration of lock manager is expected in container " + wsConfig.getUniqueName());
        }
        if (wsConfig.getQueryHandler() != null) {
            workspaceContainer.registerComponentImplementation(SearchManager.class);
            workspaceContainer.registerComponentImplementation(QueryManager.class);
            workspaceContainer.registerComponentImplementation(QueryManagerFactory.class);
            workspaceContainer.registerComponentInstance(wsConfig.getQueryHandler());
            if (isSystem) {
                workspaceContainer.registerComponentImplementation(SystemSearchManager.class);
            }
        }
        if (wsConfig.getAccessManager() != null && wsConfig.getAccessManager().getType() != null) {
            try {
                Class am = ClassLoading.forName((String)wsConfig.getAccessManager().getType(), RepositoryContainer.class);
                workspaceContainer.registerComponentImplementation(am);
            }
            catch (ClassNotFoundException e) {
                throw new RepositoryConfigurationException("Class not found for workspace access manager " + wsConfig.getAccessManager().getType() + ", container " + wsConfig.getUniqueName() + " : " + String.valueOf(e), e);
            }
        }
        if (wsConfig.getInitializer() != null && wsConfig.getInitializer().getType() != null) {
            try {
                initilizerType = ClassLoading.forName((String)wsConfig.getInitializer().getType(), RepositoryContainer.class);
            }
            catch (ClassNotFoundException e) {
                throw new RepositoryConfigurationException("Class not found for workspace initializer " + wsConfig.getInitializer().getType() + ", container " + wsConfig.getUniqueName() + " : " + String.valueOf(e), e);
            }
        } else {
            initilizerType = ScratchWorkspaceInitializer.class;
        }
        workspaceContainer.registerComponentImplementation(initilizerType);
        workspaceContainer.registerComponentImplementation(TransactionableResourceManager.class);
        workspaceContainer.registerComponentImplementation(SessionFactory.class);
        LocalWorkspaceDataManagerStub wsDataManager = (LocalWorkspaceDataManagerStub)workspaceContainer.getComponentInstanceOfType(LocalWorkspaceDataManagerStub.class);
        if (isSystem) {
            this.systemDataManager = wsDataManager;
            this.registerComponentInstance(this.systemDataManager);
        }
        wsDataManager.setSystemDataManager(this.systemDataManager);
        if (!this.config.getWorkspaceEntries().contains(wsConfig)) {
            this.config.getWorkspaceEntries().add(wsConfig);
        }
    }

    public void start() {
        try {
            this.init();
            this.load();
        }
        catch (RepositoryException e) {
            this.log.error((Object)"Repository error", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (RepositoryConfigurationException e) {
            this.log.error((Object)"Configuration error", (Throwable)e);
            throw new RuntimeException(e);
        }
        super.start();
    }

    public synchronized void stop() {
        RepositoryImpl repository = (RepositoryImpl)this.getComponentInstanceOfType(RepositoryImpl.class);
        try {
            repository.setState(0);
        }
        catch (RepositoryException e) {
            this.log.error((Object)"Can not switch repository to OFFLINE", (Throwable)e);
        }
        super.stop();
        super.unregisterAllComponents();
    }

    private void init() throws RepositoryException, RepositoryConfigurationException {
        List<WorkspaceEntry> wsEntries = this.config.getWorkspaceEntries();
        NodeTypeDataManager typeManager = (NodeTypeDataManager)this.getComponentInstanceOfType(NodeTypeDataManager.class);
        NamespaceRegistryImpl namespaceRegistry = (NamespaceRegistryImpl)this.getComponentInstanceOfType(NamespaceRegistry.class);
        for (WorkspaceEntry ws : wsEntries) {
            this.initWorkspace(ws);
            WorkspaceContainer workspaceContainer = this.getWorkspaceContainer(ws.getName());
            SearchManager searchManager = (SearchManager)workspaceContainer.getComponentInstanceOfType(SearchManager.class);
        }
        SystemSearchManagerHolder searchManager = (SystemSearchManagerHolder)this.getComponentInstanceOfType(SystemSearchManagerHolder.class);
    }

    private void initWorkspace(WorkspaceEntry wsConfig) throws RepositoryException {
        WorkspaceContainer workspaceContainer = this.getWorkspaceContainer(wsConfig.getName());
        workspaceContainer.getComponentInstanceOfType(IdGenerator.class);
        WorkspaceInitializer wsInitializer = (WorkspaceInitializer)workspaceContainer.getComponentInstanceOfType(WorkspaceInitializer.class);
        RepositoryCreationSynchronizer synchronizer = (RepositoryCreationSynchronizer)this.getComponentInstanceOfType(RepositoryCreationSynchronizer.class);
        synchronizer.waitForApproval(wsInitializer.isWorkspaceInitialized());
        SystemParametersPersistenceConfigurator sppc = (SystemParametersPersistenceConfigurator)this.parent.getComponentInstanceOfType(SystemParametersPersistenceConfigurator.class);
        if (sppc != null) {
            this.setInitializerAndValidateOverriddenParameters(wsConfig, wsInitializer);
        }
        wsInitializer.initWorkspace();
    }

    public void setInitializerAndValidateOverriddenParameters(WorkspaceEntry workspaceEntry, WorkspaceInitializer workspaceInitializer) {
        this.setInitializerForWorkspaceComponents(workspaceEntry, workspaceInitializer);
        this.validateOverriddenParametersOfWorkspaceComponents(workspaceEntry);
    }

    private void setInitializerForWorkspaceComponents(WorkspaceEntry workspaceEntry, WorkspaceInitializer workspaceInitializer) {
        for (ExtendedMappedParametrizedObjectEntry entry : this.getWorkspaceComponentEntries(workspaceEntry)) {
            entry.getSystemParameterUpdater().setWorkspaceInitializer(workspaceInitializer);
        }
    }

    private void validateOverriddenParametersOfWorkspaceComponents(WorkspaceEntry workspaceEntry) {
        for (ExtendedMappedParametrizedObjectEntry entry : this.getWorkspaceComponentEntries(workspaceEntry)) {
            entry.getSystemParameterUpdater().validateOverriddenParameters();
        }
    }

    private void registerComponents() throws RepositoryConfigurationException, RepositoryException {
        this.registerComponentInstance(this.config);
        this.registerComponentImplementation(FileCleanerHolder.class);
        this.registerComponentImplementation(LockRemoverHolder.class);
        this.registerWorkspacesComponents();
        this.registerRepositoryComponents();
    }

    private void registerRepositoryComponents() throws RepositoryConfigurationException, RepositoryException {
        if (this.getComponentInstanceOfType(QuotaManager.class) != null) {
            this.registerComponentImplementation(RepositoryQuotaManager.class);
        }
        this.registerComponentImplementation(RepositorySuspendController.class);
        this.registerComponentImplementation(RepositoryCheckController.class);
        this.registerComponentImplementation(IdGenerator.class);
        this.registerComponentImplementation(RepositoryIndexSearcherHolder.class);
        this.registerComponentImplementation(LocationFactory.class);
        this.registerComponentImplementation(ValueFactoryImpl.class);
        this.registerComponentInstance(new AddNamespacePluginHolder(this.addNamespacePlugins));
        this.registerComponentImplementation(JCRNodeTypeDataPersister.class);
        this.registerComponentImplementation(NamespaceDataPersister.class);
        this.registerComponentImplementation(NamespaceRegistryImpl.class);
        this.registerComponentImplementation(NodeTypeManagerImpl.class);
        this.registerComponentImplementation(NodeTypeDataManagerImpl.class);
        this.registerComponentImplementation(DefaultAccessManagerImpl.class);
        this.registerComponentImplementation(SessionRegistry.class);
        String systemWsname = this.config.getSystemWorkspaceName();
        WorkspaceEntry systemWsEntry = this.getWorkspaceEntry(systemWsname);
        if (systemWsEntry != null && systemWsEntry.getQueryHandler() != null) {
            SystemSearchManager systemSearchManager = (SystemSearchManager)this.getWorkspaceContainer(systemWsname).getComponentInstanceOfType(SystemSearchManager.class);
            this.registerComponentInstance(new SystemSearchManagerHolder(systemSearchManager));
        }
        try {
            Class authenticationPolicyClass = ClassLoading.forName((String)this.config.getAuthenticationPolicy(), RepositoryContainer.class);
            this.registerComponentImplementation(authenticationPolicyClass);
        }
        catch (ClassNotFoundException e) {
            throw new RepositoryConfigurationException("Class not found for repository authentication policy: " + String.valueOf(e), e);
        }
        RepositoryImpl repository = new RepositoryImpl(this);
        this.registerComponentInstance(repository);
    }

    private void registerWorkspacesComponents() throws RepositoryException, RepositoryConfigurationException {
        for (WorkspaceEntry we : this.config.getWorkspaceEntries()) {
            if (!we.getName().equals(this.config.getSystemWorkspaceName())) continue;
            this.registerWorkspace(we);
        }
        for (WorkspaceEntry we : this.config.getWorkspaceEntries()) {
            if (we.getName().equals(this.config.getSystemWorkspaceName())) continue;
            this.registerWorkspace(we);
        }
    }

    private void load() throws RepositoryException {
        NamespaceDataPersister namespacePersister = (NamespaceDataPersister)this.getComponentInstanceOfType(NamespaceDataPersister.class);
        NamespaceRegistryImpl nsRegistry = (NamespaceRegistryImpl)this.getNamespaceRegistry();
        namespacePersister.start();
        nsRegistry.start();
        JCRNodeTypeDataPersister nodeTypePersister = (JCRNodeTypeDataPersister)this.getComponentInstanceOfType(JCRNodeTypeDataPersister.class);
        NodeTypeDataManagerImpl ntManager = (NodeTypeDataManagerImpl)this.getComponentInstanceOfType(NodeTypeDataManagerImpl.class);
        nodeTypePersister.start();
        ntManager.start();
    }
}

