/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl;

import javax.jcr.RepositoryException;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.jmx.annotations.NameTemplate;
import org.exoplatform.management.jmx.annotations.NamingContext;
import org.exoplatform.management.jmx.annotations.Property;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.impl.RepositoryContainer;
import org.exoplatform.services.jcr.impl.core.SessionFactory;
import org.exoplatform.services.jcr.impl.core.WorkspaceInitializer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

@Managed
@NameTemplate(value={@Property(key="workspace", value="{Name}")})
@NamingContext(value={@Property(key="workspace", value="{Name}")})
public class WorkspaceContainer
extends ExoContainer {
    private static final long serialVersionUID = 6960318261888349500L;
    protected static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.WorkspaceContainer");
    private final String name;
    private final RepositoryContainer repositoryContainer;

    public WorkspaceContainer(RepositoryContainer parent, WorkspaceEntry config) throws RepositoryException, RepositoryConfigurationException {
        super((ExoContainer)parent);
        this.repositoryContainer = parent;
        this.name = config.getName();
        this.context.setName(this.repositoryContainer.getContext().getName() + "-" + this.name);
    }

    @Managed
    @ManagedDescription(value="The workspace container name")
    public String getName() {
        return this.name;
    }

    public SessionFactory getSessionFactory() {
        return (SessionFactory)this.getComponentInstanceOfType(SessionFactory.class, false);
    }

    public WorkspaceInitializer getWorkspaceInitializer() {
        return (WorkspaceInitializer)this.getComponentInstanceOfType(WorkspaceInitializer.class, false);
    }

    public synchronized void stop() {
        super.stop();
        super.unregisterAllComponents();
    }
}

