/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.backup.rdbms;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipInputStream;
import javax.naming.NamingException;
import org.exoplatform.services.database.utils.DialectDetecter;
import org.exoplatform.services.database.utils.JDBCUtils;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.dataflow.serialization.ObjectReader;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.backup.BackupException;
import org.exoplatform.services.jcr.impl.backup.DataRestore;
import org.exoplatform.services.jcr.impl.backup.rdbms.TableTransformationRule;
import org.exoplatform.services.jcr.impl.clean.rdbms.DBCleanException;
import org.exoplatform.services.jcr.impl.clean.rdbms.DBCleanerTool;
import org.exoplatform.services.jcr.impl.dataflow.serialization.ObjectReaderImpl;
import org.exoplatform.services.jcr.impl.dataflow.serialization.ZipObjectReader;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;
import org.exoplatform.services.jcr.impl.util.jdbc.DBInitializerHelper;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class DBRestore
implements DataRestore {
    private final int MAXIMUM_BATCH_SIZE = 1000;
    private final List<File> spoolFileList = new ArrayList<File>();
    private final FileCleaner fileCleaner;
    private final File tempDir = new File(System.getProperty("java.io.tmpdir"));
    private final int maxBufferSize;
    protected static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.DBRestor");
    protected final Connection jdbcConn;
    private final File storageDir;
    protected final Map<String, TableTransformationRule> tables;
    private final DBCleanerTool dbCleaner;
    protected final String dialect;
    protected final boolean useSequence;
    protected final String itemTableName;
    protected List<String> successfulExecuted;
    protected boolean dbCleanerInAutoCommit;

    public DBRestore(File storageDir, Connection jdbcConn, Map<String, TableTransformationRule> tables, WorkspaceEntry wsConfig, FileCleaner fileCleaner, DBCleanerTool dbCleaner) throws NamingException, SQLException, RepositoryConfigurationException {
        this.jdbcConn = jdbcConn;
        this.fileCleaner = fileCleaner;
        this.maxBufferSize = wsConfig.getContainer().getParameterInteger("max-buffer-size", 204800);
        this.storageDir = storageDir;
        this.tables = tables;
        this.dbCleaner = dbCleaner;
        this.dialect = DialectDetecter.detect((DatabaseMetaData)jdbcConn.getMetaData());
        this.dbCleanerInAutoCommit = this.dialect.startsWith("SYBASE");
        this.itemTableName = DBInitializerHelper.getItemTableName(wsConfig);
        this.useSequence = DBInitializerHelper.useSequenceForOrderNumber(wsConfig, this.dialect);
    }

    @Override
    public void clean() throws BackupException {
        LOG.info((Object)"Start to clean JCR tables");
        try {
            this.dbCleaner.clean();
        }
        catch (DBCleanException e) {
            throw new BackupException(e);
        }
    }

    @Override
    public void restore() throws BackupException {
        try {
            for (Map.Entry<String, TableTransformationRule> entry : this.tables.entrySet()) {
                String tableName = entry.getKey();
                TableTransformationRule restoreRule = entry.getValue();
                this.restoreTable(this.storageDir, this.jdbcConn, tableName, restoreRule);
            }
        }
        catch (IOException e) {
            throw new BackupException(e);
        }
        catch (SQLException e) {
            throw new BackupException("SQL Exception: " + JDBCUtils.getFullMessage((SQLException)e), e);
        }
    }

    @Override
    public void commit() throws BackupException {
        try {
            this.dbCleaner.commit();
            this.jdbcConn.commit();
        }
        catch (SQLException e) {
            throw new BackupException(e);
        }
        catch (DBCleanException e) {
            throw new BackupException(e);
        }
    }

    @Override
    public void rollback() throws BackupException {
        try {
            this.jdbcConn.rollback();
            this.dbCleaner.rollback();
            this.jdbcConn.commit();
        }
        catch (SQLException e) {
            throw new BackupException(e);
        }
        catch (DBCleanException e) {
            throw new BackupException(e);
        }
    }

    @Override
    public void close() throws BackupException {
        try {
            if (!this.jdbcConn.isClosed()) {
                this.jdbcConn.close();
            }
        }
        catch (SQLException e) {
            throw new BackupException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreTable(File storageDir, Connection jdbcConn, String tableName, TableTransformationRule restoreRule) throws IOException, SQLException {
        ObjectReaderImpl contentReader = null;
        ObjectReaderImpl contentLenReader = null;
        Statement insertNode = null;
        ResultSet tableMetaData = null;
        Statement stmt = null;
        if (this.dialect.startsWith("PGSQL")) {
            tableName = tableName.toLowerCase();
        }
        try {
            File contentFile = new File(storageDir, restoreRule.getSrcTableName() + ".dump");
            if (contentFile.exists()) {
                contentReader = new ZipObjectReader(new ZipInputStream(new FileInputStream(contentFile)));
                ((ZipObjectReader)contentReader).getNextEntry();
                contentLenFile = new File(storageDir, restoreRule.getSrcTableName() + ".len");
                contentLenReader = new ZipObjectReader(new ZipInputStream(new FileInputStream(contentLenFile)));
                ((ZipObjectReader)contentLenReader).getNextEntry();
            } else {
                contentFile = new File(storageDir, "dump.zip");
                contentReader = new ZipObjectReader(new ZipInputStream(new FileInputStream(contentFile)));
                while (!((ZipObjectReader)contentReader).getNextEntry().getName().equals(restoreRule.getSrcTableName())) {
                }
                contentLenFile = new File(storageDir, "dump-len.zip");
                contentLenReader = new ZipObjectReader(new ZipInputStream(new FileInputStream(contentLenFile)));
                while (!((ZipObjectReader)contentLenReader).getNextEntry().getName().equals(restoreRule.getSrcTableName())) {
                }
            }
            int sourceColumnCount = contentReader.readInt();
            ArrayList<Integer> columnType = new ArrayList<Integer>();
            ArrayList<String> columnName = new ArrayList<String>();
            for (int i = 0; i < sourceColumnCount; ++i) {
                columnType.add(contentReader.readInt());
                columnName.add(contentReader.readString());
            }
            int targetColumnCount = sourceColumnCount;
            if (restoreRule.getNewColumnIndex() != null) {
                ++targetColumnCount;
                columnType.add(restoreRule.getNewColumnIndex(), restoreRule.getNewColumnType());
                String newColumnName = this.dialect.startsWith("PGSQL") ? restoreRule.getNewColumnName().toLowerCase() : restoreRule.getNewColumnName();
                columnName.add(restoreRule.getNewColumnIndex(), newColumnName);
            }
            StringBuilder names = new StringBuilder();
            StringBuilder parameters = new StringBuilder();
            for (int i = 0; i < targetColumnCount; ++i) {
                if (restoreRule.getSkipColumnIndex() != null && restoreRule.getSkipColumnIndex() == i) continue;
                names.append((String)columnName.get(i)).append(i == targetColumnCount - 1 ? "" : ",");
                parameters.append("?").append(i == targetColumnCount - 1 ? "" : ",");
            }
            int batchSize = 0;
            insertNode = jdbcConn.prepareStatement("INSERT INTO " + tableName + " (" + String.valueOf(names) + ") VALUES(" + String.valueOf(parameters) + ")");
            block11: while (true) {
                int i = 0;
                int targetIndex = 0;
                while (i < columnType.size()) {
                    long len;
                    ByteArrayInputStream stream;
                    if (restoreRule.getNewColumnIndex() != null && restoreRule.getNewColumnIndex() == i) {
                        stream = new ByteArrayInputStream(restoreRule.getDstContainerName().getBytes("UTF-8"));
                        len = stream.available();
                    } else {
                        try {
                            len = contentLenReader.readLong();
                        }
                        catch (EOFException e) {
                            if (i == 0) {
                                try {
                                    contentReader.readByte();
                                }
                                catch (EOFException e1) {
                                    break block11;
                                }
                            }
                            throw new IOException("Content length file is empty but content still present", e);
                        }
                        InputStream inputStream = stream = len == -1L ? null : this.spoolInputStream(contentReader, len);
                    }
                    if (restoreRule.getSkipColumnIndex() != null && restoreRule.getSkipColumnIndex() == i) {
                        --targetIndex;
                    } else if (stream != null) {
                        byte[] readBuffer;
                        ByteArrayInputStream ba;
                        if (restoreRule.getConvertColumnIndex() != null && restoreRule.getConvertColumnIndex().contains(i)) {
                            ba = stream;
                            readBuffer = new byte[ba.available()];
                            ba.read(readBuffer);
                            String currentValue = new String(readBuffer, "UTF-8");
                            if (currentValue.equals(Constants.ROOT_PARENT_UUID)) {
                                stream = new ByteArrayInputStream(Constants.ROOT_PARENT_UUID.getBytes());
                            } else if (restoreRule.getDstMultiDb().booleanValue()) {
                                if (!restoreRule.getSrcMultiDb().booleanValue()) {
                                    stream = new ByteArrayInputStream(new String(readBuffer, "UTF-8").substring(restoreRule.getSrcContainerName().length()).getBytes());
                                }
                            } else if (restoreRule.getSrcMultiDb().booleanValue()) {
                                builder = new StringBuilder();
                                builder.append(restoreRule.getDstContainerName());
                                builder.append(currentValue);
                                stream = new ByteArrayInputStream(builder.toString().getBytes());
                            } else {
                                builder = new StringBuilder();
                                builder.append(restoreRule.getDstContainerName());
                                builder.append(new String(readBuffer, "UTF-8").substring(restoreRule.getSrcContainerName().length()));
                                stream = new ByteArrayInputStream(builder.toString().getBytes());
                            }
                            len = stream.available();
                        }
                        if ((Integer)columnType.get(i) == 4 || (Integer)columnType.get(i) == -5 || (Integer)columnType.get(i) == 5 || (Integer)columnType.get(i) == -6) {
                            ba = stream;
                            readBuffer = new byte[ba.available()];
                            ba.read(readBuffer);
                            value = new String(readBuffer, "UTF-8");
                            insertNode.setLong(targetIndex + 1, Integer.parseInt(value));
                        } else if ((Integer)columnType.get(i) == -7) {
                            ba = stream;
                            readBuffer = new byte[ba.available()];
                            ba.read(readBuffer);
                            value = new String(readBuffer);
                            if (this.dialect.startsWith("PGSQL")) {
                                insertNode.setBoolean(targetIndex + 1, value.equalsIgnoreCase("t"));
                            } else {
                                insertNode.setBoolean(targetIndex + 1, value.equals("1"));
                            }
                        } else if ((Integer)columnType.get(i) == 16) {
                            ba = stream;
                            readBuffer = new byte[ba.available()];
                            ba.read(readBuffer);
                            value = new String(readBuffer);
                            insertNode.setBoolean(targetIndex + 1, value.equalsIgnoreCase("true"));
                        } else if ((Integer)columnType.get(i) == -3 || (Integer)columnType.get(i) == -4 || (Integer)columnType.get(i) == 2004 || (Integer)columnType.get(i) == -2 || (Integer)columnType.get(i) == 1111) {
                            insertNode.setBinaryStream(targetIndex + 1, stream, (int)len);
                        } else {
                            byte[] readBuffer2 = new byte[(int)len];
                            stream.read(readBuffer2);
                            insertNode.setString(targetIndex + 1, new String(readBuffer2, "UTF-8"));
                        }
                    } else {
                        insertNode.setNull(targetIndex + 1, (Integer)columnType.get(i));
                    }
                    ++i;
                    ++targetIndex;
                }
                insertNode.addBatch();
                if (++batchSize != 1000) continue;
                insertNode.executeBatch();
                this.commitBatch();
                batchSize = 0;
            }
            if (batchSize != 0) {
                insertNode.executeBatch();
                this.commitBatch();
            }
            if (this.useSequence) {
                batchSize = 0;
                String update = "DROP SEQUENCE " + tableName + "_seq";
                stmt = jdbcConn.createStatement();
                if ((this.dialect.startsWith("MYSQL") || this.dialect.startsWith("MSSQL") || this.dialect.startsWith("SYBASE")) && tableName.equalsIgnoreCase(this.itemTableName)) {
                    boolean exist = this.checkEntry(jdbcConn, tableName + "_SEQ");
                    insertNode = exist ? jdbcConn.prepareStatement("UPDATE " + tableName + "_SEQ  SET  nextVal=?  where name='LAST_N_ORDER_NUM'") : jdbcConn.prepareStatement("INSERT INTO " + tableName + "_SEQ  (name, nextVal) VALUES ('LAST_N_ORDER_NUM', ?)");
                    insertNode.setInt(1, this.getStartValue(jdbcConn, tableName));
                    insertNode.executeUpdate();
                    ++batchSize;
                } else if ((this.dialect.startsWith("PGSQL") || this.dialect.startsWith("DB2") || this.dialect.startsWith("HSQLDB")) && tableName.equalsIgnoreCase(this.itemTableName)) {
                    stmt.execute(update);
                    update = "CREATE SEQUENCE " + tableName + "_seq  INCREMENT BY 1 MINVALUE -1 NO MAXVALUE  NO CYCLE START WITH " + (this.getStartValue(jdbcConn, tableName) + 1);
                    stmt.execute(update);
                    ++batchSize;
                } else if (this.dialect.startsWith("H2") && tableName.equalsIgnoreCase(this.itemTableName)) {
                    stmt.execute(update);
                    update = "CREATE SEQUENCE " + tableName + "_seq  INCREMENT BY 1 START WITH " + (this.getStartValue(jdbcConn, tableName) + 1);
                    stmt.execute(update);
                    ++batchSize;
                } else if (this.dialect.startsWith("ORACLE") && tableName.equalsIgnoreCase(this.itemTableName)) {
                    stmt.execute(update);
                    update = "CREATE SEQUENCE " + tableName + "_seq  INCREMENT BY 1 MINVALUE -1 NOMAXVALUE NOCACHE NOCYCLE START WITH " + (this.getStartValue(jdbcConn, tableName) + 1);
                    stmt.execute(update);
                    ++batchSize;
                }
                if (batchSize != 0) {
                    this.commitBatch();
                }
            }
        }
        finally {
            if (contentReader != null) {
                contentReader.close();
            }
            if (contentLenReader != null) {
                contentLenReader.close();
            }
            if (insertNode != null) {
                insertNode.close();
            }
            if (stmt != null) {
                stmt.close();
            }
            for (File file : this.spoolFileList) {
                if (file.delete()) continue;
                this.fileCleaner.addFile(file);
            }
            if (tableMetaData != null) {
                tableMetaData.close();
            }
        }
    }

    protected void commitBatch() throws SQLException {
        if (this.dialect.startsWith("SYBASE")) {
            this.jdbcConn.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream spoolInputStream(ObjectReader in, long contentLen) throws IOException {
        byte[] buffer = new byte[]{};
        long readLen = 0L;
        File sf = null;
        OutputStream sfout = null;
        try {
            while (true) {
                int needToRead = contentLen - readLen > 2048L ? 2048 : (int)(contentLen - readLen);
                byte[] tmpBuff = new byte[needToRead];
                if (needToRead == 0) break;
                in.readFully(tmpBuff);
                if (sfout != null) {
                    sfout.write(tmpBuff);
                } else if (readLen + (long)needToRead > (long)this.maxBufferSize && this.fileCleaner != null) {
                    sf = File.createTempFile("jcrvd", null, this.tempDir);
                    sfout = new FileOutputStream(sf);
                    sfout.write(buffer);
                    sfout.write(tmpBuff);
                    buffer = null;
                } else {
                    byte[] newBuffer = new byte[(int)(readLen + (long)needToRead)];
                    System.arraycopy(buffer, 0, newBuffer, 0, (int)readLen);
                    System.arraycopy(tmpBuff, 0, newBuffer, (int)readLen, needToRead);
                    buffer = newBuffer;
                }
                readLen += (long)needToRead;
            }
            if (buffer != null) {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(buffer);
                return byteArrayInputStream;
            }
            FileInputStream fileInputStream = new FileInputStream(sf);
            return fileInputStream;
        }
        finally {
            if (sfout != null) {
                sfout.close();
            }
            if (sf != null) {
                this.spoolFileList.add(sf);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getStartValue(Connection con, String table) {
        int n;
        ResultSet trs;
        Statement stmt;
        block6: {
            stmt = null;
            trs = null;
            String query = "select max(N_ORDER_NUM) from " + table;
            stmt = con.createStatement();
            trs = stmt.executeQuery(query);
            if (!trs.next() || trs.getInt(1) < 0) break block6;
            int n2 = trs.getInt(1);
            JDBCUtils.freeResources((ResultSet)trs, (Statement)stmt, null);
            return n2;
        }
        try {
            n = -1;
        }
        catch (SQLException e) {
            int n3;
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"SQLException occurred while calculate the sequence start value", (Throwable)e);
                }
                n3 = -1;
            }
            catch (Throwable throwable) {
                JDBCUtils.freeResources(trs, (Statement)stmt, null);
                throw throwable;
            }
            JDBCUtils.freeResources((ResultSet)trs, (Statement)stmt, null);
            return n3;
        }
        JDBCUtils.freeResources((ResultSet)trs, (Statement)stmt, null);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkEntry(Connection con, String table) {
        ResultSet trs;
        Statement stmt;
        block4: {
            boolean bl;
            stmt = null;
            trs = null;
            try {
                String query = "select count(*) from " + table + "  where name ='LAST_N_ORDER_NUM'";
                stmt = con.createStatement();
                trs = stmt.executeQuery(query);
                if (!trs.next() || trs.getInt(1) <= 0) break block4;
                bl = true;
            }
            catch (SQLException e) {
                block5: {
                    try {
                        if (!LOG.isDebugEnabled()) break block5;
                        LOG.debug((Object)("SQLException occurred while check the table " + table + "  entry "), (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        JDBCUtils.freeResources(trs, (Statement)stmt, null);
                        throw throwable;
                    }
                }
                JDBCUtils.freeResources((ResultSet)trs, (Statement)stmt, null);
            }
            JDBCUtils.freeResources((ResultSet)trs, (Statement)stmt, null);
            return bl;
        }
        JDBCUtils.freeResources((ResultSet)trs, (Statement)stmt, null);
        return false;
    }
}

