/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.backup.rdbms;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.exoplatform.services.jcr.impl.backup.BackupException;
import org.exoplatform.services.jcr.impl.backup.DataRestore;
import org.exoplatform.services.jcr.impl.util.io.DirectoryHelper;
import org.exoplatform.services.jcr.util.IdGenerator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class DirectoryRestore
implements DataRestore {
    protected static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.DirectoryRestorer");
    protected final List<File> dataDirs = new ArrayList<File>();
    protected final List<File> zipFiles = new ArrayList<File>();
    private final List<File> tmpDirs = new ArrayList<File>();
    protected final File tempDir = new File(System.getProperty("java.io.tmpdir"));
    private static final String PREFIX = "dr";

    public DirectoryRestore(List<File> dataDirs, List<File> zipFiles) {
        this.dataDirs.addAll(dataDirs);
        this.zipFiles.addAll(zipFiles);
    }

    public DirectoryRestore(File dataDir, File zipFile) {
        this.dataDirs.add(dataDir);
        this.zipFiles.add(zipFile);
    }

    @Override
    public void clean() throws BackupException {
        LOG.info((Object)"Start to clean old data from the storage");
        try {
            for (int i = 0; i < this.dataDirs.size(); ++i) {
                File dataDir = this.dataDirs.get(i);
                File tmpDir = new File(this.tempDir, PREFIX + IdGenerator.generate());
                tmpDir.mkdirs();
                this.tmpDirs.add(tmpDir);
                if (!dataDir.exists()) continue;
                DirectoryHelper.copyDirectory(dataDir, tmpDir);
                DirectoryHelper.removeDirectory(dataDir);
            }
        }
        catch (IOException e) {
            throw new BackupException(e);
        }
    }

    @Override
    public void restore() throws BackupException {
        try {
            for (int i = 0; i < this.zipFiles.size(); ++i) {
                File zipFile = this.zipFiles.get(i);
                File dataDir = this.dataDirs.get(i);
                if (zipFile.isDirectory()) {
                    DirectoryHelper.uncompressEveryFileFromDirectory(zipFile, dataDir);
                    continue;
                }
                DirectoryHelper.uncompressDirectory(zipFile, dataDir);
            }
        }
        catch (IOException e) {
            throw new BackupException(e);
        }
    }

    @Override
    public void commit() throws BackupException {
    }

    @Override
    public void rollback() throws BackupException {
        try {
            for (int i = 0; i < this.tmpDirs.size(); ++i) {
                File tmpDir = this.tmpDirs.get(i);
                File dataDir = this.dataDirs.get(i);
                if (dataDir.exists()) {
                    DirectoryHelper.removeDirectory(dataDir);
                }
                DirectoryHelper.copyDirectory(tmpDir, dataDir);
            }
        }
        catch (IOException e) {
            throw new BackupException(e);
        }
    }

    @Override
    public void close() throws BackupException {
        try {
            for (File tmpDir : this.tmpDirs) {
                DirectoryHelper.removeDirectory(tmpDir);
            }
        }
        catch (IOException e) {
            throw new BackupException(e);
        }
        this.dataDirs.clear();
        this.zipFiles.clear();
        this.tmpDirs.clear();
    }
}

