/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.backup.rdbms;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashSet;
import org.exoplatform.services.jcr.dataflow.serialization.ObjectReader;
import org.exoplatform.services.jcr.impl.backup.rdbms.TableTransformationRule;
import org.exoplatform.services.jcr.impl.dataflow.serialization.ObjectReaderImpl;
import org.exoplatform.services.jcr.impl.storage.jdbc.JDBCDataContainerConfig;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class TableTransformationRuleGenerator {
    protected static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.TableTransformationRuleGenerator");
    private final JDBCDataContainerConfig.DatabaseStructureType srcDbType;
    private final JDBCDataContainerConfig.DatabaseStructureType dstDbType;
    private final String srcContainerName;
    private final String dstContainerName;
    private final String srcItemTableName;
    private final String srcValueTableName;
    private final String srcRefTableName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableTransformationRuleGenerator(JDBCDataContainerConfig containerConfig, File storageDir) throws IOException {
        ObjectReader backupInfoReader = null;
        try {
            this.dstDbType = containerConfig.dbStructureType;
            this.dstContainerName = containerConfig.containerName;
            backupInfoReader = new ObjectReaderImpl(new FileInputStream(new File(storageDir, "JDBCWorkspaceDataContainer.info")));
            this.srcContainerName = backupInfoReader.readString();
            this.srcDbType = JDBCDataContainerConfig.DatabaseStructureType.valueOf(backupInfoReader.readString());
            this.srcItemTableName = backupInfoReader.readString();
            this.srcValueTableName = backupInfoReader.readString();
            this.srcRefTableName = backupInfoReader.readString();
        }
        finally {
            if (backupInfoReader != null) {
                try {
                    backupInfoReader.close();
                }
                catch (IOException e) {
                    LOG.error((Object)"Can't close object reader", (Throwable)e);
                }
            }
        }
    }

    private TableTransformationRule getBasicTransformationRule() {
        TableTransformationRule basicTableTransformationRule = new TableTransformationRule();
        basicTableTransformationRule.setSrcContainerName(this.srcContainerName);
        basicTableTransformationRule.setSrcMultiDb(this.srcDbType.isMultiDatabase());
        basicTableTransformationRule.setDstContainerName(this.dstContainerName);
        basicTableTransformationRule.setDstMultiDb(this.dstDbType.isMultiDatabase());
        return basicTableTransformationRule;
    }

    public TableTransformationRule getValueTableTransformationRule() {
        TableTransformationRule valueTableTransformationRule = this.getBasicTransformationRule();
        valueTableTransformationRule.setSrcTableName(this.srcValueTableName);
        valueTableTransformationRule.setSkipColumnIndex(0);
        if (this.srcDbType == JDBCDataContainerConfig.DatabaseStructureType.SINGLE || this.dstDbType == JDBCDataContainerConfig.DatabaseStructureType.SINGLE) {
            HashSet<Integer> convertColumnIndex = new HashSet<Integer>();
            convertColumnIndex.add(3);
            valueTableTransformationRule.setConvertColumnIndex(convertColumnIndex);
        }
        return valueTableTransformationRule;
    }

    public TableTransformationRule getRefTableTransformationRule() {
        TableTransformationRule refTableTransformationRule = this.getBasicTransformationRule();
        refTableTransformationRule.setSrcTableName(this.srcRefTableName);
        if (this.srcDbType == JDBCDataContainerConfig.DatabaseStructureType.SINGLE || this.dstDbType == JDBCDataContainerConfig.DatabaseStructureType.SINGLE) {
            HashSet<Integer> convertColumnIndex = new HashSet<Integer>();
            convertColumnIndex.add(0);
            convertColumnIndex.add(1);
            refTableTransformationRule.setConvertColumnIndex(convertColumnIndex);
        }
        return refTableTransformationRule;
    }

    public TableTransformationRule getItemTableTransformationRule() {
        TableTransformationRule itemTableTransformationRule = this.getBasicTransformationRule();
        itemTableTransformationRule.setSrcTableName(this.srcItemTableName);
        if (this.dstDbType == JDBCDataContainerConfig.DatabaseStructureType.MULTI || this.dstDbType == JDBCDataContainerConfig.DatabaseStructureType.ISOLATED) {
            if (this.srcDbType == JDBCDataContainerConfig.DatabaseStructureType.SINGLE) {
                itemTableTransformationRule.setSkipColumnIndex(4);
                HashSet<Integer> convertColumnIndex = new HashSet<Integer>();
                convertColumnIndex.add(0);
                convertColumnIndex.add(1);
                itemTableTransformationRule.setConvertColumnIndex(convertColumnIndex);
            }
        } else if (this.srcDbType == JDBCDataContainerConfig.DatabaseStructureType.MULTI || this.srcDbType == JDBCDataContainerConfig.DatabaseStructureType.ISOLATED) {
            itemTableTransformationRule.setNewColumnIndex(4);
            itemTableTransformationRule.setNewColumnName("CONTAINER_NAME");
            itemTableTransformationRule.setNewColumnType(12);
            HashSet<Integer> convertColumnIndex = new HashSet<Integer>();
            convertColumnIndex.add(0);
            convertColumnIndex.add(1);
            itemTableTransformationRule.setConvertColumnIndex(convertColumnIndex);
        } else {
            HashSet<Integer> convertColumnIndex = new HashSet<Integer>();
            convertColumnIndex.add(0);
            convertColumnIndex.add(1);
            convertColumnIndex.add(4);
            itemTableTransformationRule.setConvertColumnIndex(convertColumnIndex);
        }
        return itemTableTransformationRule;
    }
}

