/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.jcr.ItemNotFoundException;
import javax.jcr.NamespaceException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.LocationFactory;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.jcr.impl.core.PropertyImpl;
import org.exoplatform.services.jcr.impl.core.SessionDataManager;
import org.exoplatform.services.jcr.impl.core.query.lucene.ExcerptProvider;
import org.exoplatform.services.jcr.impl.core.query.lucene.HighlightingExcerptProvider;
import org.exoplatform.services.jcr.impl.core.query.lucene.ScoreNode;
import org.exoplatform.services.jcr.impl.core.query.lucene.ScoreNodeIterator;
import org.exoplatform.services.jcr.impl.core.query.lucene.SpellSuggestion;
import org.exoplatform.services.jcr.impl.core.value.ValueFactoryImpl;
import org.exoplatform.services.jcr.impl.util.ISO9075;
import org.exoplatform.services.jcr.impl.util.io.FileCleanerHolder;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

class RowIteratorImpl
implements RowIterator {
    private static final Log log = ExoLogger.getLogger((String)"exo.jcr.component.core.RowIteratorImpl");
    private static final String EXCERPT_FUNC_LPAR = "excerpt(";
    private static final String SPELLCHECK_FUNC_LPAR = "spellcheck(";
    private static final InternalQName REP_EXCERPT_LPAR = new InternalQName("internal", "excerpt(");
    private final ScoreNodeIterator scoreNodes;
    private final InternalQName[] properties;
    private Set<InternalQName> propertySet;
    private final List<InternalQName> selectorNames = new ArrayList<InternalQName>();
    private final SessionDataManager itemMgr;
    private final LocationFactory resolver;
    private final ExcerptProvider excerptProvider;
    private final SpellSuggestion spellSuggestion;
    private final ValueFactory valueFactory;

    RowIteratorImpl(ScoreNodeIterator scoreNodes, InternalQName[] properties, InternalQName[] selectorNames, SessionDataManager itemMgr, LocationFactory resolver, ExcerptProvider exProvider, SpellSuggestion spellSuggestion, FileCleanerHolder cleanerHolder) {
        this.scoreNodes = scoreNodes;
        this.properties = properties;
        this.selectorNames.addAll(Arrays.asList(selectorNames));
        this.itemMgr = itemMgr;
        this.resolver = resolver;
        this.excerptProvider = exProvider;
        this.spellSuggestion = spellSuggestion;
        this.valueFactory = new ValueFactoryImpl(resolver, cleanerHolder);
    }

    public Row nextRow() throws NoSuchElementException {
        return new RowImpl(this.scoreNodes.nextScoreNodes());
    }

    public void skip(long skipNum) throws NoSuchElementException {
        this.scoreNodes.skip(skipNum);
    }

    public long getSize() {
        return this.scoreNodes.getSize();
    }

    public long getPosition() {
        return this.scoreNodes.getPosition();
    }

    public void remove() {
        throw new UnsupportedOperationException("remove");
    }

    public boolean hasNext() {
        return this.scoreNodes.hasNext();
    }

    public Object next() throws NoSuchElementException {
        return this.nextRow();
    }

    class RowImpl
    implements Row {
        private final float score;
        private NodeImpl node;
        private final ScoreNode[] sn;
        private Value[] values;

        RowImpl(ScoreNode[] sn) {
            this.sn = sn;
            this.score = sn[0].getScore();
        }

        public Value[] getValues() throws RepositoryException {
            if (this.values == null) {
                Value[] tmp = new Value[RowIteratorImpl.this.properties.length];
                for (int i = 0; i < RowIteratorImpl.this.properties.length; ++i) {
                    String propertyName = RowIteratorImpl.this.resolver.createJCRName(RowIteratorImpl.this.properties[i]).getAsString();
                    this.node = (NodeImpl)this.getNode();
                    if (this.node.hasProperty(propertyName)) {
                        PropertyImpl prop = (PropertyImpl)this.node.getProperty(propertyName);
                        if (!prop.getDefinition().isMultiple()) {
                            if (prop.getDefinition().getRequiredType() == 0) {
                                tmp[i] = RowIteratorImpl.this.valueFactory.createValue(prop.getString());
                                continue;
                            }
                            tmp[i] = prop.getValue();
                            continue;
                        }
                        tmp[i] = null;
                        continue;
                    }
                    tmp[i] = Constants.JCR_PATH.equals((Object)RowIteratorImpl.this.properties[i]) ? RowIteratorImpl.this.valueFactory.createValue(this.node.getPath(), 8) : (Constants.JCR_SCORE.equals((Object)RowIteratorImpl.this.properties[i]) ? RowIteratorImpl.this.valueFactory.createValue((long)Math.round(this.score * 1000.0f)) : (this.isExcerptFunction(RowIteratorImpl.this.properties[i]) ? this.getExcerpt() : (this.isSpellCheckFunction(RowIteratorImpl.this.properties[i]) ? this.getSpellCheckedStatement() : null)));
                }
                this.values = tmp;
            }
            Value[] ret = new Value[this.values.length];
            System.arraycopy(this.values, 0, ret, 0, this.values.length);
            return ret;
        }

        public Value getValue(String propertyName) throws ItemNotFoundException, RepositoryException {
            if (RowIteratorImpl.this.propertySet == null) {
                HashSet<InternalQName> tmp = new HashSet<InternalQName>();
                tmp.addAll(Arrays.asList(RowIteratorImpl.this.properties));
                RowIteratorImpl.this.propertySet = tmp;
            }
            try {
                InternalQName prop = RowIteratorImpl.this.resolver.parseJCRName(propertyName).getInternalName();
                if (!RowIteratorImpl.this.propertySet.contains((Object)prop)) {
                    if (this.isExcerptFunction(propertyName)) {
                        return this.getExcerpt(propertyName);
                    }
                    throw new ItemNotFoundException(propertyName);
                }
                if (Constants.JCR_PATH.equals((Object)prop)) {
                    ItemData item = RowIteratorImpl.this.itemMgr.getItemData(this.sn[0].getNodeId());
                    if (item == null) {
                        throw new ItemNotFoundException(this.sn[0].getNodeId());
                    }
                    String path = RowIteratorImpl.this.resolver.createJCRPath(item.getQPath()).getAsString(false);
                    return RowIteratorImpl.this.valueFactory.createValue(path, 8);
                }
                if (this.getNodeImpl().hasProperty(propertyName)) {
                    Property p = this.getNodeImpl().getProperty(propertyName);
                    if (p.getDefinition().getRequiredType() == 0) {
                        return RowIteratorImpl.this.valueFactory.createValue(p.getString());
                    }
                    return p.getValue();
                }
                if (Constants.JCR_SCORE.equals((Object)prop)) {
                    return RowIteratorImpl.this.valueFactory.createValue((long)Math.round(this.score * 1000.0f));
                }
                if (this.isExcerptFunction(prop)) {
                    return this.getExcerpt();
                }
                if (this.isSpellCheckFunction(prop)) {
                    return this.getSpellCheckedStatement();
                }
                return null;
            }
            catch (RepositoryException e) {
                if (this.isExcerptFunction(propertyName)) {
                    return this.getExcerpt(propertyName);
                }
                throw new RepositoryException(e.getMessage(), (Throwable)e);
            }
        }

        public Node getNode() throws RepositoryException {
            this.checkSingleSelector("Use getNode(String) instead.");
            return this.getNodeImpl();
        }

        public Node getNode(String selectorName) throws RepositoryException {
            ScoreNode s = this.sn[this.getSelectorIndex(selectorName)];
            if (s == null) {
                return null;
            }
            return (Node)RowIteratorImpl.this.itemMgr.getItemByIdentifier(s.getNodeId(), true);
        }

        public String getPath() throws RepositoryException {
            this.checkSingleSelector("Use getPath(String) instead.");
            ItemData item = RowIteratorImpl.this.itemMgr.getItemData(this.sn[0].getNodeId());
            if (item == null) {
                throw new ItemNotFoundException("Item not found " + this.sn[0].getNodeId());
            }
            return RowIteratorImpl.this.resolver.createJCRPath(item.getQPath()).getAsString(false);
        }

        public String getPath(String selectorName) throws RepositoryException {
            Node n = this.getNode(selectorName);
            if (n != null) {
                return n.getPath();
            }
            return null;
        }

        public double getScore() throws RepositoryException {
            this.checkSingleSelector("Use getScore(String) instead.");
            return this.score;
        }

        public double getScore(String selectorName) throws RepositoryException {
            ScoreNode s = this.sn[this.getSelectorIndex(selectorName)];
            if (s == null) {
                return Double.NaN;
            }
            return s.getScore();
        }

        private NodeImpl getNodeImpl() throws RepositoryException {
            if (this.node == null) {
                this.node = (NodeImpl)RowIteratorImpl.this.itemMgr.getItemByIdentifier(this.sn[0].getNodeId(), true);
            }
            return this.node;
        }

        private void checkSingleSelector(String useInstead) throws RepositoryException {
            if (this.sn.length > 1) {
                String msg = "More than one selector. " + useInstead;
                throw new RepositoryException(msg);
            }
        }

        private int getSelectorIndex(String selectorName) throws RepositoryException {
            int idx = RowIteratorImpl.this.selectorNames.indexOf(RowIteratorImpl.this.resolver.parseJCRName(selectorName));
            if (idx == -1) {
                throw new RepositoryException("Unknown selector name: " + selectorName);
            }
            return idx;
        }

        private boolean isExcerptFunction(InternalQName name) {
            return name.getNamespace().equals("internal") && name.getName().startsWith(RowIteratorImpl.EXCERPT_FUNC_LPAR);
        }

        private boolean isExcerptFunction(String name) {
            try {
                return name.startsWith(RowIteratorImpl.this.resolver.createJCRName(REP_EXCERPT_LPAR).getAsString());
            }
            catch (NamespaceException e) {
                return false;
            }
            catch (RepositoryException e) {
                log.error((Object)e.getLocalizedMessage(), (Throwable)e);
                return false;
            }
        }

        private Value getExcerpt() {
            return this.createExcerpt(this.sn[0].getNodeId());
        }

        private Value getExcerpt(String excerptCall) throws RepositoryException {
            int idx = excerptCall.indexOf(RowIteratorImpl.EXCERPT_FUNC_LPAR);
            int end = excerptCall.lastIndexOf(41);
            if (end == -1) {
                throw new RepositoryException("Missing right parenthesis");
            }
            String pathStr = excerptCall.substring(idx + RowIteratorImpl.EXCERPT_FUNC_LPAR.length(), end).trim();
            String decodedPath = ISO9075.decode(pathStr);
            try {
                NodeImpl n = (NodeImpl)this.getNodeImpl().getNode(decodedPath);
                return this.createExcerpt(n.getData().getIdentifier());
            }
            catch (PathNotFoundException e) {
                try {
                    Property p = this.getNode().getProperty(decodedPath);
                    return this.highlight(p.getValue().getString());
                }
                catch (PathNotFoundException e1) {
                    return null;
                }
            }
        }

        private Value createExcerpt(String id) {
            if (RowIteratorImpl.this.excerptProvider == null) {
                return null;
            }
            try {
                long time = 0L;
                if (log.isDebugEnabled()) {
                    time = System.currentTimeMillis();
                }
                String excerpt = RowIteratorImpl.this.excerptProvider.getExcerpt(id, 3, 150);
                if (log.isDebugEnabled()) {
                    time = System.currentTimeMillis() - time;
                    log.debug("Created excerpt in {} ms.", new Object[]{new Long(time)});
                }
                if (excerpt != null) {
                    return RowIteratorImpl.this.valueFactory.createValue(excerpt);
                }
                return null;
            }
            catch (IOException e) {
                return null;
            }
        }

        private Value highlight(String text) {
            if (!(RowIteratorImpl.this.excerptProvider instanceof HighlightingExcerptProvider)) {
                return null;
            }
            HighlightingExcerptProvider hep = (HighlightingExcerptProvider)RowIteratorImpl.this.excerptProvider;
            try {
                long time = 0L;
                if (log.isDebugEnabled()) {
                    time = System.currentTimeMillis();
                }
                text = hep.highlight(text);
                if (log.isDebugEnabled()) {
                    time = System.currentTimeMillis() - time;
                    log.debug("Highlighted text in {} ms.", new Object[]{new Long(time)});
                }
                return RowIteratorImpl.this.valueFactory.createValue(text);
            }
            catch (IOException e) {
                return null;
            }
        }

        private boolean isSpellCheckFunction(InternalQName name) {
            return name.getNamespace().equals("internal") && name.getName().startsWith(RowIteratorImpl.SPELLCHECK_FUNC_LPAR);
        }

        private Value getSpellCheckedStatement() {
            String v = null;
            if (RowIteratorImpl.this.spellSuggestion != null) {
                try {
                    v = RowIteratorImpl.this.spellSuggestion.getSuggestion();
                }
                catch (IOException e) {
                    log.warn((Object)"Spell checking failed", (Throwable)e);
                }
                catch (RepositoryException e) {
                    log.warn((Object)"Spell checking failed", (Throwable)e);
                }
            }
            if (v != null) {
                return RowIteratorImpl.this.valueFactory.createValue(v);
            }
            return null;
        }
    }
}

