/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene.directory;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.FSLockFactory;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.NativeFSLockFactory;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.services.jcr.impl.core.query.lucene.SearchIndex;
import org.exoplatform.services.jcr.impl.core.query.lucene.directory.DirectoryManager;
import org.exoplatform.services.jcr.impl.util.io.DirectoryHelper;

public class FSDirectoryManager
implements DirectoryManager {
    private static Class<? extends FSDirectory> FS_DIRECTORY_CLASS;
    private static Class<? extends LockFactory> LOCK_FACTORY_CLASS;
    private File baseDir;

    @Override
    public void init(SearchIndex handler) throws IOException {
        this.baseDir = new File(handler.getPath());
    }

    @Override
    public void init(String path) throws IOException {
        this.baseDir = new File(path);
    }

    @Override
    public boolean hasDirectory(String name) throws IOException {
        return new File(this.baseDir, name).exists();
    }

    @Override
    public Directory getDirectory(String name) throws IOException {
        File dir = name.equals(".") ? this.baseDir : new File(this.baseDir, name);
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IOException("Cannot create directory: " + String.valueOf(dir));
        }
        try {
            NativeFSLockFactory lockFactory;
            Object object = lockFactory = LOCK_FACTORY_CLASS == null ? new NativeFSLockFactory() : LOCK_FACTORY_CLASS.newInstance();
            if (FS_DIRECTORY_CLASS == null) {
                return FSDirectory.open((File)dir, (LockFactory)lockFactory);
            }
            Constructor<? extends FSDirectory> constructor = FS_DIRECTORY_CLASS.getConstructor(File.class, LockFactory.class);
            return (Directory)constructor.newInstance(dir, lockFactory);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IOException("Cannot create directory: " + String.valueOf(dir));
        }
    }

    @Override
    public String[] getDirectoryNames() throws IOException {
        File[] dirs = this.baseDir.listFiles(new FileFilter(this){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        });
        if (dirs != null) {
            String[] names = new String[dirs.length];
            for (int i = 0; i < dirs.length; ++i) {
                names[i] = dirs[i].getName();
            }
            return names;
        }
        throw new IOException("listFiles for " + this.baseDir.getPath() + " returned null");
    }

    @Override
    public boolean delete(String name) {
        File directory = new File(this.baseDir, name);
        if (!directory.exists()) {
            return true;
        }
        File[] files = directory.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                if (files[i].delete()) continue;
                return false;
            }
        } else {
            return false;
        }
        return directory.delete();
    }

    @Override
    public boolean rename(String from, String to) {
        File src = new File(this.baseDir, from);
        File dest = new File(this.baseDir, to);
        try {
            DirectoryHelper.renameFile(src, dest);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    @Override
    public void dispose() {
    }

    static {
        String lockFactoryClassName = PropertyManager.getProperty((String)"org.exoplatform.jcr.lucene.store.FSDirectoryLockFactoryClass");
        String fsDirectoryClassName = PropertyManager.getProperty((String)"org.exoplatform.jcr.lucene.FSDirectory.class");
        if (lockFactoryClassName != null) {
            try {
                if (!FSLockFactory.class.getName().equals(lockFactoryClassName)) {
                    LOCK_FACTORY_CLASS = Class.forName(lockFactoryClassName);
                }
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("cannot load LockFactory class: " + e.toString(), e);
            }
        }
        if (fsDirectoryClassName != null) {
            try {
                if (!FSDirectory.class.getName().equals(fsDirectoryClassName)) {
                    FS_DIRECTORY_CLASS = Class.forName(fsDirectoryClassName);
                }
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("cannot load FSDirectory class: " + e.toString(), e);
            }
        }
    }
}

