/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.quota;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.exoplatform.services.jcr.impl.backup.BackupException;
import org.exoplatform.services.jcr.impl.backup.DataRestore;
import org.exoplatform.services.jcr.impl.backup.rdbms.DataRestoreContext;
import org.exoplatform.services.jcr.impl.dataflow.serialization.ObjectReaderImpl;
import org.exoplatform.services.jcr.impl.dataflow.serialization.ObjectWriterImpl;
import org.exoplatform.services.jcr.impl.dataflow.serialization.ZipObjectReader;
import org.exoplatform.services.jcr.impl.dataflow.serialization.ZipObjectWriter;
import org.exoplatform.services.jcr.impl.quota.ApplyPersistedChangesTask;
import org.exoplatform.services.jcr.impl.quota.ChangesItem;
import org.exoplatform.services.jcr.impl.quota.QuotaPersister;
import org.exoplatform.services.jcr.impl.quota.UnknownDataSizeException;
import org.exoplatform.services.jcr.impl.quota.WorkspaceQuotaManager;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class WorkspaceQuotaRestore
implements DataRestore {
    protected final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.WorkspaceQuotaRestore");
    protected static final String BACKUP_FILE_NAME = "quota";
    private final File tempFile;
    private final File backupFile;
    private final WorkspaceQuotaManager wqm;
    private final String wsName;
    private final String rName;
    private final QuotaPersister quotaPersister;

    WorkspaceQuotaRestore(WorkspaceQuotaManager wqm, DataRestoreContext context) {
        this(wqm, (File)context.getObject("storage-dir"));
    }

    WorkspaceQuotaRestore(WorkspaceQuotaManager wqm, File storageDir) {
        this.wqm = wqm;
        this.backupFile = new File(storageDir, "quota.dump");
        File tempDir = new File(System.getProperty("java.io.tmpdir"));
        this.tempFile = new File(tempDir, "temp.dump");
        this.wsName = wqm.getContext().wsName;
        this.rName = wqm.getContext().rName;
        this.quotaPersister = wqm.getContext().quotaPersister;
    }

    @Override
    public void clean() throws BackupException {
        this.doBackup(this.tempFile);
        this.doClean();
    }

    @Override
    public void restore() throws BackupException {
        this.doRestore(this.backupFile);
    }

    @Override
    public void commit() throws BackupException {
    }

    @Override
    public void rollback() throws BackupException {
        this.doClean();
        this.doRestore(this.tempFile);
    }

    @Override
    public void close() throws BackupException {
        this.tempFile.delete();
    }

    public void backup() throws BackupException {
        this.doBackup(this.backupFile);
    }

    protected void doRestore(File backupFile) throws BackupException {
        if (!backupFile.exists()) {
            this.LOG.warn((Object)"Nothing to restore for quotas");
            return;
        }
        ObjectReaderImpl in = null;
        try {
            in = new ZipObjectReader(new ZipInputStream(new FileInputStream(backupFile)));
            this.quotaPersister.restoreWorkspaceData(this.rName, this.wsName, (ZipObjectReader)in);
        }
        catch (IOException e) {
            throw new BackupException(e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    this.LOG.error((Object)"Can't close input stream", (Throwable)e);
                }
            }
        }
        this.repairDataSize();
    }

    private void repairDataSize() {
        block2: {
            try {
                long dataSize = this.quotaPersister.getWorkspaceDataSize(this.rName, this.wsName);
                ChangesItem changesItem = new ChangesItem();
                changesItem.updateWorkspaceChangedSize(dataSize);
                this.quotaPersister.setWorkspaceDataSize(this.rName, this.wsName, 0L);
                ApplyPersistedChangesTask task = new ApplyPersistedChangesTask(this.wqm.getContext(), changesItem);
                task.run();
            }
            catch (UnknownDataSizeException e) {
                if (!this.LOG.isTraceEnabled()) break block2;
                this.LOG.trace((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    protected void doBackup(File backupFile) throws BackupException {
        ObjectWriterImpl out = null;
        try {
            out = new ZipObjectWriter(new ZipOutputStream(new FileOutputStream(backupFile)));
            this.quotaPersister.backupWorkspaceData(this.rName, this.wsName, (ZipObjectWriter)out);
        }
        catch (IOException e) {
            throw new BackupException(e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    this.LOG.error((Object)"Can't close output stream", (Throwable)e);
                }
            }
        }
    }

    protected void doClean() throws BackupException {
        block2: {
            try {
                long dataSize = this.wqm.quotaPersister.getWorkspaceDataSize(this.rName, this.wsName);
                ChangesItem changesItem = new ChangesItem();
                changesItem.updateWorkspaceChangedSize(-dataSize);
                ApplyPersistedChangesTask task = new ApplyPersistedChangesTask(this.wqm.getContext(), changesItem);
                task.run();
            }
            catch (UnknownDataSizeException e) {
                if (!this.LOG.isTraceEnabled()) break block2;
                this.LOG.trace((Object)e.getMessage(), (Throwable)e);
            }
        }
        this.quotaPersister.clearWorkspaceData(this.wqm.rName, this.wqm.wsName);
    }
}

