/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.agenda.listener;

import org.exoplatform.agenda.constant.EventAttendeeResponse;
import org.exoplatform.agenda.constant.EventStatus;
import org.exoplatform.agenda.model.EventAttendee;
import org.exoplatform.agenda.service.AgendaEventService;
import org.exoplatform.agenda.util.NotificationUtils;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.listener.Asynchronous;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;

@Asynchronous
public class AgendaEventReplyListener
extends Listener<EventAttendee, EventAttendee> {
    private AgendaEventService agendaEventService;
    private ExoContainer container;

    public AgendaEventReplyListener(ExoContainer container) {
        this.container = container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(Event<EventAttendee, EventAttendee> event) throws Exception {
        ExoContainerContext.setCurrentContainer((ExoContainer)this.container);
        RequestLifeCycle.begin((ExoContainer)this.container);
        try {
            EventAttendeeResponse newResponse;
            EventAttendee oldAttendee = (EventAttendee)event.getSource();
            EventAttendee newAttendee = (EventAttendee)event.getData();
            org.exoplatform.agenda.model.Event agendaEvent = this.getAgendaEventService().getEventById(newAttendee.getEventId());
            if (agendaEvent.getStatus() != EventStatus.CONFIRMED || newAttendee.getResponse() == EventAttendeeResponse.NEEDS_ACTION) {
                return;
            }
            EventAttendeeResponse oldResponse = oldAttendee == null ? null : oldAttendee.getResponse();
            if (oldResponse != (newResponse = newAttendee.getResponse())) {
                this.sendReplyResponseNotification(agendaEvent, newAttendee);
            }
        }
        finally {
            RequestLifeCycle.end();
        }
    }

    public AgendaEventService getAgendaEventService() {
        if (this.agendaEventService == null) {
            this.agendaEventService = (AgendaEventService)ExoContainerContext.getService(AgendaEventService.class);
        }
        return this.agendaEventService;
    }

    public void sendReplyResponseNotification(org.exoplatform.agenda.model.Event event, EventAttendee eventAttendee) {
        NotificationContext ctx = NotificationContextImpl.cloneInstance();
        ctx.append(NotificationUtils.EVENT_AGENDA, (Object)event);
        ctx.append(NotificationUtils.EVENT_PARTICIPANT_ID, (Object)eventAttendee.getIdentityId());
        ctx.append(NotificationUtils.EVENT_RESPONSE, (Object)eventAttendee.getResponse());
        if (eventAttendee.getFromOccurrenceId() != null) {
            ctx.append(NotificationUtils.EVENT_OCCURRENCE_ID, (Object)eventAttendee.getFromOccurrenceId());
        }
        ctx.getNotificationExecutor().with(ctx.makeCommand(PluginKey.key((String)"EventReplyNotificationPlugin"))).execute(ctx);
    }
}

