/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.agenda.notification.pwa;

import io.meeds.pwa.model.PwaNotificationMessage;
import io.meeds.pwa.plugin.PwaNotificationPlugin;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.resources.LocaleConfig;
import org.exoplatform.services.resources.ResourceBundleService;

public class EventReplyNotificationPwaPlugin
implements PwaNotificationPlugin {
    private static final Log LOG = ExoLogger.getLogger(EventReplyNotificationPwaPlugin.class);
    private String notificationId = "EventReplyNotificationPlugin";
    private static final String TITLE_LABEL_KEY = "pwa.notification.EventReplyNotificationPwaPlugin.title";
    private ResourceBundleService resourceBundleService;

    public EventReplyNotificationPwaPlugin(ResourceBundleService resourceBundleService) {
        this.resourceBundleService = resourceBundleService;
    }

    public String getId() {
        return this.notificationId;
    }

    public PwaNotificationMessage process(NotificationInfo notification, LocaleConfig localeConfig) {
        String status;
        PwaNotificationMessage notificationMessage = new PwaNotificationMessage();
        Object key = TITLE_LABEL_KEY;
        key = "true".equals(notification.getValueOwnerParameter("isCreator")) ? (String)key + ".creator" : (String)key + ".participant";
        key = (String)key + ".response";
        switch (status = notification.getValueOwnerParameter("eventResponse")) {
            case "ACCEPTED": {
                key = (String)key + ".accepted";
                break;
            }
            case "DECLINED": {
                key = (String)key + ".declined";
                break;
            }
            default: {
                key = (String)key + ".mayBe";
            }
        }
        String title = this.resourceBundleService.getSharedString((String)key, localeConfig.getLocale()).replace("{0}", notification.getValueOwnerParameter("participantName"));
        notificationMessage.setTitle(title);
        notificationMessage.setBody(notification.getValueOwnerParameter("eventTitle"));
        String url = notification.getValueOwnerParameter("Url").replace(CommonsUtils.getCurrentDomain(), "");
        notificationMessage.setUrl(url);
        return notificationMessage;
    }
}

