/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.agenda.search;

import io.meeds.social.html.model.HtmlTransformerContext;
import io.meeds.social.html.utils.HtmlUtils;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.agenda.model.Calendar;
import org.exoplatform.agenda.model.Event;
import org.exoplatform.agenda.model.EventAttendee;
import org.exoplatform.agenda.service.AgendaCalendarService;
import org.exoplatform.agenda.service.AgendaEventAttendeeService;
import org.exoplatform.agenda.service.AgendaEventService;
import org.exoplatform.agenda.util.AgendaDateUtils;
import org.exoplatform.commons.search.domain.Document;
import org.exoplatform.commons.search.index.impl.ElasticIndexingServiceConnector;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class AgendaIndexingServiceConnector
extends ElasticIndexingServiceConnector {
    public static final String INDEX = "event";
    private static final Log LOG = ExoLogger.getLogger(AgendaIndexingServiceConnector.class);
    private static final HtmlTransformerContext HTML_TRANSFORMER_CONTEXT = new HtmlTransformerContext(true, null);
    private final AgendaCalendarService agendaCalendarService;
    private final AgendaEventService agendaEventService;
    private AgendaEventAttendeeService attendeeService;

    public AgendaIndexingServiceConnector(AgendaCalendarService agendaCalendarService, AgendaEventService agendaEventService, AgendaEventAttendeeService attendeeService, InitParams initParams) {
        super(initParams);
        this.agendaCalendarService = agendaCalendarService;
        this.agendaEventService = agendaEventService;
        this.attendeeService = attendeeService;
    }

    public Document create(String id) {
        return this.getDocument(id);
    }

    public Document update(String id) {
        return this.getDocument(id);
    }

    public List<String> getAllIds(int offset, int limit) {
        throw new UnsupportedOperationException();
    }

    public String getConnectorName() {
        return INDEX;
    }

    private Document getDocument(String id) {
        String description;
        ZonedDateTime end;
        ZonedDateTime start;
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new IllegalArgumentException("id is mandatory");
        }
        LOG.debug("Index document for agenda id={}", new Object[]{id});
        Event event = this.agendaEventService.getEventById(Long.parseLong(id));
        if (event == null) {
            throw new IllegalStateException("event with id '" + id + "' not found");
        }
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put("id", Long.toString(event.getId()));
        List eventAttendees = this.attendeeService.getEventAttendees(event.getId()).getEventAttendees().stream().map(EventAttendee::getIdentityId).distinct().collect(Collectors.toList());
        if (event.getParentId() > 0L) {
            fields.put("parentId", Long.toString(event.getParentId()));
        }
        long calendarId = event.getCalendarId();
        fields.put("calendarId", String.valueOf(calendarId));
        Calendar calendar = this.agendaCalendarService.getCalendarById(calendarId);
        long ownerIdentityId = calendar.getOwnerId();
        fields.put("ownerId", String.valueOf(ownerIdentityId));
        if (event.getOccurrence() != null) {
            fields.put("occurrenceId", this.toMilliSecondsString(event.getOccurrence().getId()));
        }
        if ((start = event.getStart()) != null) {
            fields.put("startTime", this.toMilliSecondsString(start));
        }
        if ((end = event.getEnd()) != null) {
            fields.put("endTime", this.toMilliSecondsString(end));
        }
        if (StringUtils.isNotEmpty((CharSequence)event.getLocation())) {
            fields.put("location", event.getLocation());
        }
        String summary = null;
        if (StringUtils.isNotBlank((CharSequence)event.getSummary())) {
            summary = event.getSummary();
            fields.put("summary", summary);
        }
        if (event.getStatus() != null) {
            fields.put("status", event.getStatus().name());
        }
        if (StringUtils.isNotBlank((CharSequence)(description = event.getDescription()))) {
            description = HtmlUtils.transform((String)description, (HtmlTransformerContext)HTML_TRANSFORMER_CONTEXT);
            fields.put("description", description);
        }
        Set eventPermissionIds = eventAttendees.stream().map(String::valueOf).collect(Collectors.toSet());
        eventPermissionIds.add(String.valueOf(ownerIdentityId));
        ZonedDateTime lastUpdateDateTime = event.getUpdated() == null ? event.getCreated() : event.getUpdated();
        return new Document(id, null, AgendaDateUtils.toDate(lastUpdateDateTime), eventPermissionIds, fields);
    }

    private String toMilliSecondsString(ZonedDateTime dateTime) {
        return String.valueOf(dateTime.withZoneSameInstant(ZoneOffset.UTC).toInstant().toEpochMilli());
    }
}

