/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.agenda.storage;

import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.agenda.dao.CalendarDAO;
import org.exoplatform.agenda.dao.EventDAO;
import org.exoplatform.agenda.dao.EventRecurrenceDAO;
import org.exoplatform.agenda.entity.CalendarEntity;
import org.exoplatform.agenda.entity.EventEntity;
import org.exoplatform.agenda.entity.EventRecurrenceEntity;
import org.exoplatform.agenda.model.Event;
import org.exoplatform.agenda.model.EventFilter;
import org.exoplatform.agenda.model.EventRecurrence;
import org.exoplatform.agenda.storage.AgendaEventStorage$AjcClosure1;
import org.exoplatform.agenda.storage.AgendaEventStorage$AjcClosure3;
import org.exoplatform.agenda.util.AgendaDateUtils;
import org.exoplatform.agenda.util.EntityMapper;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.persistence.impl.ExoTransactionalAspect;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class AgendaEventStorage {
    private static final Log LOG;
    private static final int DEFAULT_LIMIT = 200;
    private CalendarDAO calendarDAO;
    private EventDAO eventDAO;
    private EventRecurrenceDAO eventRecurrenceDAO;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    public AgendaEventStorage(CalendarDAO calendarDAO, EventDAO eventDAO, EventRecurrenceDAO eventRecurrenceDAO) {
        this.calendarDAO = calendarDAO;
        this.eventDAO = eventDAO;
        this.eventRecurrenceDAO = eventRecurrenceDAO;
    }

    public List<Long> getEventIds(EventFilter eventFilter) {
        ZonedDateTime start = eventFilter.getStart();
        ZonedDateTime end = eventFilter.getEnd();
        Date startDate = new Date(start.withSecond(0).withNano(0).toEpochSecond() * 1000L);
        Date endDate = end == null ? null : new Date(end.withSecond(59).withNano(999999999).toEpochSecond() * 1000L);
        List attendeeIds = eventFilter.getAttendeeId() > 0L ? eventFilter.getAttendeeWithSpacesIds() : null;
        List ownerIds = eventFilter.getOwnerIds();
        List responseTypes = eventFilter.getResponseTypes();
        int limit = eventFilter.getEnd() == null ? 200 : 0;
        return this.eventDAO.getEventIds(startDate, endDate, ownerIds, attendeeIds, responseTypes, limit);
    }

    public List<Long> getPendingEventIds(Long userIdentityId, List<Long> ownerIds, List<Long> attendeeIds, List<Long> calenderIds, int offset, int limit) {
        Date now = this.getNowDate();
        if (ownerIds == null || ownerIds.isEmpty()) {
            return this.eventDAO.getPendingEventIds(userIdentityId, attendeeIds, calenderIds, now, offset, limit);
        }
        return this.eventDAO.getPendingEventIdsByOwnerIds(userIdentityId, ownerIds, attendeeIds, now, offset, limit);
    }

    public long countPendingEvents(Long userIdentityId, List<Long> ownerIds, List<Long> attendeeIds, List<Long> calenderIds) {
        Date now = this.getNowDate();
        if (ownerIds == null || ownerIds.isEmpty()) {
            return this.eventDAO.countPendingEvents(userIdentityId, attendeeIds, calenderIds, now);
        }
        return this.eventDAO.countPendingEventsByOwnerIds(userIdentityId, ownerIds, attendeeIds, now);
    }

    public List<Long> getUserEventCalenderIds(Long userIdentityId) {
        return this.eventDAO.getUserEventCalenderIds(userIdentityId);
    }

    public List<Long> getEventDatePollIds(Long userIdentityId, List<Long> ownerIds, List<Long> attendeeIds, int offset, int limit) {
        Date now = this.getNowDate();
        if (ownerIds == null || ownerIds.isEmpty()) {
            return this.eventDAO.getEventDatePollIds(userIdentityId, attendeeIds, now, offset, limit);
        }
        return this.eventDAO.getEventDatePollIdsByOwnerIds(userIdentityId, ownerIds, attendeeIds, now, offset, limit);
    }

    public List<Long> getEventDatePollIds(long userIdentityId, List<Long> ownerIds, List<Long> attendeeIds, ZonedDateTime start, ZonedDateTime end) {
        Date startDate = AgendaDateUtils.toDate(start);
        Date endDate = AgendaDateUtils.toDate(end);
        if (ownerIds == null || ownerIds.isEmpty()) {
            return this.eventDAO.getEventDatePollIds(userIdentityId, attendeeIds, startDate, endDate);
        }
        return this.eventDAO.getEventDatePollIdsByOwnerIds(userIdentityId, ownerIds, attendeeIds, startDate, endDate);
    }

    public long countEventDatePolls(List<Long> ownerIds, List<Long> attendeeIds) {
        Date now = this.getNowDate();
        if (ownerIds == null || ownerIds.isEmpty()) {
            return this.eventDAO.countEventDatePolls(attendeeIds, now);
        }
        return this.eventDAO.countEventDatePollsByOwnerIds(ownerIds, attendeeIds, now);
    }

    public List<Event> getParentRecurrentEventIds(ZonedDateTime start, ZonedDateTime end) {
        Date startDate = new Date(start.withSecond(0).withNano(0).toEpochSecond() * 1000L);
        Date endDate = new Date(end.withSecond(59).toEpochSecond() * 1000L);
        List<EventEntity> events = this.eventDAO.getParentRecurrentEventIds(startDate, endDate);
        return events.stream().map(EntityMapper::fromEntity).collect(Collectors.toList());
    }

    public Event getEventById(long eventId) {
        EventEntity eventEntity = (EventEntity)this.eventDAO.find(Long.valueOf(eventId));
        if (eventEntity == null) {
            return null;
        }
        return EntityMapper.fromEntity(eventEntity);
    }

    @ExoTransactional
    public void deleteEventById(long eventId) {
        long l = eventId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)Conversions.longObject((long)l));
        Object[] objectArray = new Object[]{this, Conversions.longObject((long)l), joinPoint};
        AgendaEventStorage$AjcClosure1 agendaEventStorage$AjcClosure1 = new AgendaEventStorage$AjcClosure1(objectArray);
        ExoTransactionalAspect.aspectOf().around(agendaEventStorage$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    public void deleteCalendarEvents(long calendarId) {
        long l = calendarId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)Conversions.longObject((long)l));
        Object[] objectArray = new Object[]{this, Conversions.longObject((long)l), joinPoint};
        AgendaEventStorage$AjcClosure3 agendaEventStorage$AjcClosure3 = new AgendaEventStorage$AjcClosure3(objectArray);
        ExoTransactionalAspect.aspectOf().around(agendaEventStorage$AjcClosure3.linkClosureAndJoinPoint(69648));
    }

    public List<Long> getExceptionalOccurenceIds(long parentRecurrentEventId) {
        return this.eventDAO.getExceptionalOccurenceIds(parentRecurrentEventId);
    }

    public List<Long> getExceptionalOccurenceIdsByPeriod(long parentRecurrentEventId, ZonedDateTime start, ZonedDateTime end) {
        return this.eventDAO.getExceptionalOccurenceIdsByPeriod(parentRecurrentEventId, AgendaDateUtils.toDate(start), AgendaDateUtils.toDate(end));
    }

    public List<Long> getExceptionalOccurenceIds(long parentRecurrentEventId, ZonedDateTime occurrenceId) {
        return this.eventDAO.getExceptionalOccurenceIdsByStart(parentRecurrentEventId, AgendaDateUtils.toDate(occurrenceId));
    }

    public Event createEvent(Event event) {
        EventEntity eventEntity = EntityMapper.toEntity(event);
        eventEntity.setId(null);
        if (event.getParentId() > 0L) {
            EventEntity parentEvent = (EventEntity)this.eventDAO.find(Long.valueOf(event.getParentId()));
            eventEntity.setParent(parentEvent);
        }
        this.updateEventCalendar(event, eventEntity);
        eventEntity = this.eventDAO.create(eventEntity);
        this.createEventRecurrence(event, eventEntity);
        return EntityMapper.fromEntity(eventEntity);
    }

    public List<Long> deleteExceptionalOccurences(long parentRecurrentEventId) {
        List<Long> deletedEventIds = this.eventDAO.getExceptionalOccurenceIds(parentRecurrentEventId);
        this.eventDAO.deleteExceptionalOccurences(parentRecurrentEventId);
        return deletedEventIds;
    }

    public Event getExceptionalOccurrenceEvent(long parentRecurrentEventId, ZonedDateTime occurrenceId) {
        ZonedDateTime start = occurrenceId.withZoneSameInstant(ZoneOffset.UTC).toLocalDate().atStartOfDay(ZoneOffset.UTC);
        ZonedDateTime end = occurrenceId.withZoneSameInstant(ZoneOffset.UTC).toLocalDate().atStartOfDay(ZoneOffset.UTC).plusDays(1L).minusSeconds(1L);
        List<Long> exceptionalOccurenceEventIds = this.eventDAO.getExceptionalOccurenceIdsByPeriod(parentRecurrentEventId, AgendaDateUtils.toDate(start), AgendaDateUtils.toDate(end));
        if (exceptionalOccurenceEventIds == null || exceptionalOccurenceEventIds.isEmpty()) {
            return null;
        }
        if (exceptionalOccurenceEventIds.size() > 1) {
            LOG.warn("More than one exceptional event on parent event {} is found for occurrence of day {}. Occurrence ids found: {}", new Object[]{parentRecurrentEventId, occurrenceId, StringUtils.join(exceptionalOccurenceEventIds, (String)",")});
        }
        return this.getEventById(exceptionalOccurenceEventIds.get(0));
    }

    public Event updateEvent(Event event) {
        EventEntity eventEntity = EntityMapper.toEntity(event);
        this.updateEventParent(event, eventEntity);
        this.updateEventCalendar(event, eventEntity);
        this.updateEventRecurrence(event, eventEntity);
        eventEntity = this.eventDAO.update(eventEntity);
        eventEntity = (EventEntity)this.eventDAO.find(eventEntity.getId());
        return EntityMapper.fromEntity(eventEntity);
    }

    public boolean isRecurrentEvent(long eventId) {
        Event event = this.getEventById(eventId);
        if (event == null) {
            return false;
        }
        return event.getRecurrence() != null;
    }

    private void updateEventCalendar(Event event, EventEntity eventEntity) {
        CalendarEntity calendarEntity = (CalendarEntity)this.calendarDAO.find(Long.valueOf(event.getCalendarId()));
        eventEntity.setCalendar(calendarEntity);
    }

    private void updateEventParent(Event event, EventEntity eventEntity) {
        if (event.getParentId() > 0L) {
            EventEntity parentEvent = (EventEntity)this.eventDAO.find(Long.valueOf(event.getParentId()));
            if (parentEvent == null) {
                throw new IllegalStateException("Can't find parent event with id " + event.getParentId());
            }
            eventEntity.setParent(parentEvent);
        }
    }

    private void updateEventRecurrence(Event event, EventEntity eventEntity) {
        EventRecurrence recurrence = event.getRecurrence();
        EventEntity storedEventEntity = (EventEntity)this.eventDAO.find(eventEntity.getId());
        if (storedEventEntity == null) {
            throw new IllegalStateException("Can't find event with id " + eventEntity.getId());
        }
        if (recurrence != null) {
            EventRecurrenceEntity eventRecurrenceEntity = EntityMapper.toEntity(event, recurrence);
            eventRecurrenceEntity.setEvent(eventEntity);
            if (storedEventEntity.getRecurrence() != null) {
                eventRecurrenceEntity.setId(storedEventEntity.getRecurrence().getId());
                eventRecurrenceEntity.setEvent(storedEventEntity);
                eventRecurrenceEntity = (EventRecurrenceEntity)this.eventRecurrenceDAO.update(eventRecurrenceEntity);
            } else {
                eventRecurrenceEntity.setId(null);
                eventRecurrenceEntity.setEvent(eventEntity);
                eventEntity.setRecurrence(eventRecurrenceEntity);
                eventRecurrenceEntity = (EventRecurrenceEntity)this.eventRecurrenceDAO.create(eventRecurrenceEntity);
            }
            eventEntity.setRecurrence(eventRecurrenceEntity);
        } else if (storedEventEntity.getRecurrence() != null) {
            this.eventRecurrenceDAO.delete(storedEventEntity.getRecurrence());
        }
    }

    private void createEventRecurrence(Event event, EventEntity eventEntity) {
        if (event.getRecurrence() != null) {
            EventRecurrenceEntity eventRecurrenceEntity = EntityMapper.toEntity(event, event.getRecurrence());
            eventRecurrenceEntity.setId(null);
            eventRecurrenceEntity.setEvent(eventEntity);
            eventEntity.setRecurrence(eventRecurrenceEntity);
            this.eventRecurrenceDAO.create(eventRecurrenceEntity);
        }
    }

    private Date getNowDate() {
        return AgendaDateUtils.toDate(ZonedDateTime.now(ZoneOffset.UTC));
    }

    static {
        AgendaEventStorage.ajc$preClinit();
        LOG = ExoLogger.getLogger(AgendaEventStorage.class);
    }

    static final /* synthetic */ void deleteEventById_aroundBody0(AgendaEventStorage ajc$this, long eventId, JoinPoint joinPoint) {
        ajc$this.eventDAO.deleteEvent(eventId);
    }

    static final /* synthetic */ void deleteCalendarEvents_aroundBody2(AgendaEventStorage ajc$this, long calendarId, JoinPoint joinPoint) {
        ajc$this.eventDAO.deleteCalendarEvents(calendarId);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AgendaEventStorage.java", AgendaEventStorage.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteEventById", "org.exoplatform.agenda.storage.AgendaEventStorage", "long", "eventId", "", "void"), 152);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteCalendarEvents", "org.exoplatform.agenda.storage.AgendaEventStorage", "long", "calendarId", "", "void"), 157);
    }
}

