/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.rest.builder;

import io.meeds.gamification.constant.IdentityType;
import io.meeds.gamification.constant.PeriodType;
import io.meeds.gamification.constant.RealizationStatus;
import io.meeds.gamification.model.ProgramDTO;
import io.meeds.gamification.model.RealizationDTO;
import io.meeds.gamification.model.RuleDTO;
import io.meeds.gamification.model.UserInfoContext;
import io.meeds.gamification.model.filter.RealizationFilter;
import io.meeds.gamification.rest.builder.ProgramBuilder;
import io.meeds.gamification.rest.builder.RealizationBuilder;
import io.meeds.gamification.rest.model.RealizationRestEntity;
import io.meeds.gamification.rest.model.RealizationValidityContext;
import io.meeds.gamification.rest.model.RuleRestEntity;
import io.meeds.gamification.service.ProgramService;
import io.meeds.gamification.service.RealizationService;
import io.meeds.gamification.service.RuleService;
import io.meeds.gamification.utils.Utils;
import io.meeds.social.translation.service.TranslationService;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.social.common.xmlprocessor.XMLProcessor;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.metadata.favorite.FavoriteService;
import org.exoplatform.social.metadata.favorite.model.Favorite;

public class RuleBuilder {
    private RuleBuilder() {
    }

    public static RuleRestEntity toRestEntity(ProgramService programService, RuleService ruleService, RealizationService realizationService, TranslationService translationService, FavoriteService favoriteService, IdentityManager identityManager, ActivityManager activityManager, XMLProcessor xmlProcessor, UserACL userAcl, RuleDTO rule, Locale locale, List<String> expandFields, int realizationsLimit, boolean noProgram, boolean anonymous, PeriodType periodType) {
        ProgramDTO program;
        if (rule == null) {
            return null;
        }
        boolean retrieveRealizations = realizationsLimit > 0;
        List<RealizationRestEntity> realizationEntities = null;
        if (retrieveRealizations && realizationService != null) {
            List<RealizationDTO> realizations = RuleBuilder.getRealizations(realizationService, rule.getId(), periodType, realizationsLimit);
            realizationEntities = RealizationBuilder.toRestEntities(programService, ruleService, translationService, identityManager, xmlProcessor, userAcl, realizations, Utils.getCurrentUser(), null);
        }
        boolean countRealizations = retrieveRealizations || expandFields != null && expandFields.contains("countRealizations");
        long realizationsCount = 0L;
        if (countRealizations && realizationService != null) {
            realizationsCount = RuleBuilder.countRealizations(realizationService, rule.getId(), periodType);
        }
        boolean hasPendingRealization = false;
        if (countRealizations && realizationService != null) {
            hasPendingRealization = RuleBuilder.hasPendingRealization(realizationService, rule.getId(), String.valueOf(Utils.getCurrentUserIdentityId()));
        }
        boolean isFavorite = !anonymous && expandFields != null && expandFields.contains("favorites") && favoriteService != null && favoriteService.isFavorite(new Favorite("rule", String.valueOf(rule.getId()), null, Utils.getCurrentUserIdentityId(), rule.getSpaceId()));
        boolean expandPrerequisites = expandFields != null && expandFields.contains("expandPrerequisites");
        List<RuleDTO> prerequisiteRules = ruleService.getPrerequisiteRules(rule.getId()).stream().map(r -> {
            if (expandPrerequisites) {
                return RuleBuilder.toRestEntity(programService, ruleService, realizationService, translationService, favoriteService, identityManager, activityManager, xmlProcessor, userAcl, r, locale, expandFields, realizationsLimit, noProgram, anonymous, periodType);
            }
            r.setProgram(null);
            return r;
        }).toList();
        ProgramDTO programDTO = program = noProgram ? null : rule.getProgram();
        if (anonymous && program != null) {
            program.setLastModifiedBy(null);
            program.setCreatedBy(null);
            program.setOwnerIds(null);
        }
        UserInfoContext userContext = realizationService == null ? null : RuleBuilder.toUserContext(programService, realizationService, rule, Utils.getCurrentUser());
        RuleBuilder.translatedLabels(translationService, rule, locale);
        return new RuleRestEntity(rule.getId(), rule.getTitle(), rule.getDescription(), rule.getScore(), program, rule.isEnabled(), rule.isDeleted(), anonymous ? null : rule.getCreatedBy(), rule.getCreatedDate(), anonymous ? null : rule.getLastModifiedBy(), rule.getEvent(), rule.getLastModifiedDate(), rule.getStartDate(), rule.getEndDate(), rule.getActivityId(), rule.getCacheTime(), !anonymous && activityManager != null && RuleBuilder.isPublished(activityManager, rule), isFavorite, rule.getPrerequisiteRuleIds(), rule.getType(), rule.getDefaultRealizationStatus(), rule.getRecurrence(), rule.getSpaceId(), rule.getManagers(), realizationEntities, realizationsCount, hasPendingRealization, userContext, prerequisiteRules);
    }

    public static void translatedLabels(TranslationService translationService, RuleDTO rule, Locale locale) {
        String translatedDescription;
        if (rule == null || locale == null) {
            return;
        }
        String translatedTitle = translationService.getTranslationLabelOrDefault("rule", rule.getId().longValue(), "title", locale);
        if (StringUtils.isNotBlank((CharSequence)translatedTitle)) {
            rule.setTitle(translatedTitle);
        }
        if (StringUtils.isNotBlank((CharSequence)(translatedDescription = translationService.getTranslationLabelOrDefault("rule", rule.getId().longValue(), "description", locale)))) {
            rule.setDescription(translatedDescription);
        }
        ProgramBuilder.translatedLabels(translationService, rule.getProgram(), locale);
    }

    public static UserInfoContext toUserContext(ProgramService programService, RealizationService realizationService, RuleDTO rule, String username) {
        UserInfoContext userContext = ProgramBuilder.toUserContext(programService, rule.getProgram(), username);
        RealizationValidityContext realizationRestriction = realizationService.getRealizationValidityContext(rule, Utils.getUserIdentityId(username));
        userContext.setContext(realizationRestriction);
        userContext.setAllowedToRealize(realizationRestriction.isValidForIdentity());
        return userContext;
    }

    private static List<RealizationDTO> getRealizations(RealizationService realizationService, long ruleId, PeriodType periodType, int limit) {
        if (limit > 0) {
            return realizationService.getRealizationsByFilter(RuleBuilder.getRealizationsFilter(ruleId, periodType), 0, limit);
        }
        return Collections.emptyList();
    }

    private static int countRealizations(RealizationService realizationService, long ruleId, PeriodType periodType) {
        return realizationService.countRealizationsByFilter(RuleBuilder.getRealizationsFilter(ruleId, periodType));
    }

    private static RealizationFilter getRealizationsFilter(long ruleId, PeriodType periodType) {
        return new RealizationFilter(null, "date", true, periodType.getFromDate(), periodType.getToDate(), IdentityType.USER, Collections.singletonList(RealizationStatus.ACCEPTED), Collections.singletonList(ruleId), null);
    }

    private static boolean hasPendingRealization(RealizationService realizationService, long ruleId, String userId) {
        return realizationService.hasPendingRealization(ruleId, userId);
    }

    private static boolean isPublished(ActivityManager activityManager, RuleDTO rule) {
        long activityId = rule.getActivityId();
        if (activityId <= 0L) {
            return false;
        }
        ExoSocialActivity activity = activityManager.getActivity(String.valueOf(activityId));
        return activity != null && !activity.isHidden();
    }
}

