/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.scheduled;

import io.meeds.gamification.model.ProgramDTO;
import io.meeds.gamification.model.filter.ProgramFilter;
import io.meeds.gamification.scheduled.ProgramAutoDisableJob$AjcClosure1;
import io.meeds.gamification.service.ProgramService;
import io.meeds.gamification.service.RuleService;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.persistence.impl.ExoTransactionalAspect;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

@DisallowConcurrentExecution
public class ProgramAutoDisableJob
implements Job {
    private static final Log LOG;
    private ProgramService programService = (ProgramService)ExoContainerContext.getService(ProgramService.class);
    private RuleService ruleService = (RuleService)ExoContainerContext.getService(RuleService.class);
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    @ExoTransactional
    public void execute(JobExecutionContext context) throws JobExecutionException {
        JobExecutionContext jobExecutionContext = context;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)jobExecutionContext);
        Object[] objectArray = new Object[]{this, jobExecutionContext, joinPoint};
        ProgramAutoDisableJob$AjcClosure1 programAutoDisableJob$AjcClosure1 = new ProgramAutoDisableJob$AjcClosure1(objectArray);
        ExoTransactionalAspect.aspectOf().around(programAutoDisableJob$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    public void checkAndChangeProgramStatus(long programId) {
        try {
            ProgramDTO program = this.programService.getProgramById(programId);
            if (program != null && program.isEnabled() && this.ruleService.countActiveRules(programId) == 0) {
                program.setEnabled(false);
                this.programService.updateProgram(program);
                LOG.info("Program {} switched automatically to disabled since no active rules", new Object[]{programId});
            }
        }
        catch (Exception e) {
            LOG.warn("Error while automatically switching program {} status", new Object[]{programId, e});
        }
    }

    static {
        ProgramAutoDisableJob.ajc$preClinit();
        LOG = ExoLogger.getLogger(ProgramAutoDisableJob.class);
    }

    static final /* synthetic */ void execute_aroundBody0(ProgramAutoDisableJob ajc$this, JobExecutionContext context, JoinPoint joinPoint) {
        List<Long> programIds = ajc$this.programService.getProgramIds(new ProgramFilter(true), 0, -1);
        programIds.forEach(ajc$this::checkAndChangeProgramStatus);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ProgramAutoDisableJob.java", ProgramAutoDisableJob.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "execute", "io.meeds.gamification.scheduled.ProgramAutoDisableJob", "org.quartz.JobExecutionContext", "context", "org.quartz.JobExecutionException", "void"), 58);
    }
}

