/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.api.navigation;

import org.exoplatform.portal.mop.navigation.NodeState;
import org.exoplatform.portal.mop.navigation.Scope;
import org.exoplatform.portal.mop.navigation.VisitMode;
import org.gatein.api.Util;
import org.gatein.api.internal.Parameters;
import org.gatein.api.navigation.NodePath;
import org.gatein.api.navigation.NodeVisitor;
import org.gatein.api.navigation.ObjectFactory;
import org.gatein.api.navigation.Visibility;
import org.gatein.api.page.PageId;

public class NodeVisitorScope
implements Scope {
    private final NodeVisitor visitor;

    public NodeVisitorScope(NodeVisitor visitor) {
        this.visitor = (NodeVisitor)Parameters.requireNonNull((Object)visitor, (String)"visitor");
    }

    public Scope.Visitor get() {
        return new NodeVisitorAdapter(this.visitor);
    }

    private static class NodeVisitorAdapter
    implements Scope.Visitor {
        private final NodeVisitor visitor;
        private NodePath nodePath;

        public NodeVisitorAdapter(NodeVisitor visitor) {
            this.visitor = visitor;
        }

        public VisitMode enter(int depth, String id, String name, NodeState state) {
            this.nodePath = depth == 0 ? NodePath.root() : this.nodePath.append(new String[]{name});
            String nodeName = depth == 0 ? null : name;
            NodeDetails details = depth == 0 ? null : new NodeDetails(state, this.nodePath);
            return this.visitor.visit(depth, nodeName, (NodeVisitor.NodeDetails)details) ? VisitMode.ALL_CHILDREN : VisitMode.NO_CHILDREN;
        }

        public void leave(int depth, String id, String name, NodeState state) {
            this.nodePath = this.nodePath.parent();
        }
    }

    private static class NodeDetails
    implements NodeVisitor.NodeDetails {
        private NodeState nodeState;
        private NodePath nodePath;

        public NodeDetails(NodeState nodeState, NodePath nodePath) {
            this.nodeState = nodeState;
            this.nodePath = nodePath;
        }

        public Visibility getVisibility() {
            return ObjectFactory.createVisibility(this.nodeState);
        }

        public String getIconName() {
            return this.nodeState.getIcon();
        }

        public PageId getPageId() {
            return Util.from(this.nodeState.getPageRef());
        }

        public NodePath getNodePath() {
            return this.nodePath;
        }
    }
}

