/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.oauth.web;

import io.meeds.oauth.exception.OAuthException;
import io.meeds.oauth.exception.OAuthExceptionCode;
import io.meeds.oauth.spi.OAuthPrincipal;
import io.meeds.oauth.spi.SocialNetworkService;
import io.meeds.oauth.utils.OAuthUtils;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.gatein.sso.agent.filter.api.AbstractSSOInterceptor;

public class OAuthLinkAccountFilter
extends AbstractSSOInterceptor {
    private static Log log = ExoLogger.getLogger(OAuthLinkAccountFilter.class);
    private SocialNetworkService socialNetworkService;

    protected void initImpl() {
        this.socialNetworkService = (SocialNetworkService)this.getExoContainer().getComponentInstanceOfType(SocialNetworkService.class);
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        HttpSession session = httpRequest.getSession();
        if (httpRequest.getRemoteUser() == null) {
            chain.doFilter(request, response);
            return;
        }
        OAuthPrincipal oauthPrincipal = (OAuthPrincipal)request.getAttribute("_authenticatedOAuthPrincipal");
        if (oauthPrincipal == null) {
            chain.doFilter(request, response);
            return;
        }
        try {
            this.socialNetworkService.updateOAuthInfo(oauthPrincipal.getOauthProviderType(), httpRequest.getRemoteUser(), oauthPrincipal.getUserName(), oauthPrincipal.getAccessToken());
            session.setAttribute("_linkedOAuthProviderUsernameAttrName", (Object)oauthPrincipal.getOauthProviderType().getFriendlyName());
        }
        catch (OAuthException gtnOauthOAuthException) {
            if (gtnOauthOAuthException.getExceptionCode() == OAuthExceptionCode.DUPLICATE_OAUTH_PROVIDER_USERNAME) {
                session.setAttribute("_oauthExceptionAfterFailedLink", (Object)gtnOauthOAuthException);
            }
            throw gtnOauthOAuthException;
        }
        String urlToRedirect = OAuthUtils.getURLToRedirectAfterLinkAccount(httpRequest, session);
        if (log.isTraceEnabled()) {
            log.trace((Object)("User profile successfully updated with new userName and accessToken. oauthProvider=" + String.valueOf(oauthPrincipal.getOauthProviderType()) + ", username=" + httpRequest.getRemoteUser() + ", oauthUsername=" + oauthPrincipal.getUserName()));
            log.trace((Object)("Will redirect user to URL: " + urlToRedirect));
        }
        httpResponse.sendRedirect(httpResponse.encodeRedirectURL(urlToRedirect));
    }
}

