/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing.provider;

import javax.xml.bind.annotation.XmlTransient;
import org.apache.sis.internal.referencing.provider.AbstractMercator;
import org.apache.sis.internal.referencing.provider.LambertConformal2SP;
import org.apache.sis.internal.referencing.provider.Mercator1SP;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.measure.Units;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.operation.projection.NormalizedProjection;
import org.opengis.metadata.citation.Citation;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;

@XmlTransient
public final class TransverseMercator
extends AbstractMercator {
    private static final long serialVersionUID = -3386587506686432398L;
    public static final String NAME = "Transverse Mercator";
    public static final ParameterDescriptor<Double> LATITUDE_OF_ORIGIN;
    public static final ParameterDescriptor<Double> LONGITUDE_OF_ORIGIN;
    public static final ParameterDescriptor<Double> SCALE_FACTOR;
    static final ParameterDescriptorGroup PARAMETERS;

    public TransverseMercator() {
        super(PARAMETERS);
    }

    @Override
    protected NormalizedProjection createProjection(Parameters parameters) {
        return new org.apache.sis.referencing.operation.projection.TransverseMercator(this, parameters);
    }

    static {
        ParameterBuilder parameterBuilder = TransverseMercator.builder();
        LATITUDE_OF_ORIGIN = TransverseMercator.createLatitude((ParameterBuilder)parameterBuilder.addNamesAndIdentifiers((IdentifiedObject)Mercator1SP.LATITUDE_OF_ORIGIN), true);
        LONGITUDE_OF_ORIGIN = TransverseMercator.createLongitude(TransverseMercator.renameAlias(parameterBuilder, Mercator1SP.LONGITUDE_OF_ORIGIN, (Citation)Citations.NETCDF, LambertConformal2SP.LONGITUDE_OF_FALSE_ORIGIN));
        SCALE_FACTOR = TransverseMercator.createScale((ParameterBuilder)((ParameterBuilder)parameterBuilder.addNamesAndIdentifiers((IdentifiedObject)Mercator1SP.SCALE_FACTOR)).rename((Citation)Citations.NETCDF, "scale_factor_at_central_meridian"));
        PARAMETERS = ((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)parameterBuilder.addIdentifier("9807")).addName(NAME)).addName("Gauss-Kruger")).addName("Gauss-Boaga")).addName("TM")).addName((Citation)Citations.OGC, "Transverse_Mercator")).addName((Citation)Citations.ESRI, "Transverse_Mercator")).addName((Citation)Citations.ESRI, "Gauss_Kruger")).addName((Citation)Citations.NETCDF, "TransverseMercator")).addName((Citation)Citations.GEOTIFF, "CT_TransverseMercator")).addName((Citation)Citations.S57, NAME)).addName((Citation)Citations.S57, "TME")).addName((Citation)Citations.PROJ4, "tmerc")).addIdentifier((Citation)Citations.GEOTIFF, "1")).addIdentifier((Citation)Citations.MAP_INFO, "8")).addIdentifier((Citation)Citations.S57, "13")).createGroupForMapProjection(LATITUDE_OF_ORIGIN, LONGITUDE_OF_ORIGIN, SCALE_FACTOR, FALSE_EASTING, FALSE_NORTHING);
    }

    public static enum Zoner {
        UTM(-180.0, 6.0, 0.9996, 500000.0, 1.0E7){

            @Override
            public int zone(double d, double d2) {
                int n = super.zone(d, d2);
                switch (n) {
                    case 31: {
                        if (!1.isNorway(d) || !(d2 >= 3.0)) break;
                        ++n;
                        break;
                    }
                    case 32: {
                        if (!1.isSvalbard(d)) break;
                        if (d2 >= 9.0) {
                            ++n;
                            break;
                        }
                        --n;
                        break;
                    }
                    case 34: {
                        if (!1.isSvalbard(d)) break;
                        if (d2 >= 21.0) {
                            ++n;
                            break;
                        }
                        --n;
                        break;
                    }
                    case 36: {
                        if (!1.isSvalbard(d)) break;
                        if (d2 >= 33.0) {
                            ++n;
                            break;
                        }
                        --n;
                    }
                }
                return n;
            }

            @Override
            public boolean isSpecialCase(int n, double d) {
                if (n >= 31 && n <= 37) {
                    return 1.isSvalbard(d) || n <= 32 && 1.isNorway(d);
                }
                return false;
            }

            @Override
            public boolean isSpecialCase(double d, double d2, double d3, double d4) {
                if (d2 >= 56.0 && d < 84.0) {
                    return super.zone(0.0, d4) >= 31 && super.zone(0.0, d3) <= 37;
                }
                return false;
            }
        }
        ,
        MTM(-51.5, -3.0, 0.9999, 304800.0, Double.NaN),
        ANY(-180.0, 6.0, 0.9996, 500000.0, 1.0E7);

        public final double origin;
        public final double width;
        public final double scale;
        public final double easting;
        public final double northing;
        public static final double SOUTH_BOUNDS = -80.0;
        private static final double NORWAY_BOUNDS = 56.0;
        public static final double SVALBARD_BOUNDS = 72.0;
        public static final double NORTH_BOUNDS = 84.0;

        private Zoner(double d, double d2, double d3, double d4, double d5) {
            this.origin = d;
            this.width = d2;
            this.scale = d3;
            this.easting = d4;
            this.northing = d5;
        }

        public final String setParameters(ParameterValueGroup parameterValueGroup, double d, double d2) {
            String string;
            boolean bl = MathFunctions.isNegative((double)d);
            int n = this.zone(d, d2);
            if (this == ANY) {
                string = "UTM";
                if (d != 0.0 || d2 != this.centralMeridian(n)) {
                    string = TransverseMercator.NAME;
                    n = 0;
                }
            } else {
                string = this.name();
                d = 0.0;
                d2 = this.centralMeridian(n);
            }
            if (n != 0) {
                string = string + " zone " + n + (bl ? (char)'S' : 'N');
            }
            parameterValueGroup.parameter("latitude_of_origin").setValue(d, Units.DEGREE);
            parameterValueGroup.parameter("central_meridian").setValue(d2, Units.DEGREE);
            parameterValueGroup.parameter("scale_factor").setValue(this.scale, Units.UNITY);
            parameterValueGroup.parameter("false_easting").setValue(this.easting, Units.METRE);
            parameterValueGroup.parameter("false_northing").setValue(bl ? this.northing : 0.0, Units.METRE);
            return string;
        }

        public final int zone(ParameterValueGroup parameterValueGroup) {
            int n;
            double d;
            boolean bl;
            if (Numerics.epsilonEqual((double)parameterValueGroup.parameter("scale_factor").doubleValue(Units.UNITY), (double)this.scale, (double)1.0E-13) && Numerics.epsilonEqual((double)parameterValueGroup.parameter("false_easting").doubleValue(Units.METRE), (double)this.easting, (double)0.01) && Numerics.epsilonEqual((double)parameterValueGroup.parameter("latitude_of_origin").doubleValue(Units.DEGREE), (double)0.0, (double)8.999280057595393E-8) && ((bl = Numerics.epsilonEqual((double)(d = parameterValueGroup.parameter("false_northing").doubleValue(Units.METRE)), (double)0.0, (double)0.01)) || Numerics.epsilonEqual((double)d, (double)this.northing, (double)0.01)) && Numerics.epsilonEqual((double)this.centralMeridian(n = this.zone(0.0, d = parameterValueGroup.parameter("central_meridian").doubleValue(Units.DEGREE))), (double)d, (double)8.999280057595393E-8)) {
                if (!bl) {
                    n = -n;
                }
                return n;
            }
            return 0;
        }

        public int zone(double d, double d2) {
            double d3 = (d2 - this.origin) / this.width;
            double d4 = 360.0 / this.width;
            d3 -= Math.floor(d3 / d4) * d4;
            return (int)(d3 + 1.0);
        }

        public final int zoneCount() {
            return (int)(360.0 / this.width);
        }

        public final double centralMeridian(int n) {
            return ((double)n - 0.5) * this.width + this.origin;
        }

        public boolean isSpecialCase(int n, double d) {
            return false;
        }

        public boolean isSpecialCase(double d, double d2, double d3, double d4) {
            return false;
        }

        public static boolean isNorway(double d) {
            return d >= 56.0 && d < 64.0;
        }

        public static boolean isSvalbard(double d) {
            return d >= 72.0 && d < 84.0;
        }
    }
}

