/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation;

import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.jaxb.Context;
import org.apache.sis.internal.jaxb.referencing.CC_OperationMethod;
import org.apache.sis.internal.jaxb.referencing.CC_OperationParameterGroup;
import org.apache.sis.internal.metadata.Identifiers;
import org.apache.sis.internal.metadata.MetadataUtilities;
import org.apache.sis.internal.referencing.ReferencingUtilities;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.parameter.DefaultParameterValueGroup;
import org.apache.sis.parameter.Parameterized;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.operation.AbstractCoordinateOperation;
import org.apache.sis.referencing.operation.DefaultConversion;
import org.apache.sis.referencing.operation.DefaultOperationMethod;
import org.apache.sis.referencing.operation.DefaultTransformation;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.collection.Containers;
import org.opengis.metadata.Identifier;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.SingleOperation;
import org.opengis.util.FactoryException;

@XmlType(name="AbstractSingleOperationType", propOrder={"method", "parameters"})
@XmlRootElement(name="AbstractSingleOperation")
@XmlSeeAlso(value={DefaultConversion.class, DefaultTransformation.class})
class AbstractSingleOperation
extends AbstractCoordinateOperation
implements SingleOperation,
Parameterized {
    private static final long serialVersionUID = -2635450075620911309L;
    private OperationMethod method;
    ParameterValueGroup parameters;

    public AbstractSingleOperation(Map<String, ?> map, CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2, CoordinateReferenceSystem coordinateReferenceSystem3, OperationMethod operationMethod, MathTransform mathTransform) {
        super(map, coordinateReferenceSystem, coordinateReferenceSystem2, coordinateReferenceSystem3, mathTransform);
        ArgumentChecks.ensureNonNull((String)"method", (Object)operationMethod);
        ArgumentChecks.ensureNonNull((String)"transform", (Object)mathTransform);
        this.method = operationMethod;
        this.parameters = Parameters.unmodifiable((ParameterValueGroup)Containers.property(map, (Object)"parameters", ParameterValueGroup.class));
    }

    AbstractSingleOperation(Map<String, ?> map, OperationMethod operationMethod) {
        super(map);
        ArgumentChecks.ensureNonNull((String)"method", (Object)operationMethod);
        this.method = operationMethod;
    }

    protected AbstractSingleOperation(SingleOperation singleOperation) {
        super((CoordinateOperation)singleOperation);
        this.method = singleOperation.getMethod();
        this.parameters = Parameters.unmodifiable(singleOperation.getParameterValues());
    }

    @Override
    @XmlElement(name="method", required=true)
    public OperationMethod getMethod() {
        return this.method;
    }

    @Override
    public ParameterDescriptorGroup getParameterDescriptors() {
        return this.parameters != null ? this.parameters.getDescriptor() : super.getParameterDescriptors();
    }

    @Override
    public ParameterValueGroup getParameterValues() {
        return this.parameters != null ? this.parameters : super.getParameterValues();
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object, comparisonMode)) {
            return false;
        }
        switch (comparisonMode) {
            case STRICT: {
                AbstractSingleOperation abstractSingleOperation = (AbstractSingleOperation)object;
                return Objects.equals(this.method, abstractSingleOperation.method) && Objects.equals(this.parameters, abstractSingleOperation.parameters);
            }
            case BY_CONTRACT: {
                SingleOperation singleOperation = (SingleOperation)object;
                return Utilities.deepEquals((Object)this.getMethod(), (Object)singleOperation.getMethod(), (ComparisonMode)comparisonMode) && Utilities.deepEquals((Object)this.getParameterValues(), (Object)singleOperation.getParameterValues(), (ComparisonMode)comparisonMode);
            }
        }
        return true;
    }

    AbstractSingleOperation() {
    }

    private void setMethod(OperationMethod operationMethod) {
        if (this.method == null) {
            this.method = operationMethod;
        } else {
            MetadataUtilities.propertyAlreadySet(AbstractSingleOperation.class, (String)"setMethod", (String)"method");
        }
    }

    @XmlElement(name="parameterValue")
    private GeneralParameterValue[] getParameters() {
        List list;
        if (this.parameters != null && (list = this.parameters.values()) != null) {
            return CC_OperationMethod.filterImplicit(list.toArray(new GeneralParameterValue[list.size()]));
        }
        return null;
    }

    private void setParameters(GeneralParameterValue[] generalParameterValueArray) {
        if (this.parameters == null) {
            if (!(this.method instanceof DefaultOperationMethod)) {
                throw new IllegalStateException(Identifiers.missingValueForProperty((Identifier)this.getName(), (String)"method"));
            }
            IdentityHashMap<GeneralParameterDescriptor, GeneralParameterDescriptor> identityHashMap = new IdentityHashMap<GeneralParameterDescriptor, GeneralParameterDescriptor>(4);
            GeneralParameterDescriptor[] generalParameterDescriptorArray = CC_OperationParameterGroup.merge(this.method.getParameters().descriptors(), Parameters.getDescriptors(generalParameterValueArray), identityHashMap);
            for (int i = 0; i < generalParameterDescriptorArray.length; ++i) {
                if (generalParameterDescriptorArray[i] == generalParameterValueArray[i].getDescriptor()) continue;
                ((DefaultOperationMethod)this.method).updateDescriptors(generalParameterDescriptorArray);
                break;
            }
            this.parameters = new DefaultParameterValueGroup(this.method.getParameters());
            CC_OperationMethod.store(generalParameterValueArray, this.parameters.values(), identityHashMap);
            this.parameters = Parameters.unmodifiable(this.parameters);
        } else {
            MetadataUtilities.propertyAlreadySet(AbstractSingleOperation.class, (String)"setParameters", (String)"parameterValue");
        }
    }

    @Override
    final void afterUnmarshal(Unmarshaller unmarshaller, Object object) {
        super.afterUnmarshal(unmarshaller, object);
        CoordinateReferenceSystem coordinateReferenceSystem = super.getSourceCRS();
        CoordinateReferenceSystem coordinateReferenceSystem2 = super.getTargetCRS();
        if (this.transform == null && coordinateReferenceSystem != null && coordinateReferenceSystem2 != null && this.parameters != null) {
            try {
                this.transform = ReferencingUtilities.createBaseToDerived((MathTransformFactory)DefaultFactories.forBuildin(MathTransformFactory.class), coordinateReferenceSystem, this.parameters, coordinateReferenceSystem2);
            }
            catch (FactoryException factoryException) {
                Context.warningOccured((Context)Context.current(), AbstractSingleOperation.class, (String)"afterUnmarshal", (Exception)((Object)factoryException), (boolean)true);
            }
        }
    }
}

