/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.content.image.plugin;

import io.meeds.social.cms.model.CMSSetting;
import io.meeds.social.cms.service.CMSService;
import jakarta.annotation.PostConstruct;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.attachment.AttachmentPlugin;
import org.exoplatform.social.attachment.AttachmentService;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ImageAttachmentPlugin
extends AttachmentPlugin {
    public static final String OBJECT_TYPE = "imagePortlet";
    @Autowired
    private CMSService cmsService;
    @Autowired
    private IdentityManager identityManager;
    @Autowired
    private SpaceService spaceService;
    @Autowired
    private AttachmentService attachmentService;

    @PostConstruct
    public void init() {
        this.attachmentService.addPlugin((AttachmentPlugin)this);
    }

    public String getObjectType() {
        return OBJECT_TYPE;
    }

    public boolean hasAccessPermission(Identity userIdentity, String settingName) throws ObjectNotFoundException {
        return this.cmsService.hasAccessPermission(userIdentity, OBJECT_TYPE, settingName);
    }

    public boolean hasEditPermission(Identity userIdentity, String settingName) throws ObjectNotFoundException {
        return this.cmsService.hasEditPermission(userIdentity, OBJECT_TYPE, settingName);
    }

    public long getAudienceId(String settingName) throws ObjectNotFoundException {
        Space space;
        long spaceId = this.getSpaceId(settingName);
        if (spaceId > 0L && (space = this.spaceService.getSpaceById(String.valueOf(spaceId))) != null) {
            return Long.parseLong(this.identityManager.getOrCreateSpaceIdentity(space.getPrettyName()).getId());
        }
        return 0L;
    }

    public long getSpaceId(String settingName) throws ObjectNotFoundException {
        CMSSetting setting = this.cmsService.getSetting(OBJECT_TYPE, settingName);
        return setting == null ? 0L : setting.getSpaceId();
    }
}

